/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.ResettableEventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceChangeEvent;
import com.google.gwt.place.shared.PlaceHistoryMapper;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.explorer.AcceptTabItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.MultiActivityManager;
import org.drools.guvnor.client.packages.ClosePlaceEvent;
import org.drools.guvnor.client.util.Activity;
import org.drools.guvnor.client.util.ActivityMapper;
import org.drools.guvnor.client.util.TabbedPanel;

public class MultiActivityManager
implements PlaceChangeEvent.Handler,
ClosePlaceEvent.Handler {
    private final ActivityMapper activityMapper;
    private TabbedPanel tabbedPanel;
    private final EventBus eventBus;
    private PlaceHistoryMapper placeHistoryMapper;
    private final Map<Place, Pair> activeActivities = new HashMap();
    private final ClientFactory clientFactory;

    public MultiActivityManager(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.activityMapper = clientFactory.getActivityMapper();
        this.placeHistoryMapper = clientFactory.getPlaceHistoryMapper();
        this.eventBus = clientFactory.getEventBus();
        this.eventBus.addHandler(PlaceChangeEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(ClosePlaceEvent.TYPE, (EventHandler)this);
    }

    public void setTabbedPanel(TabbedPanel tabbedPanel) {
        if (this.tabbedPanel != null) {
            throw new IllegalStateException(TabbedPanel.class.getName() + " can only be set once.");
        }
        this.tabbedPanel = tabbedPanel;
    }

    public void onPlaceChange(PlaceChangeEvent event) {
        if (this.tabbedPanel == null) {
            throw new IllegalStateException(TabbedPanel.class.getName() + " is not set for " + MultiActivityManager.class.getName());
        }
        if (this.isActivityAlreadyActive(event.getNewPlace())) {
            this.showExistingActivity(event.getNewPlace());
        } else if (this.ifPlaceExists(event)) {
            this.startNewActivity(event.getNewPlace());
        }
    }

    private void showExistingActivity(Place token) {
        this.tabbedPanel.show(token);
    }

    private boolean isActivityAlreadyActive(Place token) {
        return this.activeActivities.keySet().contains(token);
    }

    private void startNewActivity(Place newPlace) {
        Activity activity = this.activityMapper.getActivity(newPlace);
        ResettableEventBus resettableEventBus = new ResettableEventBus(this.eventBus);
        this.activeActivities.put(newPlace, new Pair(this, activity, resettableEventBus));
        activity.start((AcceptTabItem)new /* Unavailable Anonymous Inner Class!! */, (EventBus)resettableEventBus);
    }

    private boolean ifPlaceExists(PlaceChangeEvent event) {
        return !event.getNewPlace().equals(Place.NOWHERE);
    }

    public void onCloseTab(ClosePlaceEvent closePlaceEvent) {
        Pair pair = (Pair)this.activeActivities.get(closePlaceEvent.getPlace());
        if (pair != null && pair.getActivity().mayStop()) {
            pair.getActivity().onStop();
            pair.getResettableEventBus().removeHandlers();
            this.activeActivities.remove(closePlaceEvent.getPlace());
            this.tabbedPanel.close(closePlaceEvent.getPlace());
        }
    }

    static /* synthetic */ TabbedPanel access$000(MultiActivityManager x0) {
        return x0.tabbedPanel;
    }
}

