/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.admin.ArchivedAssetManager;
import org.drools.guvnor.client.admin.BackupManager;
import org.drools.guvnor.client.admin.CategoryManager;
import org.drools.guvnor.client.admin.EventLogPresenter;
import org.drools.guvnor.client.admin.EventLogViewImpl;
import org.drools.guvnor.client.admin.PermissionViewer;
import org.drools.guvnor.client.admin.PerspectivesManager;
import org.drools.guvnor.client.admin.PerspectivesManagerView;
import org.drools.guvnor.client.admin.PerspectivesManagerViewImpl;
import org.drools.guvnor.client.admin.RepoConfigManager;
import org.drools.guvnor.client.admin.RuleVerifierManager;
import org.drools.guvnor.client.admin.StateManager;
import org.drools.guvnor.client.admin.WorkspaceManager;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.AcceptTabItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.ConfigurationService;
import org.drools.guvnor.client.rpc.ConfigurationServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.util.Activity;

public class ManagerActivity
extends Activity {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private final int id;
    private final ClientFactory clientFactory;

    public ManagerActivity(int id, ClientFactory clientFactory) {
        this.id = id;
        this.clientFactory = clientFactory;
    }

    public void start(AcceptTabItem tabbedPanel, EventBus eventBus) {
        this.openAdministrationSelection(tabbedPanel, this.id);
    }

    public void openAdministrationSelection(AcceptTabItem tabbedPanel, int id) {
        switch (id) {
            case 0: {
                tabbedPanel.addTab(this.constants.CategoryManager(), (IsWidget)new CategoryManager());
                break;
            }
            case 1: {
                tabbedPanel.addTab(this.constants.ArchivedManager(), (IsWidget)new ArchivedAssetManager(this.clientFactory));
                break;
            }
            case 2: {
                tabbedPanel.addTab(this.constants.StateManager(), (IsWidget)new StateManager());
                break;
            }
            case 3: {
                tabbedPanel.addTab(this.constants.ImportExport(), (IsWidget)new BackupManager());
                break;
            }
            case 4: {
                EventLogViewImpl eventLogView = new EventLogViewImpl();
                RepositoryServiceAsync repositoryService = RepositoryServiceFactory.getService();
                new EventLogPresenter(repositoryService, (EventLogPresenter.EventLogView)eventLogView);
                tabbedPanel.addTab(this.constants.EventLog(), (IsWidget)eventLogView);
                break;
            }
            case 5: {
                tabbedPanel.addTab(this.constants.UserPermissionMappings(), (IsWidget)new PermissionViewer());
                break;
            }
            case 6: {
                Frame aboutInfoFrame = new Frame("../AboutInfo.html");
                FormStylePopup aboutPop = new FormStylePopup();
                aboutPop.setWidth("600px");
                aboutPop.setTitle(this.constants.About());
                String hhurl = GWT.getModuleBaseURL() + "webdav";
                aboutPop.addAttribute(this.constants.WebDAVURL() + ":", (Widget)new SmallLabel("<b>" + hhurl + "</b>"));
                aboutPop.addAttribute(this.constants.Version() + ":", (Widget)aboutInfoFrame);
                aboutPop.show();
                break;
            }
            case 7: {
                tabbedPanel.addTab(this.constants.RulesVerificationManager(), (IsWidget)new RuleVerifierManager());
                break;
            }
            case 8: {
                tabbedPanel.addTab(this.constants.RepositoryConfig(), (IsWidget)new RepoConfigManager());
                break;
            }
            case 9: {
                tabbedPanel.addTab(this.constants.Workspaces(), (IsWidget)new WorkspaceManager());
                break;
            }
            case 10: {
                this.openPerspectivesManager(tabbedPanel);
            }
        }
    }

    private void openPerspectivesManager(AcceptTabItem tabbedPanel) {
        PerspectivesManagerViewImpl perspectivesManagerView = new PerspectivesManagerViewImpl();
        new PerspectivesManager((ConfigurationServiceAsync)GWT.create(ConfigurationService.class), (PerspectivesManagerView)perspectivesManagerView);
        tabbedPanel.addTab(this.constants.PerspectivesConfiguration(), (IsWidget)perspectivesManagerView);
    }
}

