/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.browse;

import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsTreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.configurations.UserCapabilities;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.FindPlace;
import org.drools.guvnor.client.explorer.navigation.browse.BrowseTreeView;
import org.drools.guvnor.client.explorer.navigation.browse.CategoryPlace;
import org.drools.guvnor.client.explorer.navigation.browse.InboxPlace;
import org.drools.guvnor.client.explorer.navigation.browse.StatePlace;

public class BrowseTree
implements BrowseTreeView.Presenter {
    private final BrowseTreeView view;
    private final ClientFactory clientFactory;
    private final Map<IsTreeItem, String> categories = new HashMap();
    private final List<IsTreeItem> states = new ArrayList();
    private IsTreeItem incomingInboxTreeItem;
    private IsTreeItem statesRootTreeItem;
    private IsTreeItem findRootTreeItem;
    private IsTreeItem inboxRecentlyEditedTreeItem;
    private IsTreeItem inboxRecentlyViewedTreeItem;
    private IsTreeItem root;
    private IsTreeItem categoriesRootItem;

    public BrowseTree(ClientFactory clientFactory) {
        this.view = clientFactory.getNavigationViewFactory().getBrowseTreeView();
        this.clientFactory = clientFactory;
        this.view.setPresenter((BrowseTreeView.Presenter)this);
        if (this.canShowMenu()) {
            this.view.showMenu();
        }
        this.root = this.view.addRootTreeItem();
        this.addInbox();
        this.findRootTreeItem = this.view.addFind();
        if (this.canShowStates()) {
            this.statesRootTreeItem = this.view.addRootStateTreeItem();
        }
        this.addRootCategory();
    }

    private void addInbox() {
        this.incomingInboxTreeItem = this.view.addInboxIncomingTreeItem();
        this.inboxRecentlyEditedTreeItem = this.view.addInboxRecentEditedTreeItem();
        this.inboxRecentlyViewedTreeItem = this.view.addInboxRecentViewedTreeItem();
    }

    private boolean canShowStates() {
        return UserCapabilities.INSTANCE.hasCapability(new Capability[]{Capability.SHOW_KNOWLEDGE_BASES_VIEW});
    }

    private boolean canShowMenu() {
        return UserCapabilities.INSTANCE.hasCapability(new Capability[]{Capability.SHOW_CREATE_NEW_ASSET});
    }

    private void addRootCategory() {
        this.categoriesRootItem = this.view.addRootCategoryTreeItem();
        this.categories.put(this.categoriesRootItem, "/");
    }

    private void addCategoryItem(String categoryName, IsTreeItem treeItem) {
        IsTreeItem subItem = this.view.addTreeItem(treeItem, categoryName);
        String path = this.getItemPath(categoryName, (String)this.categories.get(treeItem));
        this.categories.put(subItem, path);
    }

    private String getItemPath(String categoryName, String parentItemPath) {
        String path = this.isParentRoot(parentItemPath) ? parentItemPath + categoryName : parentItemPath + "/" + categoryName;
        return path;
    }

    private boolean isParentRoot(String parentItemPath) {
        return parentItemPath.equals("/");
    }

    private void addSubStatesToTreeItem() {
        this.view.removeStates();
        this.clientFactory.getRepositoryService().listStates((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public BrowseTreeView getView() {
        return this.view;
    }

    public void onTreeItemSelection(IsTreeItem selectedItem, String title) {
        if (this.states.contains(selectedItem)) {
            this.goTo((Place)new StatePlace(title));
        } else if (this.categories.containsKey(selectedItem)) {
            this.goTo((Place)new CategoryPlace((String)this.categories.get(selectedItem)));
        } else if (selectedItem.equals(this.incomingInboxTreeItem)) {
            this.goTo((Place)new InboxPlace("incoming"));
        } else if (selectedItem.equals(this.inboxRecentlyEditedTreeItem)) {
            this.goTo((Place)new InboxPlace("recentEdited"));
        } else if (selectedItem.equals(this.inboxRecentlyViewedTreeItem)) {
            this.goTo((Place)new InboxPlace("recentViewed"));
        } else if (selectedItem.equals(this.findRootTreeItem)) {
            this.clientFactory.getPlaceController().goTo((Place)new FindPlace());
        }
    }

    private void goTo(Place newPlace) {
        this.clientFactory.getPlaceController().goTo(newPlace);
    }

    public void onTreeItemOpen(IsTreeItem openedItem) {
        if (this.root.equals(openedItem)) {
            if (this.canShowStates()) {
                this.addSubStatesToTreeItem();
            }
            this.view.removeCategories(this.categoriesRootItem);
            this.loadCategories(this.categoriesRootItem);
        } else if (this.categories.containsKey(openedItem)) {
            Collection children = this.view.getChildren(openedItem);
            for (IsTreeItem child : children) {
                this.view.removeCategories(child);
                this.loadCategories(child);
            }
        }
    }

    private void loadCategories(IsTreeItem treeItem) {
        String path = (String)this.categories.get(treeItem);
        this.clientFactory.getCategoryService().loadChildCategories(path, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ BrowseTreeView access$000(BrowseTree x0) {
        return x0.view;
    }

    static /* synthetic */ List access$100(BrowseTree x0) {
        return x0.states;
    }

    static /* synthetic */ void access$200(BrowseTree x0, String x1, IsTreeItem x2) {
        x0.addCategoryItem(x1, x2);
    }
}

