/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.modules;

import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.ui.IsTreeItem;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.modules.Folder;
import org.drools.guvnor.client.explorer.navigation.modules.ModuleTreeItem;
import org.drools.guvnor.client.explorer.navigation.modules.ModuleTreeSelectableItem;
import org.drools.guvnor.client.explorer.navigation.modules.ModulesTreeItemBaseView;
import org.drools.guvnor.client.explorer.navigation.modules.PackageHierarchicalView;
import org.drools.guvnor.client.explorer.navigation.modules.PackageView;
import org.drools.guvnor.client.rpc.PackageConfigData;

public abstract class ModulesTreeItemBase
implements IsWidget,
ModulesTreeItemBaseView.Presenter {
    protected PackageView packageHierarchy = new PackageHierarchicalView();
    protected ClientFactory clientFactory;
    protected ModulesTreeItemBaseView view;

    public ModulesTreeItemBase(ClientFactory clientFactory, ModulesTreeItemBaseView view) {
        this.view = view;
        view.setPresenter((ModulesTreeItemBaseView.Presenter)this);
        this.clientFactory = clientFactory;
        this.setUpRootItem();
    }

    protected void setUpRootItem() {
        this.fillModulesTree(this.view.addModulesTreeItem());
    }

    protected abstract void fillModulesTree(IsTreeItem var1);

    public void onModuleSelected(Object userObject) {
        if (userObject instanceof Place) {
            this.clientFactory.getPlaceController().goTo((Place)userObject);
        }
    }

    protected void addModules(PackageConfigData[] packageConfigDatas, IsTreeItem treeItem) {
        for (PackageConfigData packageConfigData : packageConfigDatas) {
            this.packageHierarchy.addPackage(packageConfigData);
        }
        Folder rootFolder = this.packageHierarchy.getRootFolder();
        for (Folder childFolder : rootFolder.getChildren()) {
            this.createModuleTreeItem(treeItem, childFolder);
        }
    }

    protected ModuleTreeItem createModuleTreeItem(IsTreeItem treeItem, Folder folder) {
        Object mti = null;
        String folderName = folder.getFolderName();
        PackageConfigData conf = folder.getPackageConfigData();
        mti = conf != null ? new ModuleTreeSelectableItem(this.clientFactory, this.view.addModuleTreeSelectableItem(treeItem, folderName), conf) : new ModuleTreeItem(this.clientFactory, this.view.addModuleTreeItem(treeItem, folderName));
        for (Folder childFolder : folder.getChildren()) {
            this.createModuleTreeItem(mti.getRootItem(), childFolder).getRootItem();
        }
        return mti;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }
}

