/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.RuleSelectionEvent;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioHelper;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioWidgetComponentCreator;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.TestRunnerWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.EditorWidget;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.CallFixtureMap;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.FixtureList;
import org.drools.ide.common.client.modeldriven.testing.FixturesMap;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;

public class ScenarioWidget
extends Composite
implements EditorWidget {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private String[] availableRules;
    protected final SuggestionCompletionEngine suggestionCompletionEngine;
    private final VerticalPanel layout = new VerticalPanel();
    private HandlerRegistration availableRulesHandlerRegistration;
    private ScenarioWidgetComponentCreator scenarioWidgetComponentCreator;

    public ScenarioWidget(RuleAsset asset, RuleViewer viewer, ClientFactory clientFactory) {
        this(asset);
    }

    public ScenarioWidget(RuleAsset asset) {
        this.scenarioWidgetComponentCreator = new ScenarioWidgetComponentCreator(asset, this);
        this.setShowResults(false);
        this.suggestionCompletionEngine = SuggestionCompletionCache.getInstance().getEngineFromCache(asset.getMetaData().getPackageName());
        this.ifFixturesSizeZeroThenAddExecutionTrace();
        if (!asset.isReadonly()) {
            this.layout.add((Widget)new TestRunnerWidget(this, asset.getMetaData().getPackageName()));
        }
        this.renderEditor();
        this.initWidget((Widget)this.layout);
        this.setStyleName("scenario-Viewer");
        this.layout.setWidth("100%");
    }

    private void ifFixturesSizeZeroThenAddExecutionTrace() {
        if (this.getScenario().getFixtures().size() == 0) {
            this.getScenario().getFixtures().add(new ExecutionTrace());
        }
    }

    private void createWidgetForEditorLayout(DirtyableFlexTable editorLayout, int layoutRow, int layoutColumn, Widget widget) {
        editorLayout.setWidget(layoutRow, layoutColumn, widget);
    }

    void renderEditor() {
        if (this.layout.getWidgetCount() == 2) {
            this.layout.remove(1);
        }
        DirtyableFlexTable editorLayout = this.scenarioWidgetComponentCreator.createDirtyableFlexTable();
        this.layout.add((Widget)editorLayout);
        ScenarioHelper scenarioHelper = new ScenarioHelper();
        List fixtures = scenarioHelper.lumpyMap(this.getScenario().getFixtures());
        List listExecutionTrace = scenarioHelper.getExecutionTraceFor(fixtures);
        int layoutRow = 1;
        int executionTraceLine = 0;
        ExecutionTrace previousExecutionTrace = null;
        for (Fixture fixture : fixtures) {
            if (fixture instanceof ExecutionTrace) {
                ExecutionTrace currentExecutionTrace = (ExecutionTrace)fixture;
                this.createWidgetForEditorLayout(editorLayout, layoutRow, 0, (Widget)this.scenarioWidgetComponentCreator.createExpectPanel(currentExecutionTrace));
                if (++executionTraceLine >= listExecutionTrace.size()) {
                    executionTraceLine = listExecutionTrace.size() - 1;
                }
                this.createWidgetForEditorLayout(editorLayout, layoutRow, 1, (Widget)this.scenarioWidgetComponentCreator.createExecutionWidget(currentExecutionTrace));
                editorLayout.setHorizontalAlignmentForFlexCellFormatter(layoutRow, 2, HasHorizontalAlignment.ALIGN_LEFT);
                previousExecutionTrace = currentExecutionTrace;
            } else if (fixture instanceof FixturesMap) {
                this.createWidgetForEditorLayout(editorLayout, layoutRow, 0, (Widget)this.scenarioWidgetComponentCreator.createGivenLabelButton(listExecutionTrace, executionTraceLine, previousExecutionTrace));
                this.createWidgetForEditorLayout(editorLayout, ++layoutRow, 1, this.scenarioWidgetComponentCreator.createGivenPanel(listExecutionTrace, executionTraceLine, (FixturesMap)fixture));
            } else if (fixture instanceof CallFixtureMap) {
                this.createWidgetForEditorLayout(editorLayout, layoutRow, 0, (Widget)this.scenarioWidgetComponentCreator.createCallMethodLabelButton(listExecutionTrace, executionTraceLine, previousExecutionTrace));
                this.createWidgetForEditorLayout(editorLayout, ++layoutRow, 1, this.scenarioWidgetComponentCreator.createCallMethodOnGivenPanel(listExecutionTrace, executionTraceLine, (CallFixtureMap)fixture));
            } else {
                FixtureList fixturesList = (FixtureList)fixture;
                Fixture first = (Fixture)fixturesList.get(0);
                if (first instanceof VerifyFact) {
                    this.createWidgetForEditorLayout(editorLayout, layoutRow, 1, (Widget)this.scenarioWidgetComponentCreator.createVerifyFactsPanel(listExecutionTrace, executionTraceLine, fixturesList));
                } else if (first instanceof VerifyRuleFired) {
                    this.createWidgetForEditorLayout(editorLayout, layoutRow, 1, (Widget)this.scenarioWidgetComponentCreator.createVerifyRulesFiredWidget(fixturesList));
                }
            }
            ++layoutRow;
        }
        this.createWidgetForEditorLayout(editorLayout, layoutRow, 0, (Widget)this.scenarioWidgetComponentCreator.createAddExecuteButton());
        this.createWidgetForEditorLayout(editorLayout, ++layoutRow, 0, (Widget)this.scenarioWidgetComponentCreator.createSmallLabel());
        this.createWidgetForEditorLayout(editorLayout, layoutRow, 1, (Widget)this.scenarioWidgetComponentCreator.createConfigWidget());
        HorizontalPanel horizontalPanel = this.scenarioWidgetComponentCreator.createHorizontalPanel();
        this.createWidgetForEditorLayout(editorLayout, ++layoutRow, 0, (Widget)horizontalPanel);
        this.createWidgetForEditorLayout(editorLayout, layoutRow, 1, (Widget)this.scenarioWidgetComponentCreator.createGlobalPanel(scenarioHelper, previousExecutionTrace));
    }

    public Widget getRuleSelectionWidget(String packageName, RuleSelectionEvent selected) {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        TextBox ruleNameTextBox = this.scenarioWidgetComponentCreator.createRuleNameTextBox();
        horizontalPanel.add((Widget)ruleNameTextBox);
        if (this.availableRules != null) {
            ListBox availableRulesBox = this.scenarioWidgetComponentCreator.createAvailableRulesBox(this.availableRules);
            availableRulesBox.setSelectedIndex(0);
            if (this.availableRulesHandlerRegistration != null) {
                this.availableRulesHandlerRegistration.removeHandler();
            }
            ChangeHandler ruleSelectionCL = this.scenarioWidgetComponentCreator.createRuleChangeHandler(ruleNameTextBox, availableRulesBox);
            this.availableRulesHandlerRegistration = availableRulesBox.addChangeHandler(ruleSelectionCL);
            horizontalPanel.add((Widget)availableRulesBox);
        } else {
            Button showList = new Button(this.constants.showListButton());
            horizontalPanel.add((Widget)showList);
            showList.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        Button ok = this.scenarioWidgetComponentCreator.createOkButton(selected, ruleNameTextBox);
        horizontalPanel.add((Widget)ok);
        return horizontalPanel;
    }

    void setShowResults(boolean showResults) {
        this.scenarioWidgetComponentCreator.setShowResults(showResults);
    }

    boolean isShowResults() {
        return this.scenarioWidgetComponentCreator.isShowResults();
    }

    public MetaData getMetaData() {
        return this.scenarioWidgetComponentCreator.getMetaData();
    }

    public void setScenario(Scenario scenario) {
        this.scenarioWidgetComponentCreator.setScenario(scenario);
    }

    public Scenario getScenario() {
        return this.scenarioWidgetComponentCreator.getScenario();
    }

    static /* synthetic */ Images access$000() {
        return images;
    }

    static /* synthetic */ Constants access$100(ScenarioWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ String[] access$202(ScenarioWidget x0, String[] x1) {
        x0.availableRules = x1;
        return x1;
    }

    static /* synthetic */ ScenarioWidgetComponentCreator access$300(ScenarioWidget x0) {
        return x0.scenarioWidgetComponentCreator;
    }

    static /* synthetic */ HandlerRegistration access$402(ScenarioWidget x0, HandlerRegistration x1) {
        x0.availableRulesHandlerRegistration = x1;
        return x0.availableRulesHandlerRegistration;
    }
}

