/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.factmodel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.factmodel.FactEditorPopup;
import org.drools.guvnor.client.factmodel.FactFieldsEditor;
import org.drools.guvnor.client.factmodel.FactMetaModel;
import org.drools.guvnor.client.factmodel.FactModelEditor;
import org.drools.guvnor.client.factmodel.ModelNameHelper;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.util.AbstractLazyStackPanelHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactModelEditor
extends AbstractLazyStackPanelHeader {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private static FactModelEditorBinder uiBinder = (FactModelEditorBinder)GWT.create(FactModelEditorBinder.class);
    @UiField
    Image icon;
    @UiField
    Label titleLabel;
    @UiField
    Image editIcon;
    @UiField
    Image moveUpIcon;
    @UiField
    Image moveDownIcon;
    @UiField
    Image deleteIcon;
    private ClickHandler expandClickHandler = new /* Unavailable Anonymous Inner Class!! */;
    private final FactMetaModel factMetaModel;
    private final List<FactMetaModel> factModels;
    private Command deleteEvent;
    private Command moveUpCommand;
    private Command moveDownCommand;
    private ModelNameHelper modelNameHelper;

    public void setDeleteEvent(Command deleteEvent) {
        this.deleteEvent = deleteEvent;
    }

    public FactModelEditor(FactMetaModel factMetaModel, List<FactMetaModel> factModels) {
        this.factModels = factModels;
        this.factMetaModel = factMetaModel;
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.titleLabel.setText(this.getTitleText());
        this.icon.addClickHandler(this.expandClickHandler);
        this.titleLabel.addClickHandler(this.expandClickHandler);
        this.setIconImage();
        this.moveUpIcon.setTitle(constants.MoveUp());
        this.moveDownIcon.setTitle(constants.MoveDown());
        this.deleteIcon.setTitle(constants.RemoveThisFactType());
        this.addOpenHandler((OpenHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getTitleText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.factMetaModel.getName());
        if (this.factMetaModel.hasSuperType()) {
            sb.append(" extends ");
            sb.append(this.factMetaModel.getSuperType());
        }
        return sb.toString();
    }

    @UiHandler(value={"editIcon"})
    void editIconClick(ClickEvent event) {
        FactEditorPopup popup = new FactEditorPopup(this.factMetaModel, this.factModels, this.modelNameHelper);
        popup.setOkCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    @UiHandler(value={"moveUpIcon"})
    void moveUpClick(ClickEvent event) {
        this.moveUpCommand.execute();
    }

    @UiHandler(value={"moveDownIcon"})
    void moveDownClick(ClickEvent event) {
        this.moveDownCommand.execute();
    }

    @UiHandler(value={"deleteIcon"})
    void deleteClick(ClickEvent event) {
        if (Window.confirm((String)constants.AreYouSureYouWantToRemoveThisFact())) {
            this.deleteEvent.execute();
        }
    }

    public void setModelNameHelper(ModelNameHelper modelNameHelper) {
        this.modelNameHelper = modelNameHelper;
    }

    private void setIconImage() {
        if (this.expanded) {
            this.icon.setResource(images.collapse());
        } else {
            this.icon.setResource(images.expand());
        }
    }

    public void setMoveDownCommand(Command moveDownCommand) {
        this.moveDownCommand = moveDownCommand;
    }

    public void setMoveUpCommand(Command moveUpCommand) {
        this.moveUpCommand = moveUpCommand;
    }

    public void setUpVisible(boolean visible) {
        this.moveUpIcon.setVisible(visible);
    }

    public void setDownVisible(boolean visible) {
        this.moveDownIcon.setVisible(visible);
    }

    public void expand() {
        if (!this.expanded) {
            this.onTitleClicked();
        }
    }

    public void collapse() {
        if (this.expanded) {
            this.onTitleClicked();
        }
    }

    private void onTitleClicked() {
        if (this.expanded) {
            CloseEvent.fire((HasCloseHandlers)this, (Object)this);
        } else {
            OpenEvent.fire((HasOpenHandlers)this, (Object)this);
        }
    }

    public FactMetaModel getFactModel() {
        return this.factMetaModel;
    }

    public Widget getContent() {
        return new FactFieldsEditor(this.factMetaModel.getFields(), this.factMetaModel.getAnnotations(), this.modelNameHelper);
    }

    static /* synthetic */ void access$000(FactModelEditor x0) {
        x0.onTitleClicked();
    }

    static /* synthetic */ boolean access$102(FactModelEditor x0, boolean x1) {
        x0.expanded = x1;
        return x0.expanded;
    }

    static /* synthetic */ void access$200(FactModelEditor x0) {
        x0.setIconImage();
    }

    static /* synthetic */ boolean access$302(FactModelEditor x0, boolean x1) {
        x0.expanded = x1;
        return x0.expanded;
    }

    static /* synthetic */ String access$400(FactModelEditor x0) {
        return x0.getTitleText();
    }
}

