/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.ActionSetFieldWidget;
import org.drools.guvnor.client.modeldriven.ui.ActionValueEditor;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.resources.Images;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;

public class ActionSetFieldWidget
extends RuleModellerWidget {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private final ActionSetField model;
    private final DirtyableFlexTable layout;
    private boolean isBoundFact = false;
    private String[] fieldCompletions;
    private String variableClass;
    private boolean readOnly;

    public ActionSetFieldWidget(RuleModeller mod, ActionSetField set) {
        this(mod, set, null);
    }

    public ActionSetFieldWidget(RuleModeller mod, ActionSetField set, Boolean readOnly) {
        super(mod);
        this.model = set;
        this.layout = new DirtyableFlexTable();
        this.layout.setStyleName("model-builderInner-Background");
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        if (completions.isGlobalVariable(set.variable)) {
            this.fieldCompletions = completions.getFieldCompletionsForGlobalVariable(set.variable);
            this.variableClass = completions.getGlobalVariable(set.variable);
        } else {
            String type = mod.getModel().getLHSBindingType(set.variable);
            if (type != null) {
                this.fieldCompletions = completions.getFieldCompletions(FieldAccessorsAndMutators.MUTATOR, type);
                this.variableClass = type;
                this.isBoundFact = true;
            } else {
                ActionInsertFact patternRhs = mod.getModel().getRHSBoundFact(set.variable);
                if (patternRhs != null) {
                    this.fieldCompletions = completions.getFieldCompletions(FieldAccessorsAndMutators.MUTATOR, patternRhs.factType);
                    this.variableClass = patternRhs.factType;
                    this.isBoundFact = true;
                }
            }
        }
        if (this.variableClass == null) {
            throw new IllegalStateException("couldn't find type for variable: " + set.variable);
        }
        this.readOnly = readOnly == null ? !completions.containsFactType(this.variableClass) : readOnly;
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    private void doLayout() {
        this.layout.clear();
        for (int i = 0; i < this.model.fieldValues.length; ++i) {
            ActionFieldValue val = this.model.fieldValues[i];
            this.layout.setWidget(i, 0, this.getSetterLabel());
            this.layout.setWidget(i, 1, this.fieldSelector(val));
            this.layout.setWidget(i, 2, this.valueEditor(val));
            int idx = i;
            ImageButton remove = new ImageButton(images.deleteItemSmall());
            remove.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            if (this.readOnly) continue;
            this.layout.setWidget(i, 3, (Widget)remove);
        }
        if (this.model.fieldValues.length == 0) {
            HorizontalPanel h = new HorizontalPanel();
            h.add(this.getSetterLabel());
            if (!this.readOnly) {
                h.add((Widget)new ImageButton(images.edit(), this.constants.AddFirstNewField(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
            }
            this.layout.setWidget(0, 0, (Widget)h);
        }
    }

    private Widget getSetterLabel() {
        String type;
        3 clk = new /* Unavailable Anonymous Inner Class!! */;
        String modifyType = "set";
        if (this.model instanceof ActionUpdateField) {
            modifyType = "modify";
        }
        String descFact = (type = this.getModeller().getModel().getLHSBindingType(this.model.variable)) != null ? type + " <b>[" + this.model.variable + "]</b>" : this.model.variable;
        String sl = this.constants.setterLabel(HumanReadable.getActionDisplayName((String)modifyType), descFact);
        return new ClickableLabel(sl, (ClickHandler)clk, !this.readOnly);
    }

    protected void showAddFieldPopup(ClickEvent w) {
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        FormStylePopup popup = new FormStylePopup(images.newexWiz(), this.constants.AddAField());
        ListBox box = new ListBox();
        box.addItem("...");
        for (int i = 0; i < this.fieldCompletions.length; ++i) {
            box.addItem(this.fieldCompletions[i]);
        }
        box.setSelectedIndex(0);
        popup.addAttribute(this.constants.AddField(), (Widget)box);
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    private Widget valueEditor(ActionFieldValue val) {
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        String type = "";
        if (completions.isGlobalVariable(this.model.variable)) {
            type = completions.getGlobalVariable(this.model.variable);
        } else {
            type = this.getModeller().getModel().getLHSBindingType(this.model.variable);
            if (type == null) {
                type = this.getModeller().getModel().getRHSBoundFact((String)this.model.variable).factType;
            }
        }
        DropDownData enums = completions.getEnums(type, (FieldNature[])this.model.fieldValues, val.field);
        ActionValueEditor actionValueEditor = new ActionValueEditor(val, enums, this.getModeller(), val.type, this.readOnly);
        actionValueEditor.setOnChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        return actionValueEditor;
    }

    private Widget fieldSelector(ActionFieldValue val) {
        return new SmallLabel(val.field);
    }

    public boolean isBoundFact() {
        return this.isBoundFact;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    static /* synthetic */ Constants access$000(ActionSetFieldWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ ActionSetField access$100(ActionSetFieldWidget x0) {
        return x0.model;
    }

    static /* synthetic */ String access$200(ActionSetFieldWidget x0) {
        return x0.variableClass;
    }
}

