/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.EnumDropDown;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;

public class EnumDropDownLabel
extends Composite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    protected Panel panel = new HorizontalPanel();
    private final Label textWidget;
    private final EnumDropDown enumDropDown;
    private final Button okButton = new Button(this.constants.OK());
    private Command onValueChangeCommand;

    public EnumDropDownLabel(FactPattern pattern, String fieldName, SuggestionCompletionEngine sce, BaseSingleFieldConstraint constraint, boolean enabled) {
        this.textWidget = this.getTextLabel(enabled);
        this.enumDropDown = this.getEnumDropDown(constraint, sce, pattern, fieldName);
        this.enumDropDown.setEnabled(enabled);
        this.panel.add((Widget)this.textWidget);
        this.initWidget((Widget)this.panel);
    }

    private Label getTextLabel(boolean enabled) {
        Label label = new Label();
        label.setStyleName("form-field");
        if (enabled) {
            label.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (label.getText() == null && "".equals(label.getText())) {
            label.setText(this.constants.Value());
        }
        return label;
    }

    private void showPopup() {
        PopupPanel popup = new PopupPanel();
        popup.setGlassEnabled(true);
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        popup.setPopupPosition(this.getAbsoluteLeft(), this.getAbsoluteTop());
        this.okButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        horizontalPanel.add((Widget)this.enumDropDown);
        horizontalPanel.add((Widget)this.okButton);
        popup.add((Widget)horizontalPanel);
        popup.show();
    }

    private EnumDropDown getEnumDropDown(BaseSingleFieldConstraint constraint, SuggestionCompletionEngine sce, FactPattern pattern, String fieldName) {
        String valueType;
        if (constraint instanceof SingleFieldConstraintEBLeftSide) {
            SingleFieldConstraintEBLeftSide sfexp = (SingleFieldConstraintEBLeftSide)constraint;
            valueType = sfexp.getExpressionLeftSide().getGenericType();
        } else if (constraint instanceof ConnectiveConstraint) {
            ConnectiveConstraint cc = (ConnectiveConstraint)constraint;
            valueType = cc.getFieldType();
        } else {
            valueType = sce.getFieldType(pattern.getFactType(), fieldName);
        }
        DropDownData dropDownData = "Boolean".equals(valueType) ? DropDownData.create((String[])new String[]{"true", "false"}) : sce.getEnums(pattern, fieldName);
        EnumDropDown box = new EnumDropDown(constraint.getValue(), (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, dropDownData);
        if (box.getItemCount() > 6) {
            box.setVisibleItemCount(6);
        } else {
            box.setVisibleItemCount(box.getItemCount());
        }
        return box;
    }

    private void executeOnValueChangeCommand() {
        if (this.onValueChangeCommand != null) {
            this.onValueChangeCommand.execute();
        }
    }

    public void setOnValueChangeCommand(Command onValueChangeCommand) {
        this.onValueChangeCommand = onValueChangeCommand;
    }

    static /* synthetic */ void access$000(EnumDropDownLabel x0) {
        x0.showPopup();
    }

    static /* synthetic */ void access$100(EnumDropDownLabel x0) {
        x0.executeOnValueChangeCommand();
    }

    static /* synthetic */ Label access$200(EnumDropDownLabel x0) {
        return x0.textWidget;
    }

    static /* synthetic */ Button access$300(EnumDropDownLabel x0) {
        return x0.okButton;
    }
}

