/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.packages.ArtifactEditor;
import org.drools.guvnor.client.rpc.Artifact;
import org.drools.guvnor.client.ruleeditor.GuvnorEditor;
import org.drools.guvnor.client.ruleeditor.MessageWidget;
import org.drools.guvnor.client.ruleeditor.MetaDataWidget;
import org.drools.guvnor.client.ruleeditor.RuleDocumentWidget;

public class ArtifactEditor
extends GuvnorEditor {
    private static ArtifactEditorBinder uiBinder = (ArtifactEditorBinder)GWT.create(ArtifactEditorBinder.class);
    @UiField(provided=true)
    final MetaDataWidget metaWidget;
    @UiField(provided=true)
    final RuleDocumentWidget ruleDocumentWidget;
    @UiField
    MessageWidget messageWidget;
    protected Artifact artifact;
    private boolean readOnly;
    private long lastSaved = System.currentTimeMillis();

    public ArtifactEditor(ClientFactory clientFactory, Artifact artifact) {
        this(clientFactory, artifact, false);
    }

    public ArtifactEditor(ClientFactory clientFactory, Artifact artifact, boolean historicalReadOnly) {
        this.artifact = artifact;
        this.readOnly = historicalReadOnly || artifact.isReadonly();
        this.ruleDocumentWidget = new RuleDocumentWidget(this.artifact, this.readOnly);
        this.metaWidget = new MetaDataWidget(clientFactory, this.artifact, this.readOnly, this.artifact.getUuid());
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setWidth("100%");
        LoadingPopup.close();
    }

    public boolean isDirty() {
        return System.currentTimeMillis() - this.lastSaved > 3600000L;
    }

    protected boolean hasDirty() {
        return false;
    }

    public void showInfoMessage(String message) {
        this.messageWidget.showMessage(message);
    }
}

