/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.ExplorerNodeConfig;
import org.drools.guvnor.client.explorer.navigation.deployment.SnapshotAssetListPlace;
import org.drools.guvnor.client.explorer.navigation.deployment.SnapshotPlace;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.ClosePlaceEvent;
import org.drools.guvnor.client.packages.PackageBuilderWidget;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.PackageServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.widgets.tables.SnapshotComparisonPagedTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotView
extends Composite {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    public static final String LATEST_SNAPSHOT = "LATEST";
    private PackageConfigData parentConf;
    private SnapshotInfo snapInfo;
    private ListBox box = new ListBox();
    private VerticalPanel vert;
    private SnapshotComparisonPagedTable table;
    private final ClientFactory clientFactory;

    public SnapshotView(ClientFactory clientFactory, SnapshotInfo snapInfo, PackageConfigData parentPackage) {
        this.clientFactory = clientFactory;
        this.vert = new VerticalPanel();
        this.snapInfo = snapInfo;
        this.parentConf = parentPackage;
        PrettyFormLayout head = new PrettyFormLayout();
        head.addHeader(images.snapshot(), this.header());
        this.vert.add((Widget)head);
        this.vert.add(this.infoPanel());
        this.vert.setWidth("100%");
        this.initWidget((Widget)this.vert);
    }

    private Widget header() {
        FlexTable ft = new FlexTable();
        ft.setWidget(0, 0, (Widget)new Label(constants.ViewingSnapshot()));
        ft.setWidget(0, 1, (Widget)new HTML("<b>" + this.snapInfo.getName() + "</b>"));
        ft.getFlexCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(1, 0, (Widget)new Label(constants.ForPackage()));
        ft.setWidget(1, 1, (Widget)new Label(this.parentConf.getName()));
        ft.getFlexCellFormatter().setHorizontalAlignment(1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        HTML dLink = new HTML("<a href='" + PackageBuilderWidget.getDownloadLink((PackageConfigData)this.parentConf) + "' target='_blank'>" + constants.clickHereToDownloadBinaryOrCopyURLForDeploymentAgent() + "</a>");
        ft.setWidget(2, 0, (Widget)new Label(constants.DeploymentURL()));
        ft.setWidget(2, 1, (Widget)dLink);
        ft.getFlexCellFormatter().setHorizontalAlignment(2, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(3, 0, (Widget)new Label(constants.SnapshotCreatedOn()));
        ft.setWidget(3, 1, (Widget)new Label(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(this.parentConf.getLastModified())));
        ft.getFlexCellFormatter().setHorizontalAlignment(4, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(4, 0, (Widget)new Label(constants.CommentColon()));
        ft.setWidget(4, 1, (Widget)new Label(this.parentConf.getCheckinComment()));
        ft.getFlexCellFormatter().setHorizontalAlignment(4, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        HorizontalPanel actions = new HorizontalPanel();
        actions.add((Widget)this.getDeleteButton(this.snapInfo.getName(), this.parentConf.getName()));
        actions.add((Widget)this.getCopyButton(this.snapInfo.getName(), this.parentConf.getName()));
        ft.setWidget(5, 0, (Widget)actions);
        ft.setWidget(6, 0, this.getCompareWidget(this.parentConf.getName(), this.snapInfo.getName()));
        ft.getFlexCellFormatter().setHorizontalAlignment(4, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.getFlexCellFormatter().setColSpan(5, 0, 2);
        return ft;
    }

    private Widget getCompareWidget(String packageName, String snapshotName) {
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)new Label("Compare to:"));
        RepositoryServiceFactory.getPackageService().listSnapshots(this.parentConf.getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        hPanel.add((Widget)this.box);
        Button button = new Button("Compare");
        button.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        hPanel.add((Widget)button);
        return hPanel;
    }

    private Button getDeleteButton(String snapshotName, String moduleName) {
        Button btn = new Button(constants.Delete());
        btn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return btn;
    }

    private ClosePlaceEvent getCloseEvent(String moduleName) {
        return new ClosePlaceEvent((Place)new SnapshotPlace(moduleName, this.snapInfo.getName()));
    }

    private Button getCopyButton(String snapshotName, String packageName) {
        PackageServiceAsync serv = RepositoryServiceFactory.getPackageService();
        Button btn = new Button(constants.Copy());
        btn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return btn;
    }

    private GenericCallback<SnapshotInfo[]> createGenericCallback(String snapshotName, String packageName, PackageServiceAsync serv) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Widget infoPanel() {
        return this.packageTree();
    }

    protected Widget packageTree() {
        HashMap<TreeItem, String> itemWidgets = new HashMap<TreeItem, String>();
        Tree root = new Tree();
        root.setAnimationEnabled(true);
        TreeItem pkg = ExplorerNodeConfig.getPackageItemStructure((String)this.parentConf.getName());
        itemWidgets.put(pkg, this.snapInfo.getUuid());
        pkg.setUserObject((Object)this.snapInfo);
        root.addItem(pkg);
        ScrollPanel packagesTreeItemPanel = new ScrollPanel((Widget)root);
        root.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        return packagesTreeItemPanel;
    }

    protected void showAssetList(String[] assetTypes) {
        this.clientFactory.getPlaceController().goTo((Place)new SnapshotAssetListPlace(this.snapInfo.getName(), this.snapInfo.getUuid(), assetTypes));
    }

    public static void showNewSnapshot(Command refreshCmd) {
        FormStylePopup pop = new FormStylePopup(images.snapshot(), constants.NewSnapshot());
        RulePackageSelector sel = new RulePackageSelector();
        pop.addAttribute(constants.ForPackage(), (Widget)sel);
        Button ok = new Button(constants.OK());
        pop.addAttribute("", (Widget)ok);
        pop.show();
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void rebuildBinaries() {
        if (Window.confirm((String)constants.SnapshotRebuildWarning())) {
            LoadingPopup.showMessage((String)constants.RebuildingSnapshotsPleaseWaitThisMayTakeSomeTime());
            RepositoryServiceFactory.getPackageService().rebuildSnapshots((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ ListBox access$000(SnapshotView x0) {
        return x0.box;
    }

    static /* synthetic */ SnapshotComparisonPagedTable access$100(SnapshotView x0) {
        return x0.table;
    }

    static /* synthetic */ VerticalPanel access$200(SnapshotView x0) {
        return x0.vert;
    }

    static /* synthetic */ SnapshotComparisonPagedTable access$102(SnapshotView x0, SnapshotComparisonPagedTable x1) {
        x0.table = x1;
        return x0.table;
    }

    static /* synthetic */ ClientFactory access$300(SnapshotView x0) {
        return x0.clientFactory;
    }

    static /* synthetic */ Constants access$400() {
        return constants;
    }

    static /* synthetic */ ClosePlaceEvent access$500(SnapshotView x0, String x1) {
        return x0.getCloseEvent(x1);
    }

    static /* synthetic */ GenericCallback access$600(SnapshotView x0, String x1, String x2, PackageServiceAsync x3) {
        return x0.createGenericCallback(x1, x2, x3);
    }

    static /* synthetic */ Images access$700() {
        return images;
    }
}

