/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.configurations.ApplicationPreferences;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.client.ruleeditor.EditorWidget;
import org.drools.guvnor.client.ruleeditor.RuleFlowUploadWidget;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.ruleeditor.SaveEventListener;
import org.drools.guvnor.client.rulefloweditor.RuleFlowViewer;
import org.drools.guvnor.client.util.DecoratedDisclosurePanel;

public class RuleFlowWrapper
extends Composite
implements SaveEventListener,
EditorWidget {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private RuleViewer viewer;
    private RuleAsset asset;
    private RuleFlowViewer ruleFlowViewer;
    private DecoratedDisclosurePanel parameterPanel;
    private final ClientFactory clientFactory;

    public RuleFlowWrapper(RuleAsset asset, RuleViewer viewer, ClientFactory clientFactory) {
        this.viewer = viewer;
        this.asset = asset;
        this.clientFactory = clientFactory;
        this.initWidgets();
    }

    protected void initWidgets() {
        RuleFlowUploadWidget uploadWidget = new RuleFlowUploadWidget(this.asset, this.viewer, this.clientFactory);
        VerticalPanel panel = new VerticalPanel();
        panel.add((Widget)uploadWidget);
        if (ApplicationPreferences.showVisualRuleFlow()) {
            this.initRuleflowViewer();
            if (this.ruleFlowViewer != null && this.parameterPanel != null) {
                Button viewSource = new Button();
                viewSource.setText(this.constants.OpenEditorInNewWindow());
                viewSource.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                panel.add((Widget)viewSource);
            }
        }
        this.initWidget((Widget)panel);
        this.setStyleName(this.getOverallStyleName());
    }

    private void doViewDiagram() {
        LoadingPopup.showMessage((String)this.constants.CalculatingSource());
        try {
            FormStylePopup pop = new FormStylePopup(images.viewSource(), this.constants.ViewingDiagram(), new Integer(800));
            pop.addRow((Widget)new ScrollPanel((Widget)this.ruleFlowViewer));
            pop.addRow((Widget)this.parameterPanel);
            pop.show();
        }
        catch (Exception e) {
            ErrorPopup.showMessage((String)this.constants.CouldNotCreateTheRuleflowDiagramItIsPossibleThatTheRuleflowFileIsInvalid());
        }
        LoadingPopup.close();
    }

    private void initRuleflowViewer() {
        RuleFlowContentModel rfcm = (RuleFlowContentModel)this.asset.getContent();
        if (rfcm != null && rfcm.getXml() != null && rfcm.getNodes() != null) {
            try {
                this.parameterPanel = new DecoratedDisclosurePanel(this.constants.Parameters());
                this.parameterPanel.ensureDebugId("cwDisclosurePanel");
                this.parameterPanel.setWidth("100%");
                this.parameterPanel.setOpen(false);
                FormStyleLayout parametersForm = new FormStyleLayout();
                parametersForm.setHeight("120px");
                this.parameterPanel.setContent((Widget)parametersForm);
                this.ruleFlowViewer = new RuleFlowViewer(rfcm, parametersForm);
            }
            catch (Exception e) {
                Window.alert((String)e.toString());
            }
        } else if (rfcm != null && rfcm.getXml() == null) {
            Window.alert((String)this.constants.CouldNotCreateTheRuleflowDiagramItIsPossibleThatTheRuleflowFileIsInvalid());
        }
    }

    public ImageResource getIcon() {
        return images.ruleflowLarge();
    }

    public String getOverallStyleName() {
        return "decision-Table-upload";
    }

    public void onAfterSave() {
    }

    public void onSave() {
        RuleFlowContentModel rfcm = (RuleFlowContentModel)this.asset.getContent();
        rfcm.setNodes(this.ruleFlowViewer.getTransferNodes());
    }

    public RuleFlowViewer getRuleFlowViewer() {
        return this.ruleFlowViewer;
    }

    static /* synthetic */ void access$000(RuleFlowWrapper x0) {
        x0.doViewDiagram();
    }

    static /* synthetic */ RuleFlowViewer access$100(RuleFlowWrapper x0) {
        return x0.ruleFlowViewer;
    }
}

