/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.util;

import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.util.AbstractLazyStackPanelHeader;
import org.drools.guvnor.client.util.LazyStackPanelRow;
import org.drools.guvnor.client.util.LoadContentCommand;

public class LazyStackPanelRow
extends VerticalPanel {
    private final AbstractLazyStackPanelHeader header;
    private LoadContentCommand contentLoad;
    private Widget contentWidget = null;
    private SimplePanel contentPanel = new SimplePanel();
    private ContentAnimation contentAnimation;
    private static final int ANIMATION_DURATION = 350;
    private boolean expanded;

    public LazyStackPanelRow(AbstractLazyStackPanelHeader titleWidget, LoadContentCommand contentLoad, boolean expanded) {
        this.setWidth("100%");
        this.expanded = expanded;
        this.header = titleWidget;
        this.contentLoad = contentLoad;
        this.init();
    }

    public LazyStackPanelRow(AbstractLazyStackPanelHeader titleWidget, LoadContentCommand contentLoad) {
        this(titleWidget, contentLoad, false);
    }

    private void init() {
        this.clear();
        this.add((Widget)this.header);
        if (this.contentWidget != null) {
            this.contentWidget.setVisible(this.expanded);
        }
    }

    public AbstractLazyStackPanelHeader getHeader() {
        return this.header;
    }

    public SimplePanel getContentPanel() {
        return this.contentPanel;
    }

    public void expand() {
        this.expanded = true;
        if (this.contentWidget == null) {
            this.contentWidget = this.contentLoad.load();
            this.contentPanel.add(this.contentWidget);
        }
        this.contentPanel.setVisible(true);
        this.doAnimation(true);
    }

    public void compress() {
        this.expanded = false;
        this.contentPanel.setVisible(true);
        this.doAnimation(false);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    private void doAnimation(boolean isExpanding) {
        if (this.contentPanel.getWidget() != null) {
            this.contentAnimation = new ContentAnimation(this.contentPanel);
            this.contentAnimation.setExpanding(isExpanding);
            this.contentAnimation.run(350);
        }
    }
}

