/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.assetviewer;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.client.explorer.AcceptTabItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.ModuleEditorPlace;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.util.Activity;
import org.drools.guvnor.client.widgets.assetviewer.AssetViewerActivity;
import org.drools.guvnor.client.widgets.assetviewer.AssetViewerActivityView;
import org.drools.guvnor.client.widgets.tables.AssetPagedTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class AssetViewerActivity
extends Activity
implements AssetViewerActivityView.Presenter {
    private final ClientFactory clientFactory;
    private PackageConfigData packageConfigData;
    private AssetViewerActivityView view;
    private String uuid;

    public AssetViewerActivity(String uuid, ClientFactory clientFactory) {
        this.uuid = uuid;
        this.clientFactory = clientFactory;
        this.view = clientFactory.getAssetViewerActivityView();
        this.view.setPresenter((AssetViewerActivityView.Presenter)this);
    }

    public void start(AcceptTabItem acceptTabItem, EventBus eventBus) {
        this.view.showLoadingPackageInformationMessage();
        this.clientFactory.getPackageService().loadPackageConfig(this.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void viewPackageDetail(PackageConfigData packageConfigData) {
        this.clientFactory.getPlaceController().goTo((Place)new ModuleEditorPlace(packageConfigData.getUuid()));
    }

    private void fillModuleItemStructure() {
        String[] registeredFormats = this.clientFactory.getAssetEditorFactory().getRegisteredAssetEditorFormats();
        ArrayList<FormatList> formatListGroupedByTitles = new ArrayList<FormatList>();
        for (String format : registeredFormats) {
            boolean found = false;
            for (FormatList formatListWithSameTitle : formatListGroupedByTitles) {
                found = FormatList.access$300((FormatList)formatListWithSameTitle, (String)format);
                if (!found) continue;
                formatListWithSameTitle.add(format);
                break;
            }
            if (found) continue;
            FormatList formatListWithSameTile = new FormatList(this);
            formatListWithSameTile.add(format);
            formatListGroupedByTitles.add(formatListWithSameTile);
        }
        this.addTitleItems(formatListGroupedByTitles);
    }

    private String getTitle(String format) {
        return this.clientFactory.getAssetEditorFactory().getAssetEditorTitle(format);
    }

    private void addTitleItems(List<FormatList> formatListGroupedByTitles) {
        for (FormatList formatList : formatListGroupedByTitles) {
            if (formatList.size() <= 0) continue;
            this.view.addAssetFormat(this.clientFactory.getAssetEditorFactory().getAssetEditorIcon(formatList.getFirst()), this.getTitle(formatList.getFirst()), this.packageConfigData.getName(), this.makeTable(formatList));
        }
    }

    private AssetPagedTable makeTable(FormatList formatList) {
        List<String> formatsInList = null;
        Boolean formatIsRegistered = null;
        if (formatList.getFormats() != null && formatList.getFormats().length > 0) {
            formatsInList = Arrays.asList(formatList.getFormats());
        } else {
            formatIsRegistered = false;
        }
        return new AssetPagedTable(this.packageConfigData.getUuid(), formatsInList, formatIsRegistered, this.view.getFeedUrl(this.packageConfigData.getName()), this.clientFactory);
    }

    static /* synthetic */ PackageConfigData access$002(AssetViewerActivity x0, PackageConfigData x1) {
        x0.packageConfigData = x1;
        return x0.packageConfigData;
    }

    static /* synthetic */ PackageConfigData access$000(AssetViewerActivity x0) {
        return x0.packageConfigData;
    }

    static /* synthetic */ AssetViewerActivityView access$100(AssetViewerActivity x0) {
        return x0.view;
    }

    static /* synthetic */ void access$200(AssetViewerActivity x0) {
        x0.fillModuleItemStructure();
    }

    static /* synthetic */ String access$400(AssetViewerActivity x0, String x1) {
        return x0.getTitle(x1);
    }
}

