/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.decoratedgrid.data;

import com.google.gwt.user.client.Command;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.decoratedgrid.SortConfiguration;
import org.drools.guvnor.client.widgets.decoratedgrid.data.Coordinate;
import org.drools.guvnor.client.widgets.decoratedgrid.data.DynamicDataRow;
import org.drools.guvnor.client.widgets.decoratedgrid.data.GroupedDynamicDataRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicData
implements Iterable<DynamicDataRow> {
    private boolean isMerged = false;
    private List<Boolean> visibleColumns = new ArrayList();
    private static final long serialVersionUID = 5061393855340039472L;
    private Command onRowChangeCommand;
    private List<DynamicDataRow> data = new ArrayList();

    public void addColumn(int index, List<CellValue<? extends Comparable<?>>> columnData, boolean isVisible) {
        for (int iRow = 0; iRow < columnData.size(); ++iRow) {
            CellValue<? extends Comparable<?>> cv = columnData.get(iRow);
            ((DynamicDataRow)this.data.get(iRow)).add(index, cv);
        }
        this.visibleColumns.add(index, isVisible);
        this.assertModelMerging();
    }

    public DynamicDataRow addRow() {
        DynamicDataRow row = new DynamicDataRow();
        this.data.add(row);
        if (this.onRowChangeCommand != null) {
            this.onRowChangeCommand.execute();
        }
        this.assertModelMerging();
        return row;
    }

    public DynamicDataRow addRow(int index, List<CellValue<? extends Comparable<?>>> rowData) {
        DynamicDataRow row = new DynamicDataRow();
        for (CellValue<Comparable<?>> cellValue : rowData) {
            row.add(cellValue);
        }
        this.data.add(index, row);
        if (this.onRowChangeCommand != null) {
            this.onRowChangeCommand.execute();
        }
        this.assertModelMerging();
        return row;
    }

    public DynamicDataRow addRow(List<CellValue<? extends Comparable<?>>> rowData) {
        return this.addRow(this.data.size(), rowData);
    }

    public void applyModelGrouping(CellValue<?> startCell) {
        int startRowIndex = startCell.getCoordinate().getRow();
        int endRowIndex = this.findMergedCellExtent(startCell.getCoordinate()).getRow();
        int colIndex = startCell.getCoordinate().getCol();
        DynamicDataRow row = (DynamicDataRow)this.data.get(startRowIndex);
        GroupedDynamicDataRow groupedRow = new GroupedDynamicDataRow();
        for (int iCol = 0; iCol < row.size(); ++iCol) {
            CellValue.GroupedCellValue groupedCell = row.get(iCol).convertToGroupedCell();
            if (iCol == colIndex) {
                groupedCell.addState(CellValue.CellState.GROUPED);
            } else {
                groupedCell.removeState(CellValue.CellState.GROUPED);
            }
            groupedRow.add((CellValue)groupedCell);
        }
        for (int iRow = startRowIndex; iRow <= endRowIndex; ++iRow) {
            DynamicDataRow childRow = (DynamicDataRow)this.data.get(startRowIndex);
            groupedRow.addChildRow(childRow);
            this.data.remove(childRow);
        }
        this.data.remove(row);
        this.data.add(startRowIndex, groupedRow);
        if (this.onRowChangeCommand != null) {
            this.onRowChangeCommand.execute();
        }
        this.assertModelMerging();
    }

    public void clear() {
        this.data.clear();
    }

    public void deleteColumn(int index) {
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            DynamicDataRow row = (DynamicDataRow)this.data.get(iRow);
            row.remove(index);
        }
        this.visibleColumns.remove(index);
        this.assertModelMerging();
    }

    public DynamicDataRow deleteRow(int index) {
        DynamicDataRow row = (DynamicDataRow)this.data.remove(index);
        if (this.onRowChangeCommand != null) {
            this.onRowChangeCommand.execute();
        }
        this.assertModelMerging();
        return row;
    }

    public CellValue<? extends Comparable<?>> get(Coordinate c) {
        return ((DynamicDataRow)this.data.get(c.getRow())).get(c.getCol());
    }

    public DynamicDataRow get(int index) {
        return (DynamicDataRow)this.data.get(index);
    }

    public DynamicData getFlattenedData() {
        DynamicData dataClone = new DynamicData();
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            DynamicDataRow row = (DynamicDataRow)this.data.get(iRow);
            if (row instanceof GroupedDynamicDataRow) {
                List expandedRow = this.expandGroupedRow(row, true);
                dataClone.data.addAll(expandedRow);
                continue;
            }
            dataClone.data.add(row);
        }
        return dataClone;
    }

    public int indexOf(DynamicDataRow row) {
        return this.data.indexOf(row);
    }

    public boolean isMerged() {
        return this.isMerged;
    }

    @Override
    public Iterator<DynamicDataRow> iterator() {
        return this.data.iterator();
    }

    public List<DynamicDataRow> removeModelGrouping(CellValue<?> startCell) {
        int startRowIndex = startCell.getCoordinate().getRow();
        startCell.removeState(CellValue.CellState.GROUPED);
        boolean bRecursive = true;
        DynamicDataRow row = (DynamicDataRow)this.data.get(startRowIndex);
        for (int iCol = 0; iCol < row.size(); ++iCol) {
            CellValue cv = row.get(iCol);
            if (!(cv instanceof CellValue.GroupedCellValue)) continue;
            bRecursive = !(bRecursive ^ ((CellValue.GroupedCellValue)cv).hasMultipleValues());
        }
        List expandedRow = this.expandGroupedRow(row, bRecursive);
        this.deleteRow(startRowIndex);
        this.data.addAll(startRowIndex, expandedRow);
        if (this.onRowChangeCommand != null) {
            this.onRowChangeCommand.execute();
        }
        this.assertModelMerging();
        row = (DynamicDataRow)this.data.get(startRowIndex);
        boolean hasCellToExpand = false;
        for (CellValue cell : row) {
            if (!(cell instanceof CellValue.GroupedCellValue) || !cell.isGrouped() || cell.getRowSpan() <= 0) continue;
            hasCellToExpand = true;
            break;
        }
        if (!hasCellToExpand) {
            for (CellValue cell : row) {
                if (!(cell instanceof CellValue.GroupedCellValue) || cell.getRowSpan() != 1) continue;
                cell.addState(CellValue.CellState.GROUPED);
            }
        }
        return expandedRow;
    }

    public void set(Coordinate c, Object value) {
        if (c == null) {
            throw new IllegalArgumentException("c cannot be null");
        }
        ((DynamicDataRow)this.data.get(c.getRow())).get(c.getCol()).setValue(value);
        this.assertModelMerging();
    }

    public void setColumnVisibility(int index, boolean isVisible) {
        this.visibleColumns.set(index, isVisible);
        this.assertModelIndexes();
    }

    public void setMerged(boolean isMerged) {
        this.isMerged = isMerged;
        if (isMerged) {
            this.assertModelMerging();
        } else {
            this.removeModelGrouping();
            this.removeModelMerging();
        }
    }

    public void setOnRowChangeCommand(Command cmd) {
        this.onRowChangeCommand = cmd;
    }

    public int size() {
        return this.data.size();
    }

    public void sort(List<SortConfiguration> sortConfig) {
        if (sortConfig.size() == 0) {
            Collections.sort(this.data, new /* Unavailable Anonymous Inner Class!! */);
        } else {
            Collections.sort(sortConfig, new /* Unavailable Anonymous Inner Class!! */);
            Collections.sort(this.data, new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.onRowChangeCommand != null) {
            this.onRowChangeCommand.execute();
        }
        this.assertModelMerging();
    }

    private void assertModelIndexes() {
        if (this.data.size() == 0) {
            return;
        }
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            DynamicDataRow row = (DynamicDataRow)this.data.get(iRow);
            int colCount = 0;
            for (int iCol = 0; iCol < row.size(); ++iCol) {
                int newRow = iRow;
                int newCol = colCount;
                CellValue indexCell = row.get(iCol);
                if (((Boolean)this.visibleColumns.get(iCol)).booleanValue()) {
                    if (indexCell.getRowSpan() != 0) {
                        newRow = iRow;
                        newCol = colCount++;
                        CellValue cell = ((DynamicDataRow)this.data.get(newRow)).get(newCol);
                        cell.setPhysicalCoordinate(new Coordinate(iRow, iCol));
                    } else {
                        DynamicDataRow priorRow = (DynamicDataRow)this.data.get(iRow - 1);
                        CellValue priorCell = priorRow.get(iCol);
                        Coordinate priorHtmlCoordinate = priorCell.getHtmlCoordinate();
                        newRow = priorHtmlCoordinate.getRow();
                        newCol = priorHtmlCoordinate.getCol();
                    }
                }
                indexCell.setCoordinate(new Coordinate(iRow, iCol));
                indexCell.setHtmlCoordinate(new Coordinate(newRow, newCol));
            }
        }
    }

    private void assertModelMerging() {
        if (this.data.size() == 0) {
            return;
        }
        this.removeModelMerging();
        int COLUMNS = ((DynamicDataRow)this.data.get(0)).size();
        if (this.isMerged) {
            int iCol;
            int minRowIndex = 0;
            int maxRowIndex = this.data.size();
            DynamicDataRow blankRow = new DynamicDataRow();
            for (iCol = 0; iCol < COLUMNS; ++iCol) {
                CellValue cv = new CellValue(null, maxRowIndex, iCol);
                blankRow.add(cv);
            }
            this.data.add(blankRow);
            ++maxRowIndex;
            for (iCol = 0; iCol < COLUMNS; ++iCol) {
                CellValue cell1 = ((DynamicDataRow)this.data.get(minRowIndex)).get(iCol);
                CellValue cell2 = null;
                for (int iRow = minRowIndex + 1; iRow < maxRowIndex; ++iRow) {
                    CellValue.GroupedCellValue gcv;
                    cell1.setRowSpan(1);
                    cell2 = ((DynamicDataRow)this.data.get(iRow)).get(iCol);
                    boolean bSplit = true;
                    if (!cell1.isEmpty() && !cell2.isEmpty()) {
                        if (cell1.getValue().equals(cell2.getValue())) {
                            bSplit = false;
                            if (cell1 instanceof CellValue.GroupedCellValue && (gcv = (CellValue.GroupedCellValue)cell1).hasMultipleValues()) {
                                bSplit = true;
                            }
                            if (cell2 instanceof CellValue.GroupedCellValue && (gcv = (CellValue.GroupedCellValue)cell2).hasMultipleValues()) {
                                bSplit = true;
                            }
                        }
                    } else if (cell1.isOtherwise() && cell2.isOtherwise()) {
                        bSplit = false;
                        if (cell1 instanceof CellValue.GroupedCellValue && (gcv = (CellValue.GroupedCellValue)cell1).hasMultipleValues()) {
                            bSplit = true;
                        }
                        if (cell2 instanceof CellValue.GroupedCellValue && (gcv = (CellValue.GroupedCellValue)cell2).hasMultipleValues()) {
                            bSplit = true;
                        }
                    }
                    if (!bSplit) continue;
                    this.mergeCells(cell1, cell2);
                    cell1 = cell2;
                }
            }
            this.data.remove(blankRow);
        }
        this.assertModelIndexes();
    }

    private List<DynamicDataRow> expandGroupedRow(DynamicDataRow row, boolean bRecursive) {
        ArrayList<DynamicDataRow> ungroupedRows = new ArrayList<DynamicDataRow>();
        if (row instanceof GroupedDynamicDataRow) {
            GroupedDynamicDataRow groupedRow = (GroupedDynamicDataRow)row;
            for (int iChildRow = 0; iChildRow < groupedRow.getChildRows().size(); ++iChildRow) {
                DynamicDataRow childRow = (DynamicDataRow)groupedRow.getChildRows().get(iChildRow);
                if (bRecursive) {
                    if (childRow instanceof GroupedDynamicDataRow) {
                        List expandedRow = this.expandGroupedRow(childRow, bRecursive);
                        ungroupedRows.addAll(expandedRow);
                        continue;
                    }
                    this.ungroupCells(childRow);
                    ungroupedRows.add(childRow);
                    continue;
                }
                ungroupedRows.add(childRow);
            }
        } else {
            this.ungroupCells(row);
            ungroupedRows.add(row);
        }
        return ungroupedRows;
    }

    private Coordinate findMergedCellExtent(Coordinate c) {
        if (c.getRow() == this.data.size() - 1) {
            return c;
        }
        Coordinate nc = new Coordinate(c.getRow() + 1, c.getCol());
        CellValue newCell = this.get(nc);
        while (newCell.getRowSpan() == 0 && nc.getRow() < this.data.size() - 1) {
            nc = new Coordinate(nc.getRow() + 1, nc.getCol());
            newCell = this.get(nc);
        }
        if (newCell.getRowSpan() != 0) {
            nc = new Coordinate(nc.getRow() - 1, nc.getCol());
            newCell = this.get(nc);
        }
        return nc;
    }

    private void mergeCells(CellValue<?> cell1, CellValue<?> cell2) {
        int iStartRowIndex = cell1.getCoordinate().getRow();
        int iEndRowIndex = cell2.getCoordinate().getRow();
        int iColIndex = cell1.getCoordinate().getCol();
        for (int iRow = iStartRowIndex; iRow < iEndRowIndex; ++iRow) {
            DynamicDataRow row = (DynamicDataRow)this.data.get(iRow);
            row.get(iColIndex).setRowSpan(0);
        }
        cell1.setRowSpan(iEndRowIndex - iStartRowIndex);
    }

    private void ungroupCells(DynamicDataRow row) {
        for (int iCol = 0; iCol < row.size(); ++iCol) {
            CellValue cell = row.get(iCol);
            cell.removeState(CellValue.CellState.GROUPED);
        }
    }

    void removeModelGrouping() {
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            DynamicDataRow row = (DynamicDataRow)this.data.get(iRow);
            if (!(row instanceof GroupedDynamicDataRow)) continue;
            List expandedRow = this.expandGroupedRow(row, true);
            this.deleteRow(iRow);
            this.data.addAll(iRow, expandedRow);
            iRow = iRow + expandedRow.size() - 1;
        }
    }

    void removeModelMerging() {
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            DynamicDataRow row = (DynamicDataRow)this.data.get(iRow);
            for (int iCol = 0; iCol < row.size(); ++iCol) {
                CellValue cell = row.get(iCol);
                Coordinate c = new Coordinate(iRow, iCol);
                cell.setCoordinate(c);
                cell.setHtmlCoordinate(c);
                cell.setPhysicalCoordinate(c);
                cell.setRowSpan(1);
            }
        }
        this.assertModelIndexes();
    }
}

