/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.guvnor.server.security.PackageNameType;
import org.drools.guvnor.server.security.PackageUUIDType;
import org.drools.guvnor.server.security.RoleType;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

public class ServiceSecurity {
    protected void checkSecurityIsAdmin() {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), RoleType.ADMIN.getName());
        }
    }

    protected boolean isSecurityIsAnalystReadWithTargetObject(Object target) {
        if (Contexts.isSessionContextActive()) {
            return Identity.instance().hasPermission(target, RoleType.ANALYST_READ.getName());
        }
        return true;
    }

    protected void checkPermissionAnalystReadWithCategoryPathType(String categoryPath) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new CategoryPathType(categoryPath), RoleType.ANALYST_READ.getName());
        }
    }

    protected boolean hasPermissionAnalystReadWithCategoryPathType(String categoryPath) {
        if (Contexts.isSessionContextActive()) {
            return Identity.instance().hasPermission((Object)new CategoryPathType(categoryPath), RoleType.ANALYST_READ.getName());
        }
        return true;
    }

    protected void checkSecurityIsPackageAdminWithPackageName(String packageName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), RoleType.PACKAGE_ADMIN.getName());
        }
    }

    protected void checkSecurityIsPackageAdminWithAdminType() {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new AdminType(), RoleType.PACKAGE_ADMIN.getName());
        }
    }

    protected void checkSecurityIsPackageAdminWithPackageUuid(String uuid) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(uuid), RoleType.PACKAGE_ADMIN.getName());
        }
    }

    protected void checkSecurityIsPackageDeveloperWithPackageUuid(String uuid) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(uuid), RoleType.PACKAGE_DEVELOPER.getName());
        }
    }

    protected void checkSecurityIsPackageDeveloperWithPackageName(String packageName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), RoleType.PACKAGE_DEVELOPER.getName());
        }
    }

    protected void checkSecurityIsPackageReadOnlyWithPackageName(String packageName) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageNameType(packageName), RoleType.PACKAGE_READONLY.getName());
        }
    }

    protected void checkSecurityPackageReadOnlyWithPackageUuid(String uuid) {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(uuid), RoleType.PACKAGE_READONLY.getName());
        }
    }
}

