/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.server.AssetItemFilter;
import org.drools.guvnor.server.builder.pagerow.PageRowBuilder;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.util.QueryPageRowCreator;
import org.drools.repository.AssetItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickFindPageRowBuilder
implements PageRowBuilder<PageRequest, Iterator<AssetItem>> {
    private PageRequest pageRequest;
    private Iterator<AssetItem> iterator;

    public List<QueryPageRow> build() {
        this.validate();
        int skipped = 0;
        Integer pageSize = this.pageRequest.getPageSize();
        int startRowIndex = this.pageRequest.getStartRowIndex();
        AssetItemFilter filter = new AssetItemFilter();
        ArrayList<QueryPageRow> rowList = new ArrayList<QueryPageRow>();
        while (this.iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            AssetItem assetItem = (AssetItem)this.iterator.next();
            if (!filter.accept((Object)assetItem, RoleType.PACKAGE_READONLY.getName())) continue;
            if (skipped >= startRowIndex) {
                rowList.add(QueryPageRowCreator.makeQueryPageRow((AssetItem)assetItem));
            }
            ++skipped;
        }
        return rowList;
    }

    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.iterator == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public QuickFindPageRowBuilder withPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public QuickFindPageRowBuilder withContent(Iterator<AssetItem> iterator) {
        this.iterator = iterator;
        return this;
    }
}

