/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.server.builder.ClassLoaderBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ICanHasAttachment;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.rule.MapBackedClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ModelContentHandler
extends ContentHandler
implements ICanHasAttachment {
    public void retrieveAssetContent(RuleAsset asset, AssetItem item) throws SerializationException {
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializationException {
    }

    public void onAttachmentAdded(AssetItem asset) throws IOException {
        PackageItem pkg = asset.getPackage();
        StringBuilder header = this.createNewHeader(DroolsHeader.getDroolsHeader((PackageItem)pkg));
        Set imports = this.getImportsFromJar(asset);
        for (String importLine : imports) {
            Pattern pattern = Pattern.compile("\\b" + importLine.replace(".", "\\.") + "\\b");
            if (pattern.matcher(header).find()) continue;
            header.append(importLine).append("\n");
        }
        DroolsHeader.updateDroolsHeader((String)header.toString(), (PackageItem)pkg);
        pkg.checkin("Imports setup automatically on model import.");
    }

    public void onAttachmentRemoved(AssetItem item) throws IOException {
        PackageItem pkg = item.getPackage();
        StringBuilder header = this.createNewHeader(DroolsHeader.getDroolsHeader((PackageItem)pkg));
        Set imports = this.getImportsFromJar(item);
        for (String importLine : imports) {
            String importLineWithLineEnd = importLine + "\n";
            header = this.removeImportIfItExists(header, importLineWithLineEnd);
        }
        DroolsHeader.updateDroolsHeader((String)header.toString(), (PackageItem)pkg);
        pkg.checkin("Imports removed automatically on model archiving.");
    }

    private StringBuilder removeImportIfItExists(StringBuilder header, String importLine) {
        if (header.indexOf(importLine) >= 0) {
            int indexOfImportLine = header.indexOf(importLine);
            header = header.replace(indexOfImportLine, indexOfImportLine + importLine.length(), "");
        }
        return header;
    }

    private StringBuilder createNewHeader(String header) {
        StringBuilder buf = new StringBuilder();
        if (header != null) {
            buf.append(header);
            buf.append('\n');
        }
        return buf;
    }

    private Set<String> getImportsFromJar(AssetItem assetItem) throws IOException {
        HashSet<String> imports = new HashSet<String>();
        HashMap<String, String> nonCollidingImports = new HashMap<String, String>();
        String assetPackageName = assetItem.getPackageName();
        JarInputStream cljis = new JarInputStream(assetItem.getBinaryContentAttachment());
        ArrayList<JarInputStream> jarInputStreams = new ArrayList<JarInputStream>();
        jarInputStreams.add(cljis);
        ClassLoaderBuilder clb = new ClassLoaderBuilder(jarInputStreams);
        MapBackedClassLoader cl = clb.buildClassLoader();
        JarInputStream jis = new JarInputStream(assetItem.getBinaryContentAttachment());
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            String leafName;
            String fullyQualifiedName;
            if (entry.isDirectory() || !entry.getName().endsWith(".class") || entry.getName().indexOf(36) != -1 || entry.getName().endsWith("package-info.class") || !this.isClassVisible((ClassLoader)cl, fullyQualifiedName = ModelContentHandler.convertPathToName((String)entry.getName()), assetPackageName) || nonCollidingImports.containsKey(leafName = this.getLeafName(fullyQualifiedName))) continue;
            nonCollidingImports.put(leafName, fullyQualifiedName);
        }
        for (String value : nonCollidingImports.values()) {
            String line = "import " + value;
            imports.add(line);
        }
        return imports;
    }

    private String getLeafName(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(".");
        if (index == -1) {
            return fullyQualifiedName;
        }
        return fullyQualifiedName.substring(index + 1);
    }

    private boolean isClassVisible(ClassLoader cl, String className, String assetPackageName) {
        try {
            Class<?> cls = cl.loadClass(className);
            int modifiers = cls.getModifiers();
            if (Modifier.isPublic(modifiers)) {
                return true;
            }
            String packageName = className.substring(0, className.lastIndexOf("."));
            if (!packageName.equals(assetPackageName)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String convertPathToName(String name) {
        return name.replace(".class", "").replace("/", ".");
    }
}

