/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.server.RepositoryPackageService;
import org.drools.guvnor.server.RepositoryServiceServlet;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.files.AssetZipper;
import org.drools.guvnor.server.files.FileManagerUtils;
import org.drools.guvnor.server.files.PackageDeploymentURIHelper;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.util.FormData;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepositoryException;

/*
 * Exception performing whole class analysis ignored.
 */
public class PackageDeploymentServlet
extends RepositoryServlet {
    private static final long serialVersionUID = 510L;
    public static final String RFC822DATEFORMAT = "EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z";
    public static final Locale HEADER_LOCALE = Locale.US;

    protected long getLastModified(HttpServletRequest request) {
        PackageDeploymentURIHelper helper = null;
        try {
            helper = new PackageDeploymentURIHelper(request.getRequestURI());
            FileManagerUtils fm = PackageDeploymentServlet.getFileManager();
            return fm.getLastModified(helper.getPackageName(), helper.getVersion());
        }
        catch (UnsupportedEncodingException e) {
            return super.getLastModified(request);
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getMethod().equals("HEAD")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", HEADER_LOCALE);
            PackageDeploymentURIHelper helper = new PackageDeploymentURIHelper(request.getRequestURI());
            FileManagerUtils fm = PackageDeploymentServlet.getFileManager();
            long mod = fm.getLastModified(helper.getPackageName(), helper.getVersion());
            response.addHeader("lastModified", "" + mod);
            response.addHeader("Last-Modified", dateFormat.format(new Date(mod)));
        } else {
            super.doHead(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        String packageName = request.getParameter("packageName");
        FormData data = FileManagerUtils.getFormData((HttpServletRequest)request);
        try {
            PackageDeploymentServlet.getFileManager().importClassicDRL(data.getFile().getInputStream(), packageName);
            response.getWriter().write("OK");
        }
        catch (IllegalArgumentException e) {
            response.getWriter().write(e.getMessage());
        }
        catch (DroolsParserException e) {
            response.getWriter().write("Unable to process import: " + e.getMessage());
        }
        catch (RulesRepositoryException e) {
            response.getWriter().write("Unable to process import: " + e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, (RepositoryServlet.Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doRunScenarios(PackageDeploymentURIHelper helper, ByteArrayOutputStream out) throws IOException {
        ServiceImplementation serv = RepositoryServiceServlet.getService();
        RepositoryPackageService packageService = RepositoryServiceServlet.getPackageService();
        PackageItem pkg = helper.isLatest() ? serv.getRulesRepository().loadPackage(helper.getPackageName()) : serv.getRulesRepository().loadPackageSnapshot(helper.getPackageName(), helper.getVersion());
        try {
            BulkTestRunResult result = packageService.runScenariosInPackage(pkg);
            out.write(result.toString().getBytes());
        }
        catch (DetailedSerializationException e) {
            log.error("Unable to run scenarios.", (Throwable)e);
            out.write(e.getMessage().getBytes());
        }
        catch (SerializationException e) {
            log.error("Unable to run scenarios.", (Throwable)e);
            out.write(e.getMessage().getBytes());
        }
    }

    public InputStream zipModel(PackageItem pkg) {
        LinkedList<AssetItem> jarAssets = new LinkedList<AssetItem>();
        AssetZipper assetZipper = null;
        Iterator it = pkg.getAssets();
        while (it.hasNext()) {
            AssetItem asset = (AssetItem)it.next();
            if (!asset.getFormat().contentEquals("jar")) continue;
            jarAssets.add(asset);
        }
        if (jarAssets.size() != 0) {
            assetZipper = new AssetZipper(jarAssets, pkg);
            return assetZipper.zipAssets();
        }
        return null;
    }

    static /* synthetic */ void access$000(PackageDeploymentServlet x0, PackageDeploymentURIHelper x1, ByteArrayOutputStream x2) throws IOException {
        x0.doRunScenarios(x1, x2);
    }
}

