/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.util.LoggingHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class RepositoryBackupServlet
extends RepositoryServlet {
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryBackupServlet.class);
    private static final long serialVersionUID = 510L;
    private static final List<String> zipMimeTypes = new ArrayList();

    public RepositoryBackupServlet() {
        zipMimeTypes.add("application/zip");
        zipMimeTypes.add("application/x-compress");
        zipMimeTypes.add("application/x-compressed");
        zipMimeTypes.add("application/x-zip");
        zipMimeTypes.add("application/x-zip-compressed");
        zipMimeTypes.add("application/zip-compressed");
        zipMimeTypes.add("application/x-7zip-compressed");
        zipMimeTypes.add("application/x-sdlc");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doAuthorizedAction(request, response, (RepositoryServlet.Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isFileZipped(FileItem file) throws IOException {
        String mimeType = file.getContentType().toLowerCase();
        return zipMimeTypes.contains(mimeType);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, (RepositoryServlet.Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void processExportRepoConfig(HttpServletResponse res, String repoConfig) throws IOException {
        log.debug("Exporting Repository Config...");
        res.setContentType("application/x-download");
        res.setHeader("Content-Disposition", "attachment; filename=repository.xml;");
        log.debug("Starting to process repository configuration");
        res.getOutputStream().write(repoConfig.getBytes());
        res.getOutputStream().flush();
        log.debug("Done exporting repository config!");
    }

    private void processExportRepositoryDownload(HttpServletResponse res) throws PathNotFoundException, IOException, RepositoryException {
        log.debug("Exporting...");
        res.setContentType("application/zip");
        res.setHeader("Content-Disposition", "attachment; filename=repository_export.zip;");
        log.debug("Starting to process export");
        ZipOutputStream zout = new ZipOutputStream((OutputStream)res.getOutputStream());
        zout.putNextEntry(new ZipEntry("repository_export.xml"));
        RepositoryBackupServlet.getFileManager().exportRulesRepository((OutputStream)zout);
        zout.closeEntry();
        zout.finish();
        res.getOutputStream().flush();
        log.debug("Done exporting!");
    }

    private void processExportPackageFromRepositoryDownload(HttpServletResponse res, String packageName) throws PathNotFoundException, IOException, RepositoryException {
        res.setContentType("application/zip");
        res.setHeader("Content-Disposition", "inline; filename=" + packageName + ".zip;");
        res.getOutputStream().write(RepositoryBackupServlet.getFileManager().exportPackageFromRepository(packageName));
        res.getOutputStream().flush();
    }

    private String processImportRepository(InputStream file) throws IOException {
        RepositoryBackupServlet.getFileManager().importRulesRepository(file);
        return "OK";
    }

    private String processImportPackage(InputStream file, boolean importAsNew) throws IOException {
        byte[] byteArray = new byte[file.available()];
        file.read(byteArray);
        RepositoryBackupServlet.getFileManager().importPackageToRepository(byteArray, importAsNew);
        return "OK";
    }

    static /* synthetic */ void access$000(RepositoryBackupServlet x0, HttpServletResponse x1, String x2) throws IOException {
        x0.processExportRepoConfig(x1, x2);
    }

    static /* synthetic */ boolean access$100(RepositoryBackupServlet x0, FileItem x1) throws IOException {
        return x0.isFileZipped(x1);
    }

    static /* synthetic */ String access$200(RepositoryBackupServlet x0, InputStream x1, boolean x2) throws IOException {
        return x0.processImportPackage(x1, x2);
    }

    static /* synthetic */ String access$300(RepositoryBackupServlet x0, InputStream x1) throws IOException {
        return x0.processImportRepository(x1);
    }

    static /* synthetic */ void access$400(RepositoryBackupServlet x0, HttpServletResponse x1) throws PathNotFoundException, IOException, RepositoryException {
        x0.processExportRepositoryDownload(x1);
    }

    static /* synthetic */ void access$500(RepositoryBackupServlet x0, HttpServletResponse x1, String x2) throws PathNotFoundException, IOException, RepositoryException {
        x0.processExportPackageFromRepositoryDownload(x1, x2);
    }
}

