/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import javax.jcr.RepositoryException;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RulesRepository;
import org.jbpm.compiler.xml.processes.RuleFlowMigrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MigrateRepository {
    private static final Logger log = LoggerFactory.getLogger(MigrateRepository.class);

    public static boolean needsRuleflowMigration(RulesRepository repo) throws RepositoryException {
        String portRuleFlow = System.getProperty("drools.ruleflow.port", "false");
        return portRuleFlow.equalsIgnoreCase("true");
    }

    public static void migrateRuleflows(RulesRepository repo) throws RepositoryException {
        log.debug("AUTO MIGRATION: Performing drools ruleflow migration...");
        PackageIterator pkgs = repo.listPackages();
        boolean performed = false;
        while (pkgs.hasNext()) {
            performed = true;
            PackageItem pkg = pkgs.next();
            MigrateRepository.migrateRuleflows((PackageItem)pkg);
            String[] snaps = repo.listPackageSnapshots(pkg.getName());
            if (snaps == null) continue;
            for (String snap1 : snaps) {
                PackageItem snap = repo.loadPackageSnapshot(pkg.getName(), snap1);
                MigrateRepository.migrateRuleflows((PackageItem)snap);
            }
        }
        if (performed) {
            log.debug("AUTO MIGRATION: Drools rulesflow migration completed.");
        }
    }

    private static void migrateRuleflows(PackageItem pkg) {
        String portRuleFlow = System.getProperty("drools.ruleflow.port", "false");
        if (portRuleFlow.equalsIgnoreCase("true")) {
            AssetItemIterator it = MigrateRepository.listAssetsByFormatIncludingArchived((PackageItem)pkg, (String[])new String[]{"rf"});
            while (it.hasNext()) {
                AssetItem item = it.next();
                String rf = item.getContent();
                try {
                    if (RuleFlowMigrator.needToMigrateRFM((String)rf)) {
                        log.debug("Migrating v4 RFM to v5: " + item.getName());
                        rf = RuleFlowMigrator.portRFMToCurrentVersion((String)rf);
                        item.updateContent(rf);
                        item.checkin("Auto migration from ruleflow RFM version 4 to 5");
                        continue;
                    }
                    if (!RuleFlowMigrator.needToMigrateRF((String)rf)) continue;
                    log.debug("Migrating v4 RF to v5: " + item.getName());
                    rf = RuleFlowMigrator.portRFToCurrentVersion((String)rf);
                    item.updateContent(rf);
                    item.checkin("Auto migration from ruleflow RF version 4 to 5");
                }
                catch (Exception ex) {
                    log.error("Ruleflow migration failed for item: " + item.getName() + " due to " + ex);
                    ex.printStackTrace(System.out);
                }
            }
        }
    }

    private static AssetItemIterator listAssetsByFormatIncludingArchived(PackageItem pkg, String[] formats) {
        if (formats.length == 1) {
            return pkg.queryAssets("drools:format='" + formats[0] + "'", true);
        }
        String predicate = " ( ";
        for (int i = 0; i < formats.length; ++i) {
            predicate = predicate + "drools:format='" + formats[i] + "'";
            if (i == formats.length - 1) continue;
            predicate = predicate + " OR ";
        }
        predicate = predicate + " ) ";
        return pkg.queryAssets(predicate, true);
    }
}

