/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.verification;

import java.io.Reader;
import java.io.StringReader;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.DecisionTableInputType;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.server.builder.AssetValidationIterator;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.guvnor.server.verification.VerifierReportCreator;
import org.drools.io.ResourceFactory;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.ScopesAgendaFilter;
import org.drools.verifier.data.VerifierReport;

abstract class VerifierRunner {
    private final Verifier verifier;
    protected final PackageItem packageItem;

    public VerifierRunner(Verifier verifier, PackageItem packageItem) {
        this.verifier = verifier;
        this.packageItem = packageItem;
    }

    public AnalysisReport verify() {
        this.addHeaderToVerifier();
        this.addToVerifier(this.listAssetsByFormat("dsl"), ResourceType.DSL);
        this.addToVerifier(this.listAssetsByFormat("model.drl"), ResourceType.DRL);
        this.addToVerifier(this.listAssetsByFormat("function"), ResourceType.DRL);
        this.addToVerifier(this.listAssetsByFormat("dslr"), ResourceType.DSLR);
        this.addToVerifier(this.listAssetsByFormat("xls"), ResourceType.DTABLE);
        this.addGuidedDecisionTablesToVerifier();
        this.addRuleTemplatesToVerifier();
        this.addDRLRulesToVerifier();
        this.addToVerifier(this.listAssetsByFormat("brl"), ResourceType.BRL);
        this.fireAnalysis();
        VerifierReport report = this.verifier.getResult();
        return VerifierReportCreator.doReport((VerifierReport)report);
    }

    private void fireAnalysis() throws RuntimeException {
        this.verifier.fireAnalysis(this.getScopesAgendaFilter());
        if (this.verifier.hasErrors()) {
            StringBuilder message = new StringBuilder("Verifier Errors:\n");
            for (VerifierError verifierError : this.verifier.getErrors()) {
                message.append("\t");
                message.append(verifierError.getMessage());
                message.append("\n");
            }
            throw new RuntimeException(message.toString());
        }
    }

    protected abstract ScopesAgendaFilter getScopesAgendaFilter();

    private void addHeaderToVerifier() {
        StringBuilder header = new StringBuilder();
        header.append("package " + this.packageItem.getName() + "\n");
        header.append(DroolsHeader.getDroolsHeader((PackageItem)this.packageItem) + "\n");
        this.verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(header.toString())), ResourceType.DRL);
    }

    private void addGuidedDecisionTablesToVerifier() {
        this.addToVerifier(this.listAssetsByFormat("gdst"));
    }

    private void addDRLRulesToVerifier() {
        this.addToVerifier(this.listAssetsByFormat("drl"));
    }

    private void addRuleTemplatesToVerifier() {
        this.addToVerifier(this.listAssetsByFormat("template"));
    }

    protected abstract AssetValidationIterator listAssetsByFormat(String var1);

    private void addToVerifier(AssetValidationIterator assets, ResourceType resourceType) {
        while (assets.hasNext()) {
            AssetItem asset = assets.next();
            if (asset.isArchived() || asset.getDisabled()) continue;
            if (resourceType == ResourceType.DTABLE) {
                DecisionTableConfiguration dtableconfiguration = KnowledgeBuilderFactory.newDecisionTableConfiguration();
                dtableconfiguration.setInputType(DecisionTableInputType.XLS);
                this.verifier.addResourcesToVerify(ResourceFactory.newByteArrayResource((byte[])asset.getBinaryContentAsBytes()), resourceType, (ResourceConfiguration)dtableconfiguration);
                continue;
            }
            this.verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(asset.getContent())), resourceType);
        }
    }

    private void addToVerifier(AssetValidationIterator assetItemIterator) {
        while (assetItemIterator.hasNext()) {
            AssetItem assetItem = assetItemIterator.next();
            ContentHandler contentHandler = ContentManager.getHandler((String)assetItem.getFormat());
            if (!contentHandler.isRuleAsset()) continue;
            IRuleAsset ruleAsset = (IRuleAsset)contentHandler;
            String drl = ruleAsset.getRawDRL(assetItem);
            this.verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        }
    }
}

