/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scanner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.drools.core.util.FileManager;
import org.drools.scanner.MavenRepository;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.builder.GAV;
import org.kie.builder.KieBaseModel;
import org.kie.builder.KieBuilder;
import org.kie.builder.KieContainer;
import org.kie.builder.KieFactory;
import org.kie.builder.KieFileSystem;
import org.kie.builder.KieModuleModel;
import org.kie.builder.KieScanner;
import org.kie.builder.KieServices;
import org.kie.builder.KieSessionModel;
import org.kie.builder.impl.InternalKieModule;
import org.kie.conf.AssertBehaviorOption;
import org.kie.conf.EventProcessingOption;
import org.kie.runtime.KieSession;
import org.kie.runtime.conf.ClockTypeOption;

public class KieRepositoryScannerTest {
    private FileManager fileManager;
    private File kPom;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        this.kPom = this.createKPom("1.0-SNAPSHOT");
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
    }

    private void resetFileManager() {
        this.fileManager.tearDown();
        this.fileManager = new FileManager();
        this.fileManager.setUp();
    }

    @Test
    @Ignore
    public void testKScanner() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFactory kf = KieFactory.Factory.get();
        GAV gav = kf.newGav("org.kie", "scanner-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar(ks, kf, gav, "rule1", "rule2");
        KieContainer kieContainer = ks.getKieContainer(gav);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(gav, kJar1, this.kPom);
        KieSession ksession = kieContainer.getKieSession("KSession1");
        this.checkKSession(ksession, "rule1", "rule2");
        InternalKieModule kJar2 = this.createKieJar(ks, kf, gav, "rule2", "rule3");
        repository.deployArtifact(gav, kJar2, this.kPom);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        scanner.scanNow();
        KieSession ksession2 = kieContainer.getKieSession("KSession1");
        this.checkKSession(ksession2, "rule2", "rule3");
    }

    @Test
    @Ignore
    public void testKScannerWithKJarContainingClasses() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFactory kf = KieFactory.Factory.get();
        GAV gav = kf.newGav("org.kie", "scanner-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJarWithClass(ks, kf, gav, 2, 7);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(gav, kJar1, this.kPom);
        KieContainer kieContainer = ks.getKieContainer(gav);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        KieSession ksession = kieContainer.getKieSession("KSession1");
        this.checkKSession(ksession, 14);
        InternalKieModule kJar2 = this.createKieJarWithClass(ks, kf, gav, 3, 5);
        repository.deployArtifact(gav, kJar2, this.kPom);
        scanner.scanNow();
        KieSession ksession2 = kieContainer.getKieSession("KSession1");
        this.checkKSession(ksession2, 15);
    }

    @Test
    @Ignore
    public void testLoadKieJarFromMavenRepo() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFactory kf = KieFactory.Factory.get();
        KieContainer kieContainer = ks.getKieContainer(kf.newGav("org.kie", "scanner-test", "1.0-SNAPSHOT"));
        KieSession ksession2 = kieContainer.getKieSession("KSession1");
        this.checkKSession(ksession2, 15);
    }

    @Test
    @Ignore
    public void testScannerOnPomProject() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFactory kf = KieFactory.Factory.get();
        GAV gav1 = kf.newGav("org.kie", "scanner-test", "1.0");
        GAV gav2 = kf.newGav("org.kie", "scanner-test", "2.0");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployPomArtifact("org.kie", "scanner-master-test", "1.0", this.createMasterKPom());
        this.resetFileManager();
        InternalKieModule kJar1 = this.createKieJarWithClass(ks, kf, gav1, 2, 7);
        repository.deployArtifact(gav1, kJar1, this.createKPom("1.0"));
        KieContainer kieContainer = ks.getKieContainer(kf.newGav("org.kie", "scanner-master-test", "1.0"));
        KieSession ksession = kieContainer.getKieSession("KSession1");
        this.checkKSession(ksession, 14);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        InternalKieModule kJar2 = this.createKieJarWithClass(ks, kf, gav2, 3, 5);
        repository.deployArtifact(gav2, kJar2, this.createKPom("2.0"));
        scanner.scanNow();
        KieSession ksession2 = kieContainer.getKieSession("KSession1");
        this.checkKSession(ksession2, 15);
    }

    private File createKPom(String version) throws IOException {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>org.kie</groupId>\n  <artifactId>scanner-test</artifactId>\n  <version>" + version + "</version>\n" + "\n" + "</project>";
        File pomFile = this.fileManager.newFile("pom.xml");
        this.fileManager.write(pomFile, pom);
        return pomFile;
    }

    private File createMasterKPom() throws IOException {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>org.kie</groupId>\n  <artifactId>scanner-master-test</artifactId>\n  <version>1.0</version>\n  <packaging>pom</packaging>\n\n    <dependencies>\n      <dependency>\n        <groupId>org.kie</groupId>\n        <artifactId>scanner-test</artifactId>\n        <version>LATEST</version>\n      </dependency>\n    </dependencies>\n</project>";
        File pomFile = this.fileManager.newFile("pom.xml");
        this.fileManager.write(pomFile, pom);
        return pomFile;
    }

    private InternalKieModule createKieJar(KieServices ks, KieFactory kf, GAV gav, String ... rules) throws IOException {
        KieFileSystem kfs = kf.newKieFileSystem();
        for (String rule : rules) {
            String file = "org/test/" + rule + ".drl";
            kfs.write("src/main/resources/KBase1/" + file, this.createDRL(rule));
        }
        KieModuleModel kproj = kf.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase1").setEqualsBehavior(AssertBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksession1 = kieBaseModel1.newKieSessionModel("KSession1").setType("stateful").setClockType(ClockTypeOption.get((String)"realtime"));
        kfs.writeKModuleXML(kproj.toXML());
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.build().getInsertedMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    private String createDRL(String ruleName) {
        return "package org.kie.test\nglobal java.util.List list\nrule " + ruleName + "\n" + "when\n" + "then\n" + "list.add( drools.getRule().getName() );\n" + "end\n";
    }

    private void checkKSession(KieSession ksession, Object ... results) {
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)results.length, (long)list.size());
        for (Object result : results) {
            Assert.assertTrue((boolean)list.contains(result));
        }
    }

    private InternalKieModule createKieJarWithClass(KieServices ks, KieFactory kf, GAV gav, int value, int factor) throws IOException {
        KieFileSystem kieFileSystem = kf.newKieFileSystem();
        KieModuleModel kproj = kf.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase1").setEqualsBehavior(AssertBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksession1 = kieBaseModel1.newKieSessionModel("KSession1").setType("stateful").setClockType(ClockTypeOption.get((String)"realtime"));
        kieFileSystem.writeKModuleXML(kproj.toXML()).write("src/kbases/" + kieBaseModel1.getName() + "/rule1.drl", this.createDRLForJavaSource(value)).write("src/main/java/org/kie/test/Bean.java", this.createJavaSource(factor));
        KieBuilder kieBuilder = ks.newKieBuilder(kieFileSystem);
        Assert.assertTrue((boolean)kieBuilder.build().getInsertedMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    private String createJavaSource(int factor) {
        return "package org.kie.test;\npublic class Bean {\n   private final int value;\n   public Bean(int value) {\n       this.value = value;\n   }\n   public int getValue() {\n       return value * " + factor + ";\n" + "   }\n" + "}";
    }

    private String createDRLForJavaSource(int value) {
        return "package org.kie.test\nglobal java.util.List list\nrule Init\nwhen\nthen\ninsert( new Bean(" + value + ") );\n" + "end\n" + "rule R1\n" + "when\n" + "   $b : Bean()\n" + "then\n" + "   list.add( $b.getValue() );\n" + "end\n";
    }
}

