/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import java.math.BigInteger;
import org.dmg.pmml.pmml_4_2.descr.Array;
import org.dmg.pmml.pmml_4_2.descr.SimpleSetPredicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.pmml_4_2.model.mining.SimpleSetSegmentPredicate;

public class SimpleSetSegmentPredicateTest {
    private SimpleSetPredicate predicate;

    @Before
    public void setUp() throws Exception {
        this.predicate = new SimpleSetPredicate();
        this.predicate.setField("TF1");
        this.predicate.setBooleanOperator("isIn");
    }

    private void doPredicateRetrieve(String expected) {
        SimpleSetSegmentPredicate sssp = new SimpleSetSegmentPredicate(this.predicate);
        String text = sssp.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)expected, (Object)text);
    }

    @Test
    public void testSimpleIntSet() {
        Array array = new Array();
        array.setType("int");
        array.setContent("1 33 45");
        array.setN(new BigInteger("3"));
        this.predicate.setArray(array);
        String expected = "vTF1 in (  1,  33,  45 )";
        this.doPredicateRetrieve(expected);
    }

    @Test
    public void testSimpleRealSet() {
        Array array = new Array();
        array.setType("real");
        array.setContent("3.14 29.5   17 71");
        array.setN(new BigInteger("4"));
        this.predicate.setArray(array);
        String expected = "vTF1 in (  3.14,  29.5,  17.0,  71.0 )";
        this.doPredicateRetrieve(expected);
    }

    @Test
    public void testSimpleStringSet() {
        Array array = new Array();
        array.setType("string");
        StringBuilder bldr = new StringBuilder();
        for (int x = 0; x < 4; ++x) {
            bldr.append("\"").append("testValue ").append(x).append("\" ");
        }
        array.setContent(bldr.toString());
        array.setN(new BigInteger("4"));
        this.predicate.setArray(array);
        String expected = "vTF1 in (  \"testValue 0\" ,  \"testValue 1\" ,  \"testValue 2\" ,  \"testValue 3\"  )";
        this.doPredicateRetrieve(expected);
    }

    @Test(expected=IllegalStateException.class)
    public void testInvalidItemCount() {
        Array array = new Array();
        array.setType("int");
        array.setContent("1 33 45");
        array.setN(new BigInteger("2"));
        this.predicate.setArray(array);
        this.doPredicateRetrieve(null);
    }

    @Test
    public void testNegativeMembership() {
        Array array = new Array();
        array.setType("real");
        array.setContent("3.14 29.5   17 71");
        array.setN(new BigInteger("4"));
        this.predicate.setArray(array);
        this.predicate.setBooleanOperator("isNotIn");
        String expected = "vTF1 not in (  3.14,  29.5,  17.0,  71.0 )";
        this.doPredicateRetrieve(expected);
    }
}

