/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models;

import java.util.List;
import org.drools.core.impl.InternalKnowledgeBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.api.runtime.rule.RuleUnitExecutor;
import org.kie.pmml.pmml_4_2.DroolsAbstractPMMLTest;

public class SimpleRegressionTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = true;
    private static final String source1 = "org/kie/pmml/pmml_4_2/test_regression.pmml";
    private static final String source2 = "org/kie/pmml/pmml_4_2/test_regression_clax.pmml";
    private static final String packageName = "org.kie.pmml.pmml_4_2.test";

    @After
    public void tearDown() {
    }

    @Test
    public void testRegression() throws Exception {
        RuleUnitExecutor executor = this.createExecutor(source1);
        PMMLRequestData request = new PMMLRequestData("123", "LinReg");
        request.addRequestParam("fld1", (Object)0.9);
        request.addRequestParam("fld2", (Object)0.3);
        request.addRequestParam("fld3", (Object)"x");
        PMML4Result resultHolder = new PMML4Result();
        List<String> possiblePackages = this.calculatePossiblePackageNames("LinReg", new String[0]);
        Class<? extends RuleUnit> unitClass = this.getStartingRuleUnit("RuleUnitIndicator", (InternalKnowledgeBase)this.kbase, possiblePackages);
        Assert.assertNotNull(unitClass);
        int x = executor.run(unitClass);
        this.data.insert((Object)request);
        this.resultData.insert((Object)resultHolder);
        executor.run(unitClass);
        Assert.assertEquals((Object)"OK", (Object)resultHolder.getResultCode());
        Assert.assertNotNull((Object)resultHolder.getResultValue("Fld4", null, new Object[0]));
        Double value = resultHolder.getResultValue("Fld4", "value", Double.class, new Object[0]).orElse(null);
        Assert.assertNotNull((Object)value);
        double chkVal = 2.2579999999999996;
        chkVal = 1.0 / (1.0 + Math.exp(-chkVal));
        Assert.assertEquals((double)chkVal, (double)value, (double)1.0E-6);
    }

    @Test
    public void testClassification() throws Exception {
        RuleUnitExecutor executor = this.createExecutor(source2);
        PMMLRequestData request = new PMMLRequestData("123", "LinReg");
        request.addRequestParam("fld1", (Object)1.0);
        request.addRequestParam("fld2", (Object)1.0);
        request.addRequestParam("fld3", (Object)"x");
        PMML4Result resultHolder = new PMML4Result();
        List<String> possiblePackages = this.calculatePossiblePackageNames("LinReg", new String[0]);
        Class<? extends RuleUnit> unitClass = this.getStartingRuleUnit("RuleUnitIndicator", (InternalKnowledgeBase)this.kbase, possiblePackages);
        Assert.assertNotNull(unitClass);
        int x = executor.run(unitClass);
        this.data.insert((Object)request);
        this.resultData.insert((Object)resultHolder);
        executor.run(unitClass);
        Assert.assertNotNull((Object)resultHolder.getResultValue("RegOut", null, new Object[0]));
        Assert.assertNotNull((Object)resultHolder.getResultValue("RegProb", null, new Object[0]));
        Assert.assertNotNull((Object)resultHolder.getResultValue("RegProbA", null, new Object[0]));
        String regOut = resultHolder.getResultValue("RegOut", "value", String.class, new Object[0]).orElse(null);
        Double regProb = resultHolder.getResultValue("RegProb", "value", Double.class, new Object[0]).orElse(null);
        Double regProbA = resultHolder.getResultValue("RegProbA", "value", Double.class, new Object[0]).orElse(null);
        Assert.assertEquals((Object)"catC", (Object)regOut);
        Assert.assertEquals((double)0.709228, (double)regProb, (double)1.0E-6);
        Assert.assertEquals((double)0.010635, (double)regProbA, (double)1.0E-6);
    }
}

