/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EventFactHandle;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKieContainer;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.InternalRuleUnitExecutor;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.ruleunit.RuleUnitDescription;
import org.junit.Assert;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.pmml.PMML4Data;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.DataSource;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.api.runtime.rule.RuleUnitExecutor;
import org.kie.api.runtime.rule.Variable;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;
import org.kie.pmml.pmml_4_2.model.PMML4UnitImpl;

public abstract class DroolsAbstractPMMLTest {
    public static final String PMML = "org.dmg.pmml.pmml_4_2.descr";
    public static final String BASE_PACK = DroolsAbstractPMMLTest.class.getPackage().getName();
    public static final String RESOURCE_PATH = "src/main/resources/" + BASE_PACK.replace('.', '/') + "/";
    public static final String DEFAULT_KIEBASE = "PMML_Test";
    protected DataSource<PMMLRequestData> data;
    protected DataSource<PMML4Result> resultData;
    protected DataSource<PMML4Data> pmmlData;
    private KieSession kSession;
    protected KieBase kbase;

    protected KieSession getModelSession(String pmmlSource) {
        return this.getModelSession(new String[]{pmmlSource}, false);
    }

    protected KieSession getModelSession(String pmmlSource, boolean verbose) {
        return this.getModelSession(new String[]{pmmlSource}, verbose);
    }

    protected KieSession getModelSession(File fileName) {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel model = ks.newKieModuleModel();
        model.setConfigurationProperty("drools.propertySpecific", "ALLOWED");
        KieBaseModel kbModel = model.newKieBaseModel(DEFAULT_KIEBASE).addPackage(BASE_PACK).setEventProcessingMode(EventProcessingOption.CLOUD);
        KieBuilder kb = ks.newKieBuilder(fileName);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        KieBase kieBase = kContainer.getKieBase();
        this.setKbase(kieBase);
        return kieBase.newKieSession();
    }

    protected KieSession getModelSession(String[] pmmlSources, boolean verbose) {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieFileSystem kfs = ks.newKieFileSystem();
        for (int j = 0; j < pmmlSources.length; ++j) {
            Resource res = ResourceFactory.newClassPathResource((String)pmmlSources[j]).setResourceType(ResourceType.PMML);
            kfs.write(res);
        }
        KieModuleModel model = ks.newKieModuleModel();
        model.setConfigurationProperty("drools.propertySpecific", "ALLOWED");
        KieBaseModel kbModel = model.newKieBaseModel(DEFAULT_KIEBASE).addPackage(BASE_PACK).setEventProcessingMode(EventProcessingOption.CLOUD);
        kfs.writeKModuleXML(model.toXML());
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        KieBase kieBase = kContainer.getKieBase();
        this.setKbase(kieBase);
        return kieBase.newKieSession();
    }

    protected KieSession getSession(String theory) {
        KieBase kbase = DroolsAbstractPMMLTest.readKnowledgeBase(new ByteArrayInputStream(theory.getBytes()));
        return kbase != null ? kbase.newKieSession() : null;
    }

    protected void refreshKSession() {
        if (this.getKSession() != null) {
            this.getKSession().dispose();
        }
        this.setKSession(this.getKbase().newKieSession());
    }

    private static KieBase readKnowledgeBase(InputStream theory) {
        return DroolsAbstractPMMLTest.readKnowledgeBase(Arrays.asList(theory));
    }

    private static KieBase readKnowledgeBase(List<InputStream> theory) {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieFileSystem kfs = ks.newKieFileSystem();
        for (int j = 0; j < theory.size(); ++j) {
            Resource res = ks.getResources().newInputStreamResource(theory.get(j));
            kfs.write(RESOURCE_PATH + "source_" + j + ".drl", res);
        }
        KieModuleModel model = ks.newKieModuleModel();
        KieBaseModel kbModel = model.newKieBaseModel(DEFAULT_KIEBASE).setDefault(true).addPackage(BASE_PACK).setEventProcessingMode(EventProcessingOption.STREAM);
        kfs.writeKModuleXML(model.toXML());
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        return kContainer.getKieBase();
    }

    public String reportWMObjects(KieSession session) {
        PriorityQueue<String> queue = new PriorityQueue<String>();
        for (FactHandle fh : session.getFactHandles()) {
            if (fh instanceof EventFactHandle) {
                EventFactHandle efh = (EventFactHandle)fh;
                queue.add("\t " + efh.getStartTimestamp() + "\t" + efh.getObject().toString() + "\n");
                continue;
            }
            Object o = ((DefaultFactHandle)fh).getObject();
            queue.add("\t " + o.toString() + " >> " + System.identityHashCode(o.getClass()) + "\n");
        }
        String ans = " ---------------- WM " + session.getObjects().size() + " --------------\n";
        while (!queue.isEmpty()) {
            ans = ans + (String)queue.poll();
        }
        ans = ans + " ---------------- END WM -----------\n";
        return ans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(String s, OutputStream ostream) {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(ostream, "UTF-8");
            writer.write(s);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    ((Writer)writer).flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public KieSession getKSession() {
        return this.kSession;
    }

    public void setKSession(KieSession kSession) {
        this.kSession = kSession;
    }

    public KieBase getKbase() {
        return this.kbase;
    }

    public void setKbase(KieBase kbase) {
        this.kbase = kbase;
    }

    protected void checkFirstDataFieldOfTypeStatus(FactType type, boolean valid, boolean missing, String ctx, Object ... target) {
        Object tgt;
        Class klass = type.getFactClass();
        Iterator iter = this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(klass)).iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Object obj = iter.next();
        if (ctx == null) {
            while (type.get(obj, "context") != null && iter.hasNext()) {
                obj = iter.next();
            }
        } else {
            while (!ctx.equals(type.get(obj, "context")) && iter.hasNext()) {
                obj = iter.next();
            }
        }
        if ((tgt = type.get(obj, "value")) instanceof Double) {
            assert (target[0] instanceof Double);
            Assert.assertEquals((double)((Double)target[0]), (double)((Double)tgt), (double)1.0E-6);
        } else {
            Assert.assertEquals((Object)target[0], (Object)tgt);
        }
        Assert.assertEquals((Object)valid, (Object)type.get(obj, "valid"));
        Assert.assertEquals((Object)missing, (Object)type.get(obj, "missing"));
    }

    protected double queryDoubleField(String target, String modelName) {
        QueryResults results = this.getKSession().getQueryResults(target, new Object[]{modelName, Variable.v});
        Assert.assertEquals((long)1L, (long)results.size());
        return (Double)((QueryResultsRow)results.iterator().next()).get("$result");
    }

    protected double queryIntegerField(String target, String modelName) {
        QueryResults results = this.getKSession().getQueryResults(target, new Object[]{modelName, Variable.v});
        Assert.assertEquals((long)1L, (long)results.size());
        return ((Integer)((QueryResultsRow)results.iterator().next()).get("$result")).intValue();
    }

    protected String queryStringField(String target, String modelName) {
        QueryResults results = this.getKSession().getQueryResults(target, new Object[]{modelName, Variable.v});
        Assert.assertEquals((long)1L, (long)results.size());
        return (String)((QueryResultsRow)results.iterator().next()).get("$result");
    }

    public Double getDoubleFieldValue(FactType type) {
        Class klass = type.getFactClass();
        Iterator iter = this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(klass)).iterator();
        Object obj = iter.next();
        return (Double)type.get(obj, "value");
    }

    public Object getFieldValue(FactType type) {
        Class klass = type.getFactClass();
        Iterator iter = this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(klass)).iterator();
        Object obj = iter.next();
        return type.get(obj, "value");
    }

    public void checkGeneratedRules() {
        this.checkGeneratedRules(BASE_PACK);
    }

    public void checkGeneratedRules(String pack) {
        for (Rule r : this.getKbase().getKiePackage(pack).getRules()) {
            Assert.assertTrue((boolean)r.getMetaData().containsKey("Generated"));
        }
    }

    protected String getGetterMethodName(Object wrapper, String fieldName, String prefix) {
        String capFieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        return prefix + capFieldName;
    }

    protected Object getResultValue(PMML4Result source, String objName, String objField, Object ... params) {
        Object value;
        block17: {
            Object holder;
            value = null;
            if (source != null && source.getResultVariables() != null && !source.getResultVariables().isEmpty() && (holder = source.getResultVariables().get(objName)) != null) {
                if (objField != null && !objField.trim().isEmpty()) {
                    String defFldRetriever = this.getGetterMethodName(holder, objField, "get");
                    try {
                        Class[] paramTypes = null;
                        Method m = null;
                        boolean retry = true;
                        if (params != null && params.length > 0) {
                            paramTypes = new Class[params.length];
                            for (int x = 0; x < params.length; ++x) {
                                paramTypes[x] = params[x].getClass();
                            }
                            do {
                                try {
                                    m = holder.getClass().getMethod(defFldRetriever, paramTypes);
                                }
                                catch (NoSuchMethodException nsmx) {
                                    if (m == null && defFldRetriever.startsWith("get")) {
                                        defFldRetriever = this.getGetterMethodName(holder, objField, "is");
                                        continue;
                                    }
                                    retry = false;
                                }
                            } while (m == null && retry);
                        } else {
                            do {
                                try {
                                    m = holder.getClass().getMethod(defFldRetriever, new Class[0]);
                                }
                                catch (NoSuchMethodException nsmx) {
                                    if (m == null && defFldRetriever.startsWith("get")) {
                                        defFldRetriever = this.getGetterMethodName(holder, objField, "is");
                                        continue;
                                    }
                                    retry = false;
                                }
                            } while (m == null && retry);
                        }
                        if (m == null) break block17;
                        if (params != null && params.length > 0) {
                            value = m.invoke(holder, params);
                            break block17;
                        }
                        value = m.invoke(holder, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    value = holder;
                }
            }
        }
        return value;
    }

    protected RuleUnitExecutor createExecutor(String sourceName) {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        ReleaseIdImpl releaseId = new ReleaseIdImpl("org.kie:pmmlTest:1.0-SNAPSHOT");
        ((KieRepositoryImpl)kr).setDefaultGAV((ReleaseId)releaseId);
        Resource res = ResourceFactory.newClassPathResource((String)sourceName);
        this.kbase = new KieHelper().addResource(res, ResourceType.PMML).build(new KieBaseOption[0]);
        Assert.assertNotNull((Object)this.kbase);
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(this.kbase);
        InternalKieContainer kc = ((KnowledgeBaseImpl)((InternalRuleUnitExecutor)executor).getKieSession().getKieBase()).getKieContainer();
        InternalKieModule ikm = (InternalKieModule)kr.getKieModule((ReleaseId)releaseId);
        try (FileOutputStream fos = new FileOutputStream("/tmp/outputModule.jar");){
            fos.write(ikm.getBytes());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        kc.getKieBaseNames().forEach(n -> System.out.println((String)n));
        this.data = executor.newDataSource("request", (Object[])new PMMLRequestData[0]);
        this.resultData = executor.newDataSource("results", (Object[])new PMML4Result[0]);
        this.pmmlData = executor.newDataSource("pmmlData", (Object[])new PMML4Data[0]);
        return executor;
    }

    protected Class<? extends RuleUnit> getStartingRuleUnit(String startingRule, InternalKnowledgeBase ikb, List<String> possiblePackages) {
        Map pkgs = ikb.getPackagesMap();
        RuleImpl ruleImpl = null;
        for (String pkgName : possiblePackages) {
            RuleUnitDescription descr;
            InternalKnowledgePackage pkg;
            if (!pkgs.containsKey(pkgName) || (ruleImpl = (pkg = (InternalKnowledgePackage)pkgs.get(pkgName)).getRule(startingRule)) == null || (descr = (RuleUnitDescription)ikb.getRuleUnitDescriptionRegistry().getDescription(ruleImpl).orElse(null)) == null) continue;
            return descr.getRuleUnitClass();
        }
        return null;
    }

    protected List<String> calculatePossiblePackageNames(String modelId, String ... knownPackageNames) {
        ArrayList<String> packageNames = new ArrayList<String>();
        String javaModelId = modelId.replaceAll("\\s", "");
        if (knownPackageNames != null && knownPackageNames.length > 0) {
            for (String knownPkgName : knownPackageNames) {
                packageNames.add(knownPkgName + "." + javaModelId);
            }
        }
        String basePkgName = PMML4UnitImpl.DEFAULT_ROOT_PACKAGE + "." + javaModelId;
        packageNames.add(basePkgName);
        return packageNames;
    }
}

