/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.InternalRuleUnitExecutor;
import org.drools.core.ruleunit.RuleUnitDescription;
import org.kie.api.KieBase;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.pmml.PMML4Data;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.runtime.rule.DataSource;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.api.runtime.rule.RuleUnitExecutor;

public class PMMLExecutor {
    private KieBase kieBase;
    private String loggingFileName;
    private boolean runWithLogging;

    public PMMLExecutor(KieBase kieBase) {
        this.kieBase = kieBase;
    }

    public PMMLExecutor(KieBase kieBase, String loggingFileName) {
        this.kieBase = kieBase;
        this.loggingFileName = loggingFileName;
    }

    public KieBase getKieBase() {
        return this.kieBase;
    }

    public String getLoggingFileName() {
        return this.loggingFileName;
    }

    public void setLoggingFileName(String loggingFileName) {
        this.loggingFileName = loggingFileName;
    }

    public boolean isRunWithLogging() {
        return this.runWithLogging;
    }

    public void setRunWithLogging(boolean runWithLogging) {
        this.runWithLogging = runWithLogging;
    }

    public PMML4Result run(PMMLRequestData requestData) {
        return this.run(requestData, Optional.empty());
    }

    public PMML4Result run(PMMLRequestData requestData, PMML4Data pmml4Data) {
        return this.run(requestData, Optional.of(pmml4Data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PMML4Result run(PMMLRequestData requestData, Optional<PMML4Data> data) {
        KieRuntimeLogger logger = null;
        RuleUnitExecutor ruleUnitExecutor = RuleUnitExecutor.create().bind(this.kieBase);
        if (this.runWithLogging) {
            logger = this.loggingFileName != null ? ((InternalRuleUnitExecutor)ruleUnitExecutor).addFileLogger(this.loggingFileName) : ((InternalRuleUnitExecutor)ruleUnitExecutor).addConsoleLogger();
        }
        DataSource requestDataSource = ruleUnitExecutor.newDataSource("request", (Object[])new PMMLRequestData[0]);
        DataSource resultDataSource = ruleUnitExecutor.newDataSource("results", (Object[])new PMML4Result[0]);
        DataSource pmmlDataSource = ruleUnitExecutor.newDataSource("pmmlData", (Object[])new PMML4Data[0]);
        requestDataSource.insert((Object)requestData);
        PMML4Result resultHandler = new PMML4Result();
        resultDataSource.insert((Object)resultHandler);
        if (data.isPresent()) {
            pmmlDataSource.insert((Object)data.get());
        }
        try {
            ruleUnitExecutor.run(this.startingRuleUnit("RuleUnitIndicator", requestData.getModelName(), "org.drools.scorecards.example"));
        }
        finally {
            if (logger != null) {
                logger.close();
            }
        }
        return resultHandler;
    }

    private List<String> calculatePossiblePackageNames(String modelId, String ... knownPackageNames) {
        ArrayList<String> packageNames = new ArrayList<String>();
        String javaModelId = modelId.replaceAll("\\s", "");
        if (knownPackageNames != null && knownPackageNames.length > 0) {
            for (String knownPkgName : knownPackageNames) {
                packageNames.add(knownPkgName + "." + javaModelId);
            }
        }
        String basePkgName = "org.kie.pmml.pmml_4_2." + javaModelId;
        packageNames.add(basePkgName);
        return packageNames;
    }

    protected Class<? extends RuleUnit> startingRuleUnit(String startingRule, String modelId, String ... knownPackageNames) {
        List<String> possiblePackages = this.calculatePossiblePackageNames(modelId, knownPackageNames);
        InternalKnowledgeBase internalKnowledgeBase = (InternalKnowledgeBase)this.kieBase;
        Map pkgs = internalKnowledgeBase.getPackagesMap();
        for (String pkgName : possiblePackages) {
            RuleUnitDescription descr;
            InternalKnowledgePackage pkg;
            RuleImpl ruleImpl;
            if (!pkgs.containsKey(pkgName) || (ruleImpl = (pkg = (InternalKnowledgePackage)pkgs.get(pkgName)).getRule(startingRule)) == null || (descr = (RuleUnitDescription)internalKnowledgeBase.getRuleUnitDescriptionRegistry().getDescription(ruleImpl).orElse(null)) == null) continue;
            return descr.getRuleUnitClass();
        }
        return null;
    }
}

