/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.InternalRuleUnitExecutor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.pmml.PMML4Data;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.DataSource;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.api.runtime.rule.RuleUnitExecutor;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;
import org.kie.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.kie.pmml.pmml_4_2.PMML4ExecutionHelper;
import org.kie.pmml.pmml_4_2.PMMLExecutor;
import org.kie.pmml.pmml_4_2.PMMLKieBaseUtil;
import org.kie.pmml.pmml_4_2.PMMLRequestDataBuilder;
import org.kie.pmml.pmml_4_2.model.tree.AbstractTreeToken;

public class DecisionTreeTest
extends DroolsAbstractPMMLTest {
    private static final String DECISION_TREES_FOLDER = "org/kie/pmml/pmml_4_2/";
    private static final boolean VERBOSE = false;
    private static final String source1 = "org/kie/pmml/pmml_4_2/test_tree_simple.pmml";
    private static final String source2 = "org/kie/pmml/pmml_4_2/test_tree_missing.pmml";
    private static final String source3 = "org/kie/pmml/pmml_4_2/test_tree_handwritten.pmml";
    private static final String source4 = "org/kie/pmml/pmml_4_2/test_tree_from_wtavg.pmml";
    private static final String packageName = "org.kie.pmml.pmml_4_2.test";
    private static final String TREE_RETURN_NULL_NOTRUECHILD_STRATEGY = "org/kie/pmml/pmml_4_2/test_tree_return_null_notruechild_strategy.pmml";
    private static final String TREE_RETURN_LAST_NOTRUE_CHILD_STRATEGY = "org/kie/pmml/pmml_4_2/test_tree_return_last_notruechild_strategy.pmml";
    private static final String TREE_DEFAULT_CHILD_MISSING_STRATEGY = "org/kie/pmml/pmml_4_2/test_tree_default_child_missing_value_strategy.pmml";
    private static final String TREE_LAST_CHILD_MISSING_STRATEGY = "org/kie/pmml/pmml_4_2/test_tree_last_missing_value_strategy.pmml";
    private static final String TREE_RETURN_NULL_MISSING_STRATEGY = "org/kie/pmml/pmml_4_2/test_tree_return_null_missing_value_strategy.pmml";
    private static final String TREE_WEIGHTED_CONFIDENCE_MISSING_STRATEGY = "org/kie/pmml/pmml_4_2/test_tree_weightedconfidence_missing_value_strategy.pmml";

    @After
    public void tearDown() {
    }

    @Test
    public void testTreeWithNumericValueOutcome() throws Exception {
        RuleUnitExecutor executor = this.createExecutor(source4);
        Assert.assertNotNull((Object)executor);
        PMMLRequestData request = new PMMLRequestData("1234", "Iris1");
        request.addRequestParam("petal_length", (Object)1.75);
        request.addRequestParam("sepal_width", (Object)2.1);
        PMML4Result resultHolder = new PMML4Result();
        List<String> possiblePackages = this.calculatePossiblePackageNames("Iris1", new String[0]);
        Class<? extends RuleUnit> unitClass = this.getStartingRuleUnit("RuleUnitIndicator", (InternalKnowledgeBase)this.kbase, possiblePackages);
        Assert.assertNotNull(unitClass);
        int x = executor.run(unitClass);
        Assert.assertTrue((x > 0 ? 1 : 0) != 0);
        this.data.insert((Object)request);
        this.resultData.insert((Object)resultHolder);
        executor.run(unitClass);
        Assert.assertEquals((Object)"OK", (Object)resultHolder.getResultCode());
        Number sepal_length = resultHolder.getResultValue("Sepal_length", "value", Double.class, new Object[0]).orElse(null);
        Assert.assertNotNull((Object)sepal_length);
        Assert.assertEquals((double)5.00566, (double)sepal_length.doubleValue(), (double)1.0E-6);
    }

    @Test
    public void testTreeFromMiningModel() throws Exception {
        RuleUnitExecutor executor = this.createExecutor("org/kie/pmml/pmml_4_2/test_tree_from_mm.pmml");
        PMMLRequestData request = new PMMLRequestData("1234", "SampleMineTree1");
        request.addRequestParam("fld1", (Object)30.0);
        request.addRequestParam("fld2", (Object)60.0);
        request.addRequestParam("fld3", (Object)"false");
        request.addRequestParam("fld4", (Object)"optA");
        PMML4Result resultHolder = new PMML4Result();
        List<String> possiblePackages = this.calculatePossiblePackageNames("SampleMineTree1", new String[0]);
        Class<? extends RuleUnit> unitClass = this.getStartingRuleUnit("RuleUnitIndicator", (InternalKnowledgeBase)this.kbase, possiblePackages);
        Assert.assertNotNull(unitClass);
        int x = executor.run(unitClass);
        Assert.assertTrue((x > 0 ? 1 : 0) != 0);
        this.data.insert((Object)request);
        this.resultData.insert((Object)resultHolder);
        executor.run(unitClass);
        Assert.assertEquals((Object)"OK", (Object)resultHolder.getResultCode());
        Assert.assertNotNull((Object)resultHolder.getResultVariables());
        Assert.assertNotNull((Object)resultHolder.getResultValue("Fld5", null, new Object[0]));
        String value = resultHolder.getResultValue("Fld5", "value", String.class, new Object[0]).orElse(null);
        Assert.assertEquals((Object)"tgtY", (Object)value);
        System.out.println(resultHolder);
    }

    @Test
    public void testSimpleTree() throws Exception {
        RuleUnitExecutor executor = this.createExecutor(source1);
        PMMLRequestData request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)30.0);
        request.addRequestParam("fld2", (Object)60.0);
        request.addRequestParam("fld3", (Object)"false");
        request.addRequestParam("fld4", (Object)"optA");
        PMML4Result resultHolder = new PMML4Result();
        List<String> possiblePackages = this.calculatePossiblePackageNames("TreeTest", new String[0]);
        Class<? extends RuleUnit> unitClass = this.getStartingRuleUnit("RuleUnitIndicator", (InternalKnowledgeBase)this.kbase, possiblePackages);
        Assert.assertNotNull(unitClass);
        int x = executor.run(unitClass);
        this.data.insert((Object)request);
        this.resultData.insert((Object)resultHolder);
        executor.run(unitClass);
        Assert.assertEquals((Object)"OK", (Object)resultHolder.getResultCode());
        Object obj = resultHolder.getResultValue("Fld5", null, new Object[0]);
        Assert.assertNotNull((Object)obj);
        String targetValue = resultHolder.getResultValue("Fld5", "value", String.class, new Object[0]).orElse(null);
        Assert.assertEquals((Object)"tgtY", (Object)targetValue);
    }

    @Test
    public void testReturnNullNoTrueChildPredictionStrategy() {
        KieBase kieBase = PMMLKieBaseUtil.createKieBaseWithPMML(TREE_RETURN_NULL_NOTRUECHILD_STRATEGY);
        PMMLExecutor executor = new PMMLExecutor(kieBase);
        PMMLRequestData request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)30.0);
        PMML4Result resultHolder = executor.run(request);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        String targetValue = resultHolder.getResultValue("Fld2", "value", String.class, new Object[0]).orElse(null);
        Assertions.assertThat((String)targetValue).isEqualTo((Object)"tgtY");
        request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)50.0);
        resultHolder = executor.run(request);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        Assertions.assertThat((Optional)resultHolder.getResultValue("Fld2", "value", String.class, new Object[0])).isEmpty();
    }

    @Test
    public void testReturnLastNoTrueChildPredictionStrategy() {
        KieBase kieBase = PMMLKieBaseUtil.createKieBaseWithPMML(TREE_RETURN_LAST_NOTRUE_CHILD_STRATEGY);
        PMMLExecutor executor = new PMMLExecutor(kieBase);
        PMMLRequestData request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)30.0);
        PMML4Result resultHolder = executor.run(request);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        String targetValue = resultHolder.getResultValue("Fld2", "value", String.class, new Object[0]).orElse(null);
        Assertions.assertThat((String)targetValue).isEqualTo((Object)"tgtY");
        request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)50.0);
        resultHolder = executor.run(request);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        targetValue = resultHolder.getResultValue("Fld2", "value", String.class, new Object[0]).orElse(null);
        Assertions.assertThat((String)targetValue).isEqualTo((Object)"tgtX");
    }

    @Test
    public void testLastPredictionMissingValueStrategy() {
        KieBase kieBase = PMMLKieBaseUtil.createKieBaseWithPMML(TREE_LAST_CHILD_MISSING_STRATEGY);
        PMMLExecutor executor = new PMMLExecutor(kieBase);
        PMMLRequestData request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)30.0);
        PMML4Result resultHolder = executor.run(request);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        String targetValue = resultHolder.getResultValue("Fld3", "value", String.class, new Object[0]).orElse(null);
        Assertions.assertThat((String)targetValue).isEqualTo((Object)"tgtY");
        executor.setRunWithLogging(true);
        request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)100.0);
        resultHolder = executor.run(request);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        targetValue = resultHolder.getResultValue("Fld3", "value", String.class, new Object[0]).orElse(null);
        Assertions.assertThat((String)targetValue).isEqualTo((Object)"tgtA");
    }

    @Test
    public void testNullPredictionMissingValueStrategy() {
        KieBase kieBase = PMMLKieBaseUtil.createKieBaseWithPMML(TREE_RETURN_NULL_MISSING_STRATEGY);
        PMMLExecutor executor = new PMMLExecutor(kieBase);
        PMMLRequestData request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)30.0);
        PMML4Result resultHolder = executor.run(request);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        String targetValue = resultHolder.getResultValue("Fld3", "value", String.class, new Object[0]).orElse(null);
        Assertions.assertThat((String)targetValue).isEqualTo((Object)"tgtY");
        request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)100.0);
        resultHolder = executor.run(request);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        targetValue = resultHolder.getResultValue("Fld3", "value", String.class, new Object[0]).orElse(null);
        Assertions.assertThat((String)targetValue).isNull();
    }

    @Test
    public void testDefaultChildMissingValueStrategy() {
        KieBase kieBase = PMMLKieBaseUtil.createKieBaseWithPMML(TREE_DEFAULT_CHILD_MISSING_STRATEGY);
        PMMLExecutor executor = new PMMLExecutor(kieBase);
        PMMLRequestData request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)30.0);
        PMML4Result resultHolder = executor.run(request);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        Assertions.assertThat((String)((String)resultHolder.getResultValue("Fld3", "value", String.class, new Object[0]).get())).isEqualTo((Object)"tgtY");
        request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)100.0);
        resultHolder = executor.run(request);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        Assertions.assertThat((String)((String)resultHolder.getResultValue("Fld3", "value", String.class, new Object[0]).get())).isEqualTo((Object)"tgtZ");
    }

    @Test
    public void testWeightedConfidenceMissingValueStrategy() {
        KieBase kieBase = PMMLKieBaseUtil.createKieBaseWithPMML(TREE_WEIGHTED_CONFIDENCE_MISSING_STRATEGY);
        PMMLExecutor executor = new PMMLExecutor(kieBase);
        PMMLRequestData request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)30.0);
        PMML4Result resultHolder = executor.run(request);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        Assertions.assertThat((String)((String)resultHolder.getResultValue("Fld3", "value", String.class, new Object[0]).get())).isEqualTo((Object)"tgtY");
        request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("fld1", (Object)50.0);
        resultHolder = executor.run(request);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        Assertions.assertThat((String)((String)resultHolder.getResultValue("Fld3", "value", String.class, new Object[0]).get())).isEqualTo((Object)"tgtX");
    }

    protected Object getToken(KieSession kSession, String treeModelName) {
        final String className = "org.kie.pmml.pmml_4_2.model." + treeModelName + "TreeToken";
        Collection objects = kSession.getObjects(new ObjectFilter(){

            public boolean accept(Object object) {
                return object.getClass().getName().equals(className);
            }
        });
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)1L, (long)objects.size());
        Iterator iter = objects.iterator();
        assert (iter.hasNext());
        return iter.next();
    }

    @Test
    public void testMissingTree() throws Exception {
        Resource res = ResourceFactory.newClassPathResource((String)source2);
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"Missing", (Resource)res, null);
        Assert.assertNotNull((Object)helper);
        PMMLRequestData requestData = new PMMLRequestData("123", "Missing");
        requestData.addRequestParam(new ParameterInfo("123", "fld1", Double.class, (Object)45.0));
        requestData.addRequestParam(new ParameterInfo("123", "fld2", Double.class, (Object)60.0));
        requestData.addRequestParam(new ParameterInfo("123", "fld3", String.class, (Object)"optA"));
        PMML4Result resultHolder = helper.submitRequest(requestData);
        Assert.assertNotNull((Object)resultHolder);
        AbstractTreeToken missingTreeToken = resultHolder.getResultValue("MissingTreeToken", null, AbstractTreeToken.class, new Object[0]).orElse(null);
        Assert.assertNotNull((Object)missingTreeToken);
        Double tokVal = resultHolder.getResultValue("MissingTreeToken", "confidence", Double.class, new Object[0]).orElse(null);
        Assert.assertNotNull((Object)tokVal);
        Assert.assertEquals((double)0.6, (double)tokVal, (double)0.0);
        String current = resultHolder.getResultValue("MissingTreeToken", "current", String.class, new Object[0]).orElse(null);
        Assert.assertNotNull((Object)current);
        Assert.assertEquals((Object)"null", (Object)current);
        Object fld9 = resultHolder.getResultValue("Fld9", null, new Object[0]);
        Assert.assertNotNull((Object)fld9);
        String fld9Val = resultHolder.getResultValue("Fld9", "value", String.class, new Object[0]).orElse(null);
        Assert.assertNotNull((Object)fld9Val);
        Assert.assertEquals((Object)"tgtZ", (Object)fld9Val);
        requestData = new PMMLRequestDataBuilder("2345", "Missing").addParameter("fld2", (Object)60.0, Double.class).addParameter("fld3", (Object)"optA", String.class).build();
        resultHolder = helper.submitRequest(requestData);
        Assert.assertNotNull((Object)resultHolder);
        Assert.assertEquals((Object)"OK", (Object)resultHolder.getResultCode());
        Assert.assertNotNull((Object)resultHolder.getResultValue("Fld9", null, new Object[0]));
        fld9Val = resultHolder.getResultValue("Fld9", "value", String.class, new Object[0]).orElse(null);
        Assert.assertEquals((Object)"tgtX", (Object)fld9Val);
    }

    @Test
    public void testMissingTreeWeighted1() throws Exception {
        Resource res = ResourceFactory.newClassPathResource((String)source2);
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"Missing", (Resource)res, null);
        Assert.assertNotNull((Object)helper);
        PMMLRequestData requestData = new PMMLRequestData("123", "Missing");
        requestData.addRequestParam(new ParameterInfo("123", "fld1", Double.class, (Object)-1.0));
        requestData.addRequestParam(new ParameterInfo("123", "fld2", Double.class, (Object)-1.0));
        requestData.addRequestParam(new ParameterInfo("123", "fld3", String.class, (Object)"optA"));
        PMML4Result resultHolder = helper.submitRequest(requestData);
        AbstractTreeToken missingTreeToken = (AbstractTreeToken)resultHolder.getResultValue("MissingTreeToken", null, new Object[0]);
        Assert.assertNotNull((Object)missingTreeToken);
        Assert.assertEquals((double)0.8, (double)missingTreeToken.getConfidence(), (double)0.0);
        Assert.assertEquals((Object)"null", (Object)missingTreeToken.getCurrent());
        Assert.assertEquals((double)50.0, (double)missingTreeToken.getTotalCount(), (double)0.0);
        Object fld9 = resultHolder.getResultValue("Fld9", null, new Object[0]);
        Assert.assertNotNull((Object)fld9);
        String value = (String)resultHolder.getResultValue("Fld9", "value", new Object[0]);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"tgtX", (Object)value);
    }

    @Test
    public void testMissingTreeWeighted2() throws Exception {
        Resource res = ResourceFactory.newClassPathResource((String)source2);
        KieBase kbase = new KieHelper().addResource(res, ResourceType.PMML).build(new KieBaseOption[0]);
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        KieRuntimeLogger console = ((InternalRuleUnitExecutor)executor).addConsoleLogger();
        PMMLRequestData requestData = new PMMLRequestData("123", "Missing");
        requestData.addRequestParam(new ParameterInfo("123", "fld1", Double.class, (Object)-1.0));
        requestData.addRequestParam(new ParameterInfo("123", "fld2", Double.class, (Object)-1.0));
        requestData.addRequestParam(new ParameterInfo("123", "fld3", String.class, (Object)"miss"));
        PMML4Result resultHolder = new PMML4Result();
        DataSource data = executor.newDataSource("request", (Object[])new PMMLRequestData[0]);
        DataSource results = executor.newDataSource("results", (Object[])new PMML4Result[0]);
        DataSource pmmlData = executor.newDataSource("pmmlData", (Object[])new PMML4Data[0]);
        List<String> possiblePackages = this.calculatePossiblePackageNames("Missing", new String[0]);
        Class<? extends RuleUnit> unitClass = this.getStartingRuleUnit("RuleUnitIndicator", (InternalKnowledgeBase)kbase, possiblePackages);
        Assert.assertNotNull(unitClass);
        int x = executor.run(unitClass);
        data.insert((Object)requestData);
        results.insert((Object)resultHolder);
        executor.run(unitClass);
        console.close();
        System.out.println(resultHolder);
        Collection objects = ((InternalRuleUnitExecutor)executor).getSessionObjects();
        objects.forEach(o -> System.out.println(o));
        pmmlData.forEach(pd -> System.out.println(pd));
        AbstractTreeToken token = (AbstractTreeToken)resultHolder.getResultValue("MissingTreeToken", null, new Object[0]);
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((double)0.6, (double)token.getConfidence(), (double)1.0E-6);
        Assert.assertEquals((Object)"null", (Object)token.getCurrent());
        Assert.assertEquals((double)100.0, (double)token.getTotalCount(), (double)0.0);
        Object fld9 = resultHolder.getResultValue("Fld9", null, new Object[0]);
        Assert.assertNotNull((Object)fld9);
        String value = (String)resultHolder.getResultValue("Fld9", "value", new Object[0]);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"tgtX", (Object)value);
    }
}

