/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models;

import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Variable;
import org.kie.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.kie.pmml.pmml_4_2.PMML4Helper;

@Ignore
public class NeuralNetworkTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = true;
    private static final String source1 = "org/kie/pmml/pmml_4_2/test_ann_regression.xml";
    private static final String source2 = "org/kie/pmml/pmml_4_2/test_ann_iris.xml";
    private static final String source22 = "org/kie/pmml/pmml_4_2/test_ann_iris_v2.xml";
    private static final String source23 = "org/kie/pmml/pmml_4_2/test_ann_iris_prediction.xml";
    private static final String source4 = "org/kie/pmml/pmml_4_2/test_ann_mixed_inputs2.xml";
    private static final String source3 = "org/kie/pmml/pmml_4_2/test_miningSchema.xml";
    private static final String source3c = "org/kie/pmml/pmml_4_2/test_annCommas.xml";
    private static final String source6 = "org/kie/pmml/pmml_4_2/mock_ptsd.xml";
    private static final String source7 = "org/kie/pmml/pmml_4_2/mock_cold.xml";
    private static final String source8 = "org/kie/pmml/pmml_4_2/mock_breastcancer.xml";
    private static final String source9 = "org/kie/pmml/pmml_4_2/test_nn_clax_output.xml";
    private static final String packageName = "org.kie.pmml.pmml_4_2.test";
    private static final String smartVent = "org/kie/pmml/pmml_4_2/smartvent.xml";

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testANN() throws Exception {
        this.setKSession(this.getModelSession(source1, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().fireAllRules();
        Assert.assertEquals((long)33L, (long)this.getNumAssertedSynapses());
        this.getKSession().getEntryPoint("in_Gender").insert((Object)"male");
        this.getKSession().getEntryPoint("in_NoOfClaims").insert((Object)"3");
        this.getKSession().getEntryPoint("in_Scrambled").insert((Object)7);
        this.getKSession().getEntryPoint("in_Domicile").insert((Object)"urban");
        this.getKSession().getEntryPoint("in_AgeOfCar").insert((Object)8.0);
        this.getKSession().fireAllRules();
        Thread.sleep(200L);
        Assert.assertEquals((double)828.0, (double)Math.floor(this.queryDoubleField("OutAmOfClaims", "NeuralInsurance")), (double)0.0);
        this.checkGeneratedRules();
    }

    @Test
    public void testANNCompilation() throws Exception {
        this.setKSession(this.getModelSession(source3, true));
        this.setKbase(this.getKSession().getKieBase());
        this.checkGeneratedRules();
    }

    @Test
    public void testCold() throws Exception {
        this.setKSession(this.getModelSession(source7, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().fireAllRules();
        this.getKSession().getEntryPoint("in_Temp").insert((Object)28.0);
        this.getKSession().fireAllRules();
        Assert.assertEquals((double)0.44, (double)this.queryDoubleField("Cold", "MockCold"), (double)1.0E-6);
        this.checkGeneratedRules();
    }

    private String getQId(String model, String field) {
        String questId = (String)((QueryResultsRow)this.getKSession().getQueryResults("getItemId", new Object[]{model, Variable.v, Variable.v}).iterator().next()).get("$id");
        return (String)((QueryResultsRow)this.getKSession().getQueryResults("getItemId", new Object[]{model + "_" + field, questId, Variable.v}).iterator().next()).get("$id");
    }

    @Test
    public void testIris() throws Exception {
        this.setKSession(this.getModelSession(source2, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().fireAllRules();
        Assert.assertEquals((long)21L, (long)this.getNumAssertedSynapses());
        this.getKSession().getEntryPoint("in_PetalLen").insert((Object)2.2);
        this.getKSession().getEntryPoint("in_PetalWid").insert((Object)4.1);
        this.getKSession().getEntryPoint("in_SepalLen").insert((Object)2.3);
        this.getKSession().getEntryPoint("in_SepalWid").insert((Object)1.8);
        this.getKSession().fireAllRules();
        FactType t7 = this.getKbase().getFactType(packageName, "Test_MLP_7");
        FactType t8 = this.getKbase().getFactType(packageName, "Test_MLP_8");
        FactType t9 = this.getKbase().getFactType(packageName, "Test_MLP_9");
        FactType s1 = this.getKbase().getFactType(packageName, "Cspecies_virginica");
        Assert.assertEquals((double)0.001, (double)this.truncN(this.getDoubleFieldValue(t7), 3), (double)1.0E-4);
        Assert.assertEquals((double)0.282, (double)this.truncN(this.getDoubleFieldValue(t8), 3), (double)1.0E-4);
        Assert.assertEquals((double)0.716, (double)this.truncN(this.getDoubleFieldValue(t9), 3), (double)1.0E-4);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "SpecSetosa"), true, false, "Test_MLP", 0.001111);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "SpecVirgin"), true, false, "Test_MLP", 0.716639);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "SpecVersic"), true, false, "Test_MLP", 0.282249);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "SpecOut"), true, false, "Test_MLP", "virginica");
        this.checkGeneratedRules();
    }

    @Test
    public void testIris2() throws Exception {
        this.setKSession(this.getModelSession(source22, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().fireAllRules();
        Assert.assertEquals((long)12L, (long)this.getNumAssertedSynapses());
        this.getKSession().getEntryPoint("in_PetalLen").insert((Object)101);
        this.getKSession().getEntryPoint("in_PetalWid").insert((Object)1);
        this.getKSession().getEntryPoint("in_SepalLen").insert((Object)151);
        this.getKSession().getEntryPoint("in_SepalWid").insert((Object)30);
        this.getKSession().fireAllRules();
        FactType t4 = this.getKbase().getFactType(packageName, "Test_MLP_0");
        FactType t5 = this.getKbase().getFactType(packageName, "Test_MLP_1");
        FactType t6 = this.getKbase().getFactType(packageName, "Test_MLP_2");
        Assert.assertEquals((double)1.542, (double)this.truncN(this.getDoubleFieldValue(t4), 3), (double)0.0);
        Assert.assertEquals((double)0.0, (double)this.truncN(this.getDoubleFieldValue(t5), 3), (double)0.0);
        Assert.assertEquals((double)3.0, (double)this.truncN(this.getDoubleFieldValue(t6), 3), (double)0.0);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "OutSpecies"), true, false, "Test_MLP", "versicolor");
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "OutProb"), true, false, "Test_MLP", 0.999999);
        this.checkGeneratedRules();
    }

    @Test
    public void testIris3() throws Exception {
        this.setKSession(this.getModelSession(source23, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().fireAllRules();
        Assert.assertEquals((long)6L, (long)this.getNumAssertedSynapses());
        this.getKSession().getEntryPoint("in_PetalNum").insert((Object)101);
        this.getKSession().getEntryPoint("in_PetalWid").insert((Object)2);
        this.getKSession().getEntryPoint("in_Species").insert((Object)"virginica");
        this.getKSession().getEntryPoint("in_SepalWid").insert((Object)30);
        this.getKSession().fireAllRules();
        Assert.assertEquals((double)24.0, (double)this.queryIntegerField("OutSepLen", "Neuiris"), (double)0.0);
        this.checkGeneratedRules();
    }

    @Test
    public void testSimpleANN() throws Exception {
        this.setKSession(this.getModelSession(source3, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().getEntryPoint("in_Feat2").insert((Object)4);
        this.getKSession().getEntryPoint("in_Feat1").insert((Object)3.5);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "MockOutput2"), true, false, "Test_MLP", 1.0);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "MockOutput1"), true, false, "Test_MLP", 0.0);
        this.checkGeneratedRules();
    }

    @Test
    public void testSimpleANNWithCommasInIds() throws Exception {
        this.setKSession(this.getModelSession(source3c, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().getEntryPoint("in_Feat2").insert((Object)4);
        this.getKSession().getEntryPoint("in_Feat1").insert((Object)3.5);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "MockOutput2"), true, false, "Test_MLP", 1.0);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "MockOutput1"), true, false, "Test_MLP", 0.0);
        this.checkGeneratedRules();
    }

    @Test
    public void testHeart() throws Exception {
        this.setKSession(this.getModelSession(source4, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().fireAllRules();
        Assert.assertEquals((long)81L, (long)this.getNumAssertedSynapses());
        this.getKSession().getEntryPoint("in_Feat1").insert((Object)83.0);
        this.getKSession().getEntryPoint("in_Feat2").insert((Object)1.0);
        this.getKSession().getEntryPoint("in_Feat3").insert((Object)5.0);
        this.getKSession().getEntryPoint("in_Feat4").insert((Object)"asympt");
        this.getKSession().getEntryPoint("in_Feat5").insert((Object)"yes");
        this.getKSession().getEntryPoint("in_Feat6").insert((Object)"t");
        this.getKSession().getEntryPoint("in_Feat7").insert((Object)1.0);
        this.getKSession().getEntryPoint("in_Feat8").insert((Object)"normal");
        this.getKSession().getEntryPoint("in_Feat9").insert((Object)"male");
        this.getKSession().getEntryPoint("in_Feat10").insert((Object)"flat");
        this.getKSession().getEntryPoint("in_Feat11").insert((Object)"normal");
        this.getKSession().getEntryPoint("in_Feat12").insert((Object)3.3);
        this.getKSession().getEntryPoint("in_Feat13").insert((Object)2.5);
        this.getKSession().fireAllRules();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "OutN"), true, false, "HEART_MLP", ">50_1");
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "OutP"), true, false, "HEART_MLP", 0.943336);
        this.checkGeneratedRules();
    }

    @Test
    public void testOverride() throws Exception {
        this.setKSession(this.getModelSession(source3, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().fireAllRules();
        this.getKSession().getEntryPoint("in_Feat1").insert((Object)2.2);
        this.getKSession().fireAllRules();
        this.getKSession().getEntryPoint("in_Feat2").insert((Object)5);
        this.getKSession().fireAllRules();
        FactType out1 = this.getKbase().getFactType(packageName, "Out1");
        FactType out2 = this.getKbase().getFactType(packageName, "Out2");
        FactType nump = this.getKbase().getFactType(packageName, "Feat2");
        Assert.assertEquals((long)1L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(out1.getFactClass())).size());
        Assert.assertEquals((long)1L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(out2.getFactClass())).size());
        Assert.assertEquals((long)2L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(nump.getFactClass())).size());
        this.getKSession().getEntryPoint("in_Feat1").insert((Object)2.5);
        this.getKSession().getEntryPoint("in_Feat2").insert((Object)6);
        this.getKSession().fireAllRules();
        Assert.assertEquals((long)1L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(out1.getFactClass())).size());
        Assert.assertEquals((long)1L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(out2.getFactClass())).size());
        Assert.assertEquals((long)2L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(nump.getFactClass())).size());
        this.checkGeneratedRules();
    }

    @Test
    public void testSmartVent() throws Exception {
        this.setKSession(this.getModelSession(smartVent, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().fireAllRules();
        this.getKSession().getEntryPoint("in_PIP").insert((Object)28.0);
        this.getKSession().getEntryPoint("in_PEEP").insert((Object)5.0);
        this.getKSession().getEntryPoint("in_RATE").insert((Object)30.0);
        this.getKSession().getEntryPoint("in_IT").insert((Object)0.4);
        this.getKSession().getEntryPoint("in_Ph").insert((Object)7.281);
        this.getKSession().getEntryPoint("in_CO2").insert((Object)39.3);
        this.getKSession().getEntryPoint("in_PaO2").insert((Object)126.0);
        this.getKSession().getEntryPoint("in_FIO2").insert((Object)100.0);
        this.getKSession().fireAllRules();
        Assert.assertEquals((double)24.0, (double)this.queryDoubleField("Out_sPIP", "SmartVent"), (double)0.5);
        Assert.assertEquals((double)5.0, (double)this.queryDoubleField("Out_sPEEP", "SmartVent"), (double)0.1);
        Assert.assertEquals((double)30.0, (double)this.queryDoubleField("Out_sRATE", "SmartVent"), (double)0.5);
        Assert.assertEquals((double)0.4, (double)this.queryDoubleField("Out_sIT", "SmartVent"), (double)0.05);
        Assert.assertEquals((double)-1.0, (double)this.queryDoubleField("Out_sFIO2", "SmartVent"), (double)0.05);
        this.getKSession().getEntryPoint("in_RATE").insert((Object)20.0);
        this.getKSession().getEntryPoint("in_PaO2").insert((Object)75.0);
        this.getKSession().getEntryPoint("in_Ph").insert((Object)7.31);
        this.getKSession().getEntryPoint("in_CO2").insert((Object)37.0);
        this.getKSession().getEntryPoint("in_IT").insert((Object)0.4);
        this.getKSession().getEntryPoint("in_PIP").insert((Object)20.0);
        this.getKSession().getEntryPoint("in_PEEP").insert((Object)4.0);
        this.getKSession().getEntryPoint("in_FIO2").insert((Object)38.0);
        this.getKSession().fireAllRules();
        Assert.assertEquals((double)18.0, (double)this.queryDoubleField("Out_sPIP", "SmartVent"), (double)0.5);
        Assert.assertEquals((double)4.12, (double)this.queryDoubleField("Out_sPEEP", "SmartVent"), (double)0.1);
        Assert.assertEquals((double)19.0, (double)this.queryDoubleField("Out_sRATE", "SmartVent"), (double)0.5);
        Assert.assertEquals((double)0.4, (double)this.queryDoubleField("Out_sIT", "SmartVent"), (double)0.05);
        Assert.assertEquals((double)-1.0, (double)this.queryDoubleField("Out_sFIO2", "SmartVent"), (double)0.05);
        this.checkGeneratedRules();
    }

    @Test
    public void testClaxOutput() throws Exception {
        this.setKSession(this.getModelSession(source9, true));
        this.setKbase(this.getKSession().getKieBase());
        this.getKSession().fireAllRules();
        this.getKSession().getEntryPoint("in_Temp").insert((Object)28.0);
        this.getKSession().fireAllRules();
        Thread.sleep(200L);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "ColdCat"), true, false, "MockCold", "SURE");
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "ColdYES"), true, false, "MockCold", 0.6475435612444598);
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(packageName, "ColdNO"), true, false, "MockCold", 0.0036540476859388943);
        this.checkGeneratedRules();
    }

    private int getNumAssertedSynapses() {
        Class synClass = this.getKSession().getKieBase().getFactType(PMML4Helper.pmmlDefaultPackageName(), "Synapse").getFactClass();
        return this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(synClass)).size();
    }

    private double truncN(double x, int numDecimal) {
        return Math.floor(x * Math.pow(10.0, numDecimal)) * Math.pow(10.0, -numDecimal);
    }
}

