/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.InternalKnowledgeBase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.pmml.PMML4Data;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.runtime.rule.DataSource;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.api.runtime.rule.RuleUnitExecutor;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;
import org.kie.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.kie.pmml.pmml_4_2.PMML4ExecutionHelper;
import org.kie.pmml.pmml_4_2.PMMLRequestDataBuilder;

public class ScorecardTest
extends DroolsAbstractPMMLTest {
    private static final String SCORECARDS_FOLDER = "org/kie/pmml/pmml_4_2/";
    private static final String source1 = "org/kie/pmml/pmml_4_2/test_scorecard.pmml";
    private static final String source2 = "org/kie/pmml/pmml_4_2/test_scorecardOut.pmml";
    private static final String SOURCE_SIMPLE_SCORECARD = "org/kie/pmml/pmml_4_2/test_scorecard_simple.pmml";
    private static final String SOURCE_COMPOUND_PREDICATE_SCORECARD = "org/kie/pmml/pmml_4_2/test_scorecard_compound_predicate.pmml";
    private static final String SOURCE_SIMPLE_SET_SCORECARD = "org/kie/pmml/pmml_4_2/test_scorecard_simple_set_predicate.pmml";
    private static final String SOURCE_SIMPLE_SET_SPACE_VALUE_SCORECARD = "org/kie/pmml/pmml_4_2/test_scorecard_simple_set_predicate_with_space_value.pmml";
    private static final String SOURCE_COMPLEX_PARTIAL_SCORE_SCORECARD = "org/kie/pmml/pmml_4_2/test_scorecard_complex_partial_score.pmml";

    @Test
    public void testMultipleInputData() throws Exception {
        RuleUnitExecutor[] executor = new RuleUnitExecutor[3];
        PMMLRequestData[] requestData = new PMMLRequestData[3];
        PMML4Result[] resultHolder = new PMML4Result[3];
        Resource res = ResourceFactory.newClassPathResource((String)source1);
        this.kbase = new KieHelper().addResource(res, ResourceType.PMML).build(new KieBaseOption[0]);
        executor[0] = RuleUnitExecutor.create().bind(this.kbase);
        executor[1] = RuleUnitExecutor.create().bind(this.kbase);
        executor[2] = RuleUnitExecutor.create().bind(this.kbase);
        DataSource[] requests = new DataSource[3];
        DataSource[] results = new DataSource[3];
        DataSource[] pmmlDatas = new DataSource[3];
        Double[] expectedScores = new Double[]{41.345, 26.345, 39.345};
        LinkedHashMap[] expectedResults = new LinkedHashMap[3];
        expectedResults[0] = new LinkedHashMap();
        expectedResults[0].put("LX00", -1.0);
        expectedResults[0].put("RES", -10.0);
        expectedResults[0].put("CX2", -30.0);
        expectedResults[1] = new LinkedHashMap();
        expectedResults[1].put("RES", 10.0);
        expectedResults[1].put("LX00", -1.0);
        expectedResults[1].put("OCC", -10.0);
        expectedResults[1].put("ABZ", -25.0);
        expectedResults[2] = new LinkedHashMap();
        expectedResults[2].put("LX00", 1.0);
        expectedResults[2].put("OCC", -5.0);
        expectedResults[2].put("RES", -5.0);
        expectedResults[2].put("CX1", -30.0);
        requestData[0] = this.createRequest("123", "Sample Score", 33.0, "SKYDIVER", "KN", true);
        requestData[1] = this.createRequest("124", "Sample Score", 50.0, "TEACHER", "AP", true);
        requestData[2] = this.createRequest("125", "Sample Score", 10.0, "STUDENT", "TN", false);
        for (int x = 0; x < 3; ++x) {
            requests[x] = executor[x].newDataSource("request", (Object[])new PMMLRequestData[0]);
            results[x] = executor[x].newDataSource("results", (Object[])new PMML4Result[0]);
            pmmlDatas[x] = executor[x].newDataSource("pmmlData", (Object[])new PMML4Data[0]);
            resultHolder[x] = new PMML4Result(requestData[x].getCorrelationId());
        }
        List<String> possiblePackages = this.calculatePossiblePackageNames("Sample Score", "org.drools.scorecards.example");
        Class<? extends RuleUnit> unitClass = this.getStartingRuleUnit("RuleUnitIndicator", (InternalKnowledgeBase)this.kbase, possiblePackages);
        Assert.assertNotNull(unitClass);
        for (int x = 0; x < 3; ++x) {
            executor[x].run(unitClass);
        }
        for (int y = 0; y < 3; ++y) {
            requests[y].insert((Object)requestData[y]);
            results[y].insert((Object)resultHolder[y]);
        }
        for (int z = 0; z < 3; ++z) {
            executor[z].run(unitClass);
        }
        for (int p = 0; p < 3; ++p) {
            this.checkResult(resultHolder[p], expectedScores[p], expectedResults[p]);
        }
    }

    private void checkResult(PMML4Result result, Double score, LinkedHashMap<String, Double> expectedResults) {
        Assert.assertEquals((Object)"OK", (Object)result.getResultCode());
        Assert.assertTrue((boolean)result.getResultVariables().containsKey("ScoreCard"));
        Assert.assertNotNull((Object)result.getResultValue("ScoreCard", null, new Object[0]));
        Double scoreFromCard = result.getResultValue("ScoreCard", "score", Double.class, new Object[0]).orElse(null);
        Assert.assertEquals((double)score, (double)scoreFromCard, (double)0.001);
        Object ranks = result.getResultValue("ScoreCard", "ranking", new Object[0]);
        Assert.assertNotNull((Object)ranks);
        Assert.assertTrue((boolean)(ranks instanceof LinkedHashMap));
        LinkedHashMap rankingMap = (LinkedHashMap)ranks;
        Iterator<String> expectedKeys = expectedResults.keySet().iterator();
        Iterator actualKeys = rankingMap.keySet().iterator();
        Assert.assertEquals((long)expectedResults.keySet().size(), (long)rankingMap.keySet().size());
        while (expectedKeys.hasNext()) {
            String expectedKey = expectedKeys.next();
            String actualKey = (String)actualKeys.next();
            Double expectedValue = expectedResults.get(expectedKey);
            Double actualValue = (Double)rankingMap.get(actualKey);
            Assert.assertEquals((Object)expectedKey, (Object)actualKey);
            Assert.assertEquals((double)expectedValue, (double)actualValue, (double)0.001);
        }
    }

    @Test
    public void testScorecard() throws Exception {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"Sample Score", (Resource)ResourceFactory.newClassPathResource((String)source1), null);
        PMMLRequestData request = new PMMLRequestDataBuilder("123", "Sample Score").addParameter("age", (Object)33.0, Double.class).addParameter("occupation", (Object)"SKYDIVER", String.class).addParameter("residenceState", (Object)"KN", String.class).addParameter("validLicense", (Object)true, Boolean.class).build();
        helper.addPossiblePackageName("org.drools.scorecards.example");
        PMML4Result resultHolder = helper.submitRequest(request);
        Assert.assertEquals((long)3L, (long)resultHolder.getResultVariables().size());
        Object scorecard = resultHolder.getResultValue("ScoreCard", null, new Object[0]);
        Assert.assertNotNull((Object)scorecard);
        Double score = resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).orElse(null);
        Assert.assertEquals((double)41.345, (double)score, (double)0.0);
        Object ranking = resultHolder.getResultValue("ScoreCard", "ranking", new Object[0]);
        Assert.assertNotNull((Object)ranking);
        Assert.assertTrue((boolean)(ranking instanceof LinkedHashMap));
        LinkedHashMap map = (LinkedHashMap)ranking;
        Assert.assertTrue((boolean)map.containsKey("LX00"));
        Assert.assertTrue((boolean)map.containsKey("RES"));
        Assert.assertTrue((boolean)map.containsKey("CX2"));
        Assert.assertEquals((Object)-1.0, map.get("LX00"));
        Assert.assertEquals((Object)-10.0, map.get("RES"));
        Assert.assertEquals((Object)-30.0, map.get("CX2"));
        Iterator iter = map.keySet().iterator();
        Assert.assertEquals((Object)"LX00", iter.next());
        Assert.assertEquals((Object)"RES", iter.next());
        Assert.assertEquals((Object)"CX2", iter.next());
    }

    @Test
    public void testSimpleScorecard() {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SimpleScorecard", (Resource)ResourceFactory.newClassPathResource((String)SOURCE_SIMPLE_SCORECARD), null);
        PMMLRequestDataBuilder rdb = new PMMLRequestDataBuilder("123", helper.getModelName()).addParameter("param1", (Object)10.0, Double.class).addParameter("param2", (Object)15.0, Double.class);
        PMML4Result resultHolder = helper.submitRequest(rdb.build());
        double score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(40.8);
        Map rankingMap = (Map)resultHolder.getResultValue("ScoreCard", "ranking", new Object[0]);
        Assertions.assertThat((Double)((Double)rankingMap.get("reasonCh1"))).isEqualTo(5.0);
        Assertions.assertThat((Double)((Double)rankingMap.get("reasonCh2"))).isEqualTo(-6.0);
        PMMLRequestDataBuilder rdb2 = new PMMLRequestDataBuilder("123", "SimpleScorecard").addParameter("param1", (Object)51.0, Double.class).addParameter("param2", (Object)12.0, Double.class);
        resultHolder = helper.submitRequest(rdb2.build());
        score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(120.8);
        rankingMap = (Map)resultHolder.getResultValue("ScoreCard", "ranking", new Object[0]);
        Assertions.assertThat((Double)((Double)rankingMap.get("reasonCh1"))).isEqualTo(-75.0);
        Assertions.assertThat((Double)((Double)rankingMap.get("reasonCh2"))).isEqualTo(-6.0);
    }

    @Test
    public void testScorecardWithCompoundPredicate() {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"ScorecardCompoundPredicate", (Resource)ResourceFactory.newClassPathResource((String)SOURCE_COMPOUND_PREDICATE_SCORECARD), null);
        PMMLRequestData requestData = new PMMLRequestDataBuilder("123", helper.getModelName()).addParameter("param1", (Object)41.0, Double.class).addParameter("param2", (Object)21.0, Double.class).build();
        PMML4Result resultHolder = helper.submitRequest(requestData);
        double score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(120.8);
        Map rankingMap = (Map)resultHolder.getResultValue("ScoreCard", "ranking", new Object[0]);
        Assertions.assertThat((Double)((Double)rankingMap.get("reasonCh1"))).isEqualTo(50.0);
        Assertions.assertThat((Double)((Double)rankingMap.get("reasonCh2"))).isEqualTo(5.0);
        requestData = new PMMLRequestData("123", "ScorecardCompoundPredicate");
        requestData.addRequestParam("param1", (Object)40.0);
        requestData.addRequestParam("param2", (Object)25.0);
        resultHolder = helper.submitRequest(requestData);
        score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(120.8);
        requestData = new PMMLRequestData("123", "ScorecardCompoundPredicate");
        requestData.addRequestParam("param1", (Object)40.0);
        requestData.addRequestParam("param2", (Object)55.0);
        resultHolder = helper.submitRequest(requestData);
        score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(210.8);
        requestData = new PMMLRequestData("123", "ScorecardCompoundPredicate");
        requestData.addRequestParam("param1", (Object)4.0);
        requestData.addRequestParam("param2", (Object)-25.0);
        resultHolder = helper.submitRequest(requestData);
        score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(30.8);
    }

    @Test
    public void testScorecardWithSimpleSetPredicate() {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SimpleSetScorecard", (Resource)ResourceFactory.newClassPathResource((String)SOURCE_SIMPLE_SET_SCORECARD), null);
        PMMLRequestData requestData = new PMMLRequestDataBuilder("123", helper.getModelName()).addParameter("param1", (Object)4, Integer.class).addParameter("param2", (Object)"optA", String.class).build();
        PMML4Result resultHolder = helper.submitRequest(requestData);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        double score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(113.0);
        requestData = new PMMLRequestData("123", "SimpleSetScorecard");
        requestData.addRequestParam("param1", (Object)5);
        requestData.addRequestParam("param2", (Object)"optA");
        resultHolder = helper.submitRequest(requestData);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(33.0);
        requestData = new PMMLRequestData("123", "SimpleSetScorecard");
        requestData.addRequestParam("param1", (Object)-5);
        requestData.addRequestParam("param2", (Object)"optC");
        resultHolder = helper.submitRequest(requestData);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(123.0);
        requestData = new PMMLRequestData("123", "SimpleSetScorecard");
        requestData.addRequestParam("param1", (Object)-5);
        requestData.addRequestParam("param2", (Object)"optA");
        resultHolder = helper.submitRequest(requestData);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(113.0);
    }

    @Test
    public void testScorecardWithSimpleSetPredicateWithSpaceValue() {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SimpleSetScorecardWithSpaceValue", (Resource)ResourceFactory.newClassPathResource((String)SOURCE_SIMPLE_SET_SPACE_VALUE_SCORECARD), null);
        PMMLRequestData requestData = new PMMLRequestDataBuilder("123", helper.getModelName()).addParameter("param", (Object)"optA", String.class).build();
        PMML4Result resultHolder = helper.submitRequest(requestData);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        double score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(13.0);
    }

    @Test
    public void testScorecardWithComplexPartialScore() {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"ComplexPartialScoreScorecard", (Resource)ResourceFactory.newClassPathResource((String)SOURCE_COMPLEX_PARTIAL_SCORE_SCORECARD), null);
        PMMLRequestData requestData = new PMMLRequestDataBuilder("123", helper.getModelName()).addParameter("param", (Object)5.0, Double.class).build();
        PMML4Result resultHolder = helper.submitRequest(requestData);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        double score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(20.0);
        requestData = new PMMLRequestData("123", "ComplexPartialScoreScorecard");
        requestData.addRequestParam("param", (Object)40.0);
        resultHolder = helper.submitRequest(requestData);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(150.0);
        requestData = new PMMLRequestData("123", "ComplexPartialScoreScorecard");
        requestData.addRequestParam("param", (Object)100.0);
        resultHolder = helper.submitRequest(requestData);
        Assertions.assertThat((Object)resultHolder).isNotNull();
        score = (Double)resultHolder.getResultValue("ScoreCard", "score", Double.class, new Object[0]).get();
        Assertions.assertThat((double)score).isEqualTo(205.0);
    }

    @Test
    public void testScorecardOutputs() throws Exception {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SampleScorecard", (Resource)ResourceFactory.newClassPathResource((String)source2), null);
        PMMLRequestData requestData = new PMMLRequestDataBuilder("123", helper.getModelName()).addParameter("cage", (Object)"engineering", String.class).addParameter("age", (Object)25, Integer.class).addParameter("wage", (Object)500.0, Double.class).build();
        PMML4Result resultHolder = helper.submitRequest(requestData);
        Assert.assertEquals((Object)"OK", (Object)resultHolder.getResultCode());
        Assert.assertEquals((long)6L, (long)resultHolder.getResultVariables().size());
        Assert.assertNotNull((Object)resultHolder.getResultValue("OutRC1", null, new Object[0]));
        Assert.assertNotNull((Object)resultHolder.getResultValue("OutRC2", null, new Object[0]));
        Assert.assertNotNull((Object)resultHolder.getResultValue("OutRC3", null, new Object[0]));
        Assert.assertEquals((Object)"RC2", (Object)resultHolder.getResultValue("OutRC1", "value", new Object[0]));
        Assert.assertEquals((Object)"RC1", (Object)resultHolder.getResultValue("OutRC2", "value", new Object[0]));
        Assert.assertEquals((Object)"RC1", (Object)resultHolder.getResultValue("OutRC3", "value", new Object[0]));
    }

    protected PMMLRequestData createRequest(String correlationId, String model, Double age, String occupation, String residenceState, boolean validLicense) {
        PMMLRequestDataBuilder rdb = new PMMLRequestDataBuilder(correlationId, model);
        rdb.addParameter("age", (Object)age, Double.class).addParameter("occupation", (Object)occupation, String.class).addParameter("residenceState", (Object)residenceState, String.class).addParameter("validLicense", (Object)validLicense, Boolean.class);
        return rdb.build();
    }
}

