/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.io.Resource;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.internal.io.ResourceFactory;
import org.kie.pmml.pmml_4_2.PMML4ExecutionHelper;
import org.kie.pmml.pmml_4_2.PMMLRequestDataBuilder;

@RunWith(value=Parameterized.class)
public class DecisionTreeWithSurrogateTest {
    private static final String DECISION_TREES_FOLDER = "org/kie/pmml/pmml_4_2/";
    private static final String treeWithSurrogate = "org/kie/pmml/pmml_4_2/test_tree_with_surrogate.pmml";
    private Optional<Double> temperature;
    private Optional<Double> humidity;
    private String decision;
    private String correlationId;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({Optional.of(34.0), Optional.empty(), "sunglasses", "1234"}, {Optional.of(34.0), Optional.of(15.0), "sunglasses", "5678"}, {Optional.empty(), Optional.of(15.0), "sunglasses", "9012"}, {Optional.empty(), Optional.of(85.0), "umbrella", "3456"}, {Optional.of(22.0), Optional.of(85.0), "umbrella", "7890"}, {Optional.of(22.0), Optional.of(35.0), "nothing", "4321"}, {Optional.empty(), Optional.of(35.0), "nothing", "0987"}, {Optional.of(22.0), Optional.empty(), "nothing", "6543"});
    }

    public DecisionTreeWithSurrogateTest(Optional<Double> temperature, Optional<Double> humidity, String decision, String correlationId) {
        this.temperature = temperature;
        this.humidity = humidity;
        this.decision = decision;
        this.correlationId = correlationId;
    }

    @Test
    public void testTreeWithSurrogatePredicate() {
        Resource res = ResourceFactory.newClassPathResource((String)treeWithSurrogate);
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SampleMine", (Resource)res, null, (boolean)false);
        helper.initModel();
        PMMLRequestDataBuilder rdb = new PMMLRequestDataBuilder(this.correlationId, "SampleMine");
        this.temperature.ifPresent(t -> rdb.addParameter("temperature", t, Double.class));
        this.humidity.ifPresent(h -> rdb.addParameter("humidity", h, Double.class));
        PMMLRequestData request = rdb.build();
        helper.submitRequest(request);
        helper.getResultData().iterator().forEachRemaining(rd -> {
            Assert.assertEquals((Object)"OK", (Object)rd.getResultCode());
            Assert.assertEquals((Object)this.correlationId, (Object)rd.getCorrelationId());
            String value = rd.getResultValue("Decision", "value", String.class, new Object[0]).orElse(null);
            Assert.assertEquals((Object)this.decision, (Object)value);
        });
    }
}

