/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.pmml.pmml_4_2.model.mining.MiningSegmentTransfer;

public class MiningSegmentTransferTest {
    private PMML4Result simpleResult;
    private PMML4Result complexResult;

    @Before
    public void setup() {
        this.simpleResult = new PMML4Result();
        this.simpleResult.setCorrelationId("1234");
        this.simpleResult.setResultCode("OK");
        this.simpleResult.setSegmentationId("Segmentation_1");
        this.simpleResult.setSegmentId("SEGMENT_1");
        this.simpleResult.addResultVariable("var1", (Object)new Integer(100));
        this.simpleResult.addResultVariable("var2", (Object)"Just some string");
        this.complexResult = new PMML4Result();
        this.complexResult.setCorrelationId("7890");
        this.complexResult.setResultCode("OK");
        this.complexResult.setSegmentationId("Segmentation_1");
        this.complexResult.setSegmentId("SEGMENT_1");
        this.complexResult.addResultVariable("firstObject", (Object)"Just a string");
        this.complexResult.addResultVariable("myComplex", (Object)new MyResult("a test string", 101));
    }

    private void doBaselineAssertions(PMML4Result reference, MiningSegmentTransfer mst) {
        Assert.assertNotNull((Object)mst);
        Assert.assertEquals((Object)reference.getCorrelationId(), (Object)mst.getCorrelationId());
        Assert.assertEquals((Object)reference.getSegmentationId(), (Object)mst.getSegmentationId());
        Assert.assertEquals((Object)reference.getSegmentId(), (Object)mst.getFromSegmentId());
        Assert.assertEquals((Object)"SEGMENT_2", (Object)mst.getToSegmentId());
        Assert.assertNotNull((Object)mst.getResultFieldNameToRequestFieldName());
    }

    @Test
    public void testSimpleResult() {
        MiningSegmentTransfer mst = new MiningSegmentTransfer(this.simpleResult, "SEGMENT_2");
        this.doBaselineAssertions(this.simpleResult, mst);
    }

    @Test
    public void testSimpleWithFieldNamesMap() {
        MiningSegmentTransfer mst = new MiningSegmentTransfer(this.simpleResult, "SEGMENT_2");
        mst.addResultToRequestMapping("var1", "someVarA");
        this.doBaselineAssertions(this.simpleResult, mst);
        Assert.assertEquals((long)1L, (long)mst.getResultFieldNameToRequestFieldName().size());
    }

    @Test
    public void testComplexResult() {
        MiningSegmentTransfer mst = new MiningSegmentTransfer(this.complexResult, "SEGMENT_2");
        mst.addResultToRequestMapping("firstObject", "object1");
        mst.addResultToRequestMapping("myComplex.varA", "stringFromMyComplex");
        mst.addResultToRequestMapping("myComplex.varB", "intValue");
        this.doBaselineAssertions(this.complexResult, mst);
        Assert.assertEquals((long)3L, (long)mst.getResultFieldNameToRequestFieldName().size());
        PMMLRequestData rqst = mst.getOutboundRequest();
        Assert.assertNotNull((Object)rqst);
        Assert.assertEquals((Object)this.complexResult.getCorrelationId(), (Object)rqst.getCorrelationId());
        Map params = rqst.getMappedRequestParams();
        Assert.assertEquals((Object)this.complexResult.getResultValue("firstObject", null, new Object[0]), (Object)((ParameterInfo)params.get("object1")).getValue());
        Assert.assertEquals((Object)this.complexResult.getResultValue("myComplex", "varA", new Object[0]), (Object)((ParameterInfo)params.get("stringFromMyComplex")).getValue());
        Assert.assertEquals((Object)this.complexResult.getResultValue("myComplex", "varB", new Object[0]), (Object)((ParameterInfo)params.get("intValue")).getValue());
        System.out.println(rqst);
        System.out.println(this.complexResult);
    }

    public class MyResult {
        private String varA;
        private int varB;

        public MyResult(String varA, int varB) {
            this.varA = varA;
            this.varB = varB;
        }

        public String getVarA() {
            return this.varA;
        }

        public void setVarA(String varA) {
            this.varA = varA;
        }

        public int getVarB() {
            return this.varB;
        }

        public void setVarB(int varB) {
            this.varB = varB;
        }
    }
}

