/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import org.dmg.pmml.pmml_4_2.descr.SimplePredicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.pmml_4_2.model.mining.SimpleSegmentPredicate;

public class SimpleSegmentPredicateTest {
    private SimplePredicate predicate;
    private static final String BAD_OP = "invalidOp";

    @Before
    public void setUp() throws Exception {
        this.predicate = new SimplePredicate();
        this.predicate.setField("TF2");
        this.predicate.setValue("123");
    }

    @Test
    public void testEquals() {
        this.predicate.setOperator("equal");
        SimpleSegmentPredicate ssp = new SimpleSegmentPredicate(this.predicate);
        String text = ssp.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)"vTF2 == 123", (Object)text);
    }

    @Test
    public void testNotEquals() {
        this.predicate.setOperator("notEqual");
        SimpleSegmentPredicate ssp = new SimpleSegmentPredicate(this.predicate);
        String text = ssp.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)"vTF2 != 123", (Object)text);
    }

    @Test
    public void testGreaterThan() {
        this.predicate.setOperator("greaterThan");
        SimpleSegmentPredicate ssp = new SimpleSegmentPredicate(this.predicate);
        String text = ssp.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)"vTF2 > 123", (Object)text);
    }

    @Test
    public void testLessThan() {
        this.predicate.setOperator("lessThan");
        SimpleSegmentPredicate ssp = new SimpleSegmentPredicate(this.predicate);
        String text = ssp.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)"vTF2 < 123", (Object)text);
    }

    @Test
    public void testMissing() {
        this.predicate.setOperator("isMissing");
        SimpleSegmentPredicate ssp = new SimpleSegmentPredicate(this.predicate);
        String text = ssp.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)"mTF2 == true", (Object)text);
    }

    @Test
    public void testGreaterEqual() {
        this.predicate.setOperator("greaterOrEqual");
        SimpleSegmentPredicate ssp = new SimpleSegmentPredicate(this.predicate);
        String text = ssp.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)"vTF2 >= 123", (Object)text);
    }

    @Test
    public void testLesserEqual() {
        this.predicate.setOperator("lessOrEqual");
        SimpleSegmentPredicate ssp = new SimpleSegmentPredicate(this.predicate);
        String text = ssp.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)"vTF2 <= 123", (Object)text);
    }

    @Test
    public void testNotMissing() {
        this.predicate.setOperator("isNotMissing");
        SimpleSegmentPredicate ssp = new SimpleSegmentPredicate(this.predicate);
        String text = ssp.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)"mTF2 == false", (Object)text);
    }

    @Test(expected=IllegalStateException.class)
    public void testBadOperator() {
        this.predicate.setOperator(BAD_OP);
        SimpleSegmentPredicate ssp = new SimpleSegmentPredicate(this.predicate);
        String text = ssp.getPredicateRule();
        Assert.assertNull((Object)text);
    }
}

