/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models;

import java.util.Collection;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.kie.pmml.pmml_4_2.model.PMMLRequestData;
import org.kie.pmml.pmml_4_2.model.ParameterInfo;
import org.kie.pmml.pmml_4_2.model.tree.AbstractTreeToken;

public class DecisionTreeTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = false;
    private static final String source1 = "org/kie/pmml/pmml_4_2/test_tree_simple.pmml";
    private static final String source2 = "org/kie/pmml/pmml_4_2/test_tree_missing.pmml";
    private static final String source3 = "org/kie/pmml/pmml_4_2/test_tree_handwritten.pmml";
    private static final String packageName = "org.kie.pmml.pmml_4_2.test";

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testSimpleTree() throws Exception {
        this.setKSession(this.getModelSession(source1, false));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData request = new PMMLRequestData("123", "TreeTest");
        request.addRequestParam("Fld1", (Object)30.0);
        request.addRequestParam("Fld2", (Object)60.0);
        request.addRequestParam("Fld3", (Object)"false");
        request.addRequestParam("Fld4", (Object)"optA");
        kSession.insert((Object)request);
        kSession.fireAllRules();
        String pkgName = "org.kie.pmml.pmml_4_2." + request.getModelName();
        FactType tgt = kSession.getKieBase().getFactType(pkgName, "Fld5");
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtY");
        this.checkGeneratedRules();
    }

    protected Object getToken(KieSession kSession, String treeModelName) {
        final String className = "org.kie.pmml.pmml_4_2.model." + treeModelName + "TreeToken";
        Collection objects = kSession.getObjects(new ObjectFilter(){

            public boolean accept(Object object) {
                return object.getClass().getName().equals(className);
            }
        });
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)1L, (long)objects.size());
        Iterator iter = objects.iterator();
        assert (iter.hasNext());
        return iter.next();
    }

    @Test
    public void testMissingTree() throws Exception {
        this.setKSession(this.getModelSession(source2, false));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData requestData = new PMMLRequestData("123", "Missing");
        requestData.addRequestParam(new ParameterInfo("123", "Fld1", Double.class, (Object)45.0));
        requestData.addRequestParam(new ParameterInfo("123", "Fld2", Double.class, (Object)60.0));
        requestData.addRequestParam(new ParameterInfo("123", "Fld3", String.class, (Object)"optA"));
        kSession.insert((Object)requestData);
        kSession.fireAllRules();
        String pkgName = "org.kie.pmml.pmml_4_2." + requestData.getModelName();
        FactType tgt = kSession.getKieBase().getFactType(pkgName, "Fld9");
        AbstractTreeToken token = (AbstractTreeToken)this.getToken(kSession, "Missing");
        Assert.assertEquals((double)0.6, (double)token.getConfidence(), (double)0.0);
        Assert.assertEquals((Object)"null", (Object)token.getCurrent());
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtZ");
        this.checkGeneratedRules();
    }

    @Test
    public void testMissingTreeWeighted1() throws Exception {
        this.setKSession(this.getModelSession(source2, false));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData data = new PMMLRequestData("123", "Missing");
        data.addRequestParam(new ParameterInfo("123", "Fld1", Double.class, (Object)-1.0));
        data.addRequestParam(new ParameterInfo("123", "Fld2", Double.class, (Object)-1.0));
        data.addRequestParam(new ParameterInfo("123", "Fld3", String.class, (Object)"optA"));
        kSession.insert((Object)data);
        kSession.fireAllRules();
        String pkgName = "org.kie.pmml.pmml_4_2." + data.getModelName();
        FactType tgt = kSession.getKieBase().getFactType(pkgName, "Fld9");
        AbstractTreeToken token = (AbstractTreeToken)this.getToken(kSession, "Missing");
        Assert.assertEquals((double)0.8, (double)token.getConfidence(), (double)0.0);
        Assert.assertEquals((Object)"null", (Object)token.getCurrent());
        Assert.assertEquals((double)50.0, (double)token.getTotalCount(), (double)0.0);
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtX");
        this.checkGeneratedRules();
    }

    @Test
    public void testMissingTreeWeighted2() throws Exception {
        this.setKSession(this.getModelSession(source2, false));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData data = new PMMLRequestData("123", "Missing");
        data.addRequestParam(new ParameterInfo("123", "Fld1", Double.class, (Object)-1.0));
        data.addRequestParam(new ParameterInfo("123", "Fld2", Double.class, (Object)-1.0));
        data.addRequestParam(new ParameterInfo("123", "Fld3", String.class, (Object)"miss"));
        kSession.insert((Object)data);
        kSession.fireAllRules();
        String pkgName = "org.kie.pmml.pmml_4_2." + data.getModelName();
        FactType tgt = kSession.getKieBase().getFactType(pkgName, "Fld9");
        AbstractTreeToken token = (AbstractTreeToken)this.getToken(kSession, "Missing");
        Assert.assertEquals((double)0.6, (double)token.getConfidence(), (double)0.0);
        Assert.assertEquals((Object)"null", (Object)token.getCurrent());
        Assert.assertEquals((double)100.0, (double)token.getTotalCount(), (double)0.0);
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "Missing", "tgtX");
        this.checkGeneratedRules();
    }
}

