/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.core.ClassObjectFilter;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.kie.pmml.pmml_4_2.PMML4Result;
import org.kie.pmml.pmml_4_2.model.PMMLRequestData;
import org.kie.pmml.pmml_4_2.model.ParameterInfo;
import org.kie.pmml.pmml_4_2.model.ScoreCard;
import org.kie.pmml.pmml_4_2.model.mining.SegmentExecution;
import org.kie.pmml.pmml_4_2.model.tree.AbstractTreeToken;

public class MiningmodelTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = true;
    private static final String source1 = "org/kie/pmml/pmml_4_2/test_mining_model_simple.pmml";
    private static final String source2 = "org/kie/pmml/pmml_4_2/test_mining_model_simple2.pmml";
    private static final String source3 = "org/kie/pmml/pmml_4_2/filebased";
    private static final String source4 = "org/kie/pmml/pmml_4_2/test_mining_model_selectall.pmml";
    private static final String source5 = "org/kie/pmml/pmml_4_2/test_mining_model_modelchain.pmml";
    private static final String RESOURCES_TEST_ROOT = "src/test/resources/";

    @Test
    public void testSelectFirstSegmentFirst() {
        this.setKSession(this.getModelSession(source1, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData request = new PMMLRequestData("1234", "SampleMine");
        request.addRequestParam("fld1", (Object)30.0);
        request.addRequestParam("fld2", (Object)60.0);
        request.addRequestParam("fld3", (Object)"false");
        request.addRequestParam("fld4", (Object)"optA");
        kSession.insert((Object)request);
        kSession.fireAllRules();
        Collection objs = kSession.getObjects((ObjectFilter)new ClassObjectFilter(PMML4Result.class));
        Assert.assertEquals((long)1L, (long)objs.size());
        PMML4Result result = (PMML4Result)objs.iterator().next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"OK", (Object)result.getResultCode());
        Assert.assertNotNull((Object)result.getResultVariables());
        Map resultVars = result.getResultVariables();
        Assert.assertEquals((long)1L, (long)resultVars.size());
        Object fldFive = this.getResultValue(result, "Fld5", null, new Object[0]);
        Assert.assertNotNull((Object)fldFive);
        Object fldFiveMissing = this.getResultValue(result, "Fld5", "missing", new Object[0]);
        Assert.assertNotNull((Object)fldFiveMissing);
        Assert.assertTrue((boolean)fldFiveMissing.equals(Boolean.FALSE));
        Object fldFiveValue = this.getResultValue(result, "Fld5", "value", new Object[0]);
        Assert.assertNotNull((Object)fldFiveValue);
        Assert.assertEquals((Object)"tgtY", (Object)fldFiveValue);
    }

    @Test
    public void testSelectSecondSegmentFirst() {
        this.setKSession(this.getModelSession(source1, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData requestData = new PMMLRequestData("1234", "SampleMine");
        requestData.addRequestParam(new ParameterInfo("1234", "fld1", Double.class, (Object)45.0));
        requestData.addRequestParam(new ParameterInfo("1234", "fld2", Double.class, (Object)60.0));
        requestData.addRequestParam(new ParameterInfo("1234", "fld6", String.class, (Object)"optA"));
        kSession.insert((Object)requestData);
        kSession.fireAllRules();
        Collection objs = kSession.getObjects((ObjectFilter)new ClassObjectFilter(PMML4Result.class));
        Assert.assertEquals((long)1L, (long)objs.size());
        PMML4Result result = (PMML4Result)objs.iterator().next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"OK", (Object)result.getResultCode());
        Assert.assertNotNull((Object)result.getResultVariables());
        Map resultVars = result.getResultVariables();
        Object fldFive = this.getResultValue(result, "Fld5", null, new Object[0]);
        Assert.assertNotNull((Object)fldFive);
        Object fldFiveMissing = this.getResultValue(result, "Fld5", "missing", new Object[0]);
        Assert.assertNotNull((Object)fldFiveMissing);
        Assert.assertFalse((boolean)((Boolean)fldFiveMissing));
        Object fldFiveValid = this.getResultValue(result, "Fld5", "valid", new Object[0]);
        Assert.assertNotNull((Object)fldFiveValid);
        Assert.assertTrue((boolean)((Boolean)fldFiveValid));
        Object fldFiveValue = this.getResultValue(result, "Fld5", "value", new Object[0]);
        Assert.assertNotNull((Object)fldFiveValue);
        Assert.assertEquals((Object)"tgtZ", (Object)fldFiveValue);
        Object token = this.getResultValue(result, "MissingTreeToken", null, new Object[0]);
        Assert.assertNotNull((Object)token);
        AbstractTreeToken att = (AbstractTreeToken)token;
        Assert.assertEquals((double)0.6, (double)att.getConfidence(), (double)0.0);
        Assert.assertEquals((Object)"null", (Object)att.getCurrent());
        Collection segmentExecs = kSession.getObjects((ObjectFilter)new ClassObjectFilter(SegmentExecution.class));
        Assert.assertNotNull((Object)segmentExecs);
        Assert.assertEquals((long)1L, (long)segmentExecs.size());
        SegmentExecution segEx = (SegmentExecution)segmentExecs.iterator().next();
    }

    @Test
    public void testWithScorecard() {
        this.setKSession(this.getModelSession(source2, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData requestData = new PMMLRequestData("1234", "SampleScorecardMine");
        requestData.addRequestParam("age", (Object)33.0);
        requestData.addRequestParam("occupation", (Object)"SKYDIVER");
        requestData.addRequestParam("residenceState", (Object)"KN");
        requestData.addRequestParam("validLicense", (Object)true);
        kSession.insert((Object)requestData);
        kSession.fireAllRules();
        Collection objs = kSession.getObjects((ObjectFilter)new ClassObjectFilter(PMML4Result.class));
        Assert.assertEquals((long)1L, (long)objs.size());
        PMML4Result result = (PMML4Result)objs.iterator().next();
        Assert.assertNotNull((Object)result);
        Object sc = this.getResultValue(result, "ScoreCard", null, new Object[0]);
        Assert.assertNotNull((Object)sc);
        Assert.assertTrue((boolean)(sc instanceof ScoreCard));
        ScoreCard scorecard = (ScoreCard)sc;
        Map map = scorecard.getRanking();
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)(map instanceof LinkedHashMap));
        LinkedHashMap ranking = (LinkedHashMap)map;
        Assert.assertTrue((boolean)ranking.containsKey("LX00"));
        Assert.assertTrue((boolean)ranking.containsKey("RES"));
        Assert.assertTrue((boolean)ranking.containsKey("CX2"));
        Assert.assertEquals((Object)-1.0, ranking.get("LX00"));
        Assert.assertEquals((Object)-10.0, ranking.get("RES"));
        Assert.assertEquals((Object)-30.0, ranking.get("CX2"));
        Iterator iter = ranking.keySet().iterator();
        Assert.assertEquals((Object)"LX00", iter.next());
        Assert.assertEquals((Object)"RES", iter.next());
        Assert.assertEquals((Object)"CX2", iter.next());
    }

    @Test
    public void testWithRegression() {
        this.setKSession(this.getModelSession(source2, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData request = new PMMLRequestData("123", "SampleScorecardMine");
        request.addRequestParam("fld1r", (Object)1.0);
        request.addRequestParam("fld2r", (Object)1.0);
        request.addRequestParam("fld3r", (Object)"x");
        kSession.insert((Object)request);
        kSession.fireAllRules();
        Collection objs = kSession.getObjects((ObjectFilter)new ClassObjectFilter(PMML4Result.class));
        Assert.assertNotNull((Object)objs);
        Assert.assertEquals((long)1L, (long)objs.size());
        PMML4Result result = (PMML4Result)objs.iterator().next();
        Assert.assertNotNull((Object)result);
        Object regOutValue = this.getResultValue(result, "RegOut", "value", new Object[0]);
        Assert.assertNotNull((Object)regOutValue);
        Assert.assertTrue((boolean)(regOutValue instanceof String));
        Assert.assertEquals((Object)"catC", (Object)regOutValue);
        Object regProbValue = this.getResultValue(result, "RegProb", "value", new Object[0]);
        Assert.assertNotNull((Object)regProbValue);
        Assert.assertEquals((double)0.709228, (double)((Double)regProbValue), (double)1.0E-6);
        Object regProbAValue = this.getResultValue(result, "RegProbA", "value", new Object[0]);
        Assert.assertNotNull((Object)regProbAValue);
        Assert.assertEquals((double)0.010635, (double)((Double)regProbAValue), (double)1.0E-6);
    }

    @Test
    public void testSelectAll() {
        this.setKSession(this.getModelSession(source4, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData requestData = new PMMLRequestData("1234", "SampleSelectAllMine");
        requestData.addRequestParam("age", (Object)33.0);
        requestData.addRequestParam("occupation", (Object)"SKYDIVER");
        requestData.addRequestParam("residenceState", (Object)"KN");
        requestData.addRequestParam("validLicense", (Object)true);
        kSession.insert((Object)requestData);
        kSession.fireAllRules();
        Collection objs = kSession.getObjects((ObjectFilter)new ClassObjectFilter(PMML4Result.class));
        Assert.assertEquals((long)2L, (long)objs.size());
        PMML4Result[] results = objs.toArray(new PMML4Result[objs.size()]);
        Assert.assertNotNull((Object)results[0]);
        Assert.assertEquals((Object)"OK", (Object)results[0].getResultCode());
        Assert.assertEquals((Object)"1234", (Object)results[0].getCorrelationId());
        Assert.assertNotNull((Object)results[1]);
        Assert.assertEquals((Object)"OK", (Object)results[1].getResultCode());
        Assert.assertEquals((Object)"1234", (Object)results[1].getCorrelationId());
        Object[] sc = new Object[2];
        ScoreCard[] scorecard = new ScoreCard[2];
        Map[] map = new Map[2];
        for (int cnt = 0; cnt < 2; ++cnt) {
            Iterator iter;
            sc[cnt] = this.getResultValue(results[cnt], "ScoreCard", null, new Object[0]);
            Assert.assertNotNull((Object)sc[cnt]);
            Assert.assertTrue((boolean)(sc[cnt] instanceof ScoreCard));
            scorecard[cnt] = (ScoreCard)sc[cnt];
            map[cnt] = scorecard[cnt].getRanking();
            Assert.assertNotNull((Object)map[cnt]);
            Assert.assertTrue((boolean)(map[cnt] instanceof LinkedHashMap));
            LinkedHashMap ranking = (LinkedHashMap)map[cnt];
            Assert.assertTrue((ranking.containsKey("LX00") || ranking.containsKey("LC00") ? 1 : 0) != 0);
            if (ranking.containsKey("LX00")) {
                Assert.assertTrue((boolean)ranking.containsKey("RES"));
                Assert.assertTrue((boolean)ranking.containsKey("CX2"));
                Assert.assertEquals((Object)-1.0, ranking.get("LX00"));
                Assert.assertEquals((Object)-10.0, ranking.get("RES"));
                Assert.assertEquals((Object)-30.0, ranking.get("CX2"));
                iter = ranking.keySet().iterator();
                Assert.assertEquals((Object)"LX00", iter.next());
                Assert.assertEquals((Object)"RES", iter.next());
                Assert.assertEquals((Object)"CX2", iter.next());
                Assert.assertEquals((double)41.345, (double)scorecard[cnt].getScore(), (double)1.0E-6);
                continue;
            }
            Assert.assertTrue((boolean)ranking.containsKey("RST"));
            Assert.assertTrue((boolean)ranking.containsKey("DX2"));
            Assert.assertEquals((Object)-1.0, ranking.get("LC00"));
            Assert.assertEquals((Object)10.0, ranking.get("RST"));
            Assert.assertEquals((Object)-30.0, ranking.get("DX2"));
            iter = ranking.keySet().iterator();
            Assert.assertEquals((Object)"RST", iter.next());
            Assert.assertEquals((Object)"LC00", iter.next());
            Assert.assertEquals((Object)"DX2", iter.next());
            Assert.assertEquals((double)21.345, (double)scorecard[cnt].getScore(), (double)1.0E-6);
        }
    }

    @Test
    public void testFolderBased() {
        String filename = "src/test/resources/org/kie/pmml/pmml_4_2/filebased";
        File file = new File(filename);
        this.setKSession(this.getModelSession(file));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        Assert.assertNotNull((Object)kSession);
        kSession.fireAllRules();
        PMMLRequestData request = new PMMLRequestData("1234", "SampleMine");
        request.addRequestParam("fld1", (Object)30.0);
        request.addRequestParam("fld2", (Object)60.0);
        request.addRequestParam("fld3", (Object)"false");
        request.addRequestParam("fld4", (Object)"optA");
        kSession.insert((Object)request);
        kSession.fireAllRules();
        Collection objs = kSession.getObjects((ObjectFilter)new ClassObjectFilter(PMML4Result.class));
        Assert.assertEquals((long)1L, (long)objs.size());
        PMML4Result result = (PMML4Result)objs.iterator().next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"OK", (Object)result.getResultCode());
        Assert.assertNotNull((Object)result.getResultVariables());
        Map resultVars = result.getResultVariables();
        Assert.assertEquals((long)1L, (long)resultVars.size());
        Object fldFive = this.getResultValue(result, "Fld5", null, new Object[0]);
        Assert.assertNotNull((Object)fldFive);
        Object fldFiveMissing = this.getResultValue(result, "Fld5", "missing", new Object[0]);
        Assert.assertNotNull((Object)fldFiveMissing);
        Assert.assertTrue((boolean)fldFiveMissing.equals(Boolean.FALSE));
        Object fldFiveValue = this.getResultValue(result, "Fld5", "value", new Object[0]);
        Assert.assertNotNull((Object)fldFiveValue);
        Assert.assertEquals((Object)"tgtY", (Object)fldFiveValue);
    }

    @Ignore
    @Test
    public void testModelChain() {
        this.setKSession(this.getModelSession(source5, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData requestData = new PMMLRequestData("1234", "SampleModelChainMine");
        requestData.addRequestParam("age", (Object)33.0);
        requestData.addRequestParam("occupation", (Object)"SKYDIVER");
        requestData.addRequestParam("residenceState", (Object)"KN");
        requestData.addRequestParam("validLicense", (Object)true);
        kSession.insert((Object)requestData);
        kSession.fireAllRules();
        Collection objs = kSession.getObjects((ObjectFilter)new ClassObjectFilter(PMML4Result.class));
        Assert.assertEquals((long)2L, (long)objs.size());
        for (PMML4Result result : objs) {
            System.out.println(result.toString());
            Assert.assertEquals((Object)"OK", (Object)result.getResultCode());
        }
    }
}

