/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.kie.pmml.pmml_4_2.model.PMMLRequestData;
import org.kie.pmml.pmml_4_2.model.ScoreCard;

public class ScorecardTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = true;
    private static final String source1 = "org/kie/pmml/pmml_4_2/test_scorecard.pmml";
    private static final String source2 = "org/kie/pmml/pmml_4_2/test_scorecardOut.pmml";
    private static final String packageName = "org.kie.pmml.pmml_4_2.test";

    @After
    public void tearDown() {
    }

    @Test
    public void testScorecard() throws Exception {
        this.setKSession(this.getModelSession(source1, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData requestData = new PMMLRequestData("123", "Sample Score");
        requestData.addRequestParam("age", (Object)33.0);
        requestData.addRequestParam("occupation", (Object)"SKYDIVER");
        requestData.addRequestParam("residenceState", (Object)"KN");
        requestData.addRequestParam("validLicense", (Object)true);
        kSession.insert((Object)requestData);
        kSession.fireAllRules();
        Collection scoreCards = kSession.getObjects((ObjectFilter)new ClassObjectFilter(ScoreCard.class));
        Assert.assertNotNull((Object)scoreCards);
        Assert.assertEquals((long)1L, (long)scoreCards.size());
        ScoreCard scoreCard = (ScoreCard)scoreCards.iterator().next();
        Map x = scoreCard.getRanking();
        Assert.assertTrue((boolean)(x instanceof LinkedHashMap));
        System.out.print(this.reportWMObjects(kSession));
        LinkedHashMap map = (LinkedHashMap)x;
        Assert.assertTrue((boolean)map.containsKey("LX00"));
        Assert.assertTrue((boolean)map.containsKey("RES"));
        Assert.assertTrue((boolean)map.containsKey("CX2"));
        Assert.assertEquals((Object)-1.0, map.get("LX00"));
        Assert.assertEquals((Object)-10.0, map.get("RES"));
        Assert.assertEquals((Object)-30.0, map.get("CX2"));
        Iterator iter = map.keySet().iterator();
        Assert.assertEquals((Object)"LX00", iter.next());
        Assert.assertEquals((Object)"RES", iter.next());
        Assert.assertEquals((Object)"CX2", iter.next());
        this.checkGeneratedRules();
    }

    @Test
    public void testScorecardOutputs() throws Exception {
        this.setKSession(this.getModelSession(source2, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData requestData = new PMMLRequestData("123", "SampleScorecard");
        requestData.addRequestParam("cage", (Object)"engineering");
        requestData.addRequestParam("age", (Object)25);
        requestData.addRequestParam("wage", (Object)500.0);
        kSession.insert((Object)requestData);
        kSession.fireAllRules();
        String pkgName = "org.kie.pmml.pmml_4_2." + requestData.getModelName();
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(pkgName, "OutRC1"), true, false, "SampleScorecard", "RC2");
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(pkgName, "OutRC2"), true, false, "SampleScorecard", "RC1");
        this.checkFirstDataFieldOfTypeStatus(this.getKbase().getFactType(pkgName, "OutRC3"), true, false, "SampleScorecard", "RC1");
        this.checkGeneratedRules();
    }
}

