/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models;

import org.junit.After;
import org.junit.Test;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.kie.pmml.pmml_4_2.model.PMMLRequestData;

public class SimpleRegressionTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = true;
    private static final String source1 = "org/kie/pmml/pmml_4_2/test_regression.pmml";
    private static final String source2 = "org/kie/pmml/pmml_4_2/test_regression_clax.pmml";
    private static final String packageName = "org.kie.pmml.pmml_4_2.test";

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testRegression() throws Exception {
        this.setKSession(this.getModelSession(source1, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        PMMLRequestData request = new PMMLRequestData("123", "LinReg");
        request.addRequestParam("Fld1", (Object)0.9);
        request.addRequestParam("Fld2", (Object)0.3);
        request.addRequestParam("Fld3", (Object)"x");
        kSession.insert((Object)request);
        kSession.fireAllRules();
        String pkgName = "org.kie.pmml.pmml_4_2." + request.getModelName();
        FactType tgt = kSession.getKieBase().getFactType(pkgName, "Fld4");
        double x = 2.2579999999999996;
        x = 1.0 / (1.0 + Math.exp(-x));
        this.checkFirstDataFieldOfTypeStatus(tgt, true, false, "LinReg", x);
        this.checkGeneratedRules();
    }

    @Test
    public void testClassification() throws Exception {
        this.setKSession(this.getModelSession(source2, true));
        this.setKbase(this.getKSession().getKieBase());
        KieSession kSession = this.getKSession();
        kSession.fireAllRules();
        FactType tgt = kSession.getKieBase().getFactType(packageName, "Fld4");
        PMMLRequestData request = new PMMLRequestData("123", "LinReg");
        request.addRequestParam("Fld1", (Object)1.0);
        request.addRequestParam("Fld2", (Object)1.0);
        request.addRequestParam("Fld3", (Object)"x");
        kSession.insert((Object)request);
        kSession.fireAllRules();
        String pkgName = "org.kie.pmml.pmml_4_2." + request.getModelName();
        this.checkFirstDataFieldOfTypeStatus(kSession.getKieBase().getFactType(pkgName, "RegOut"), true, false, "LinReg", "catC");
        this.checkFirstDataFieldOfTypeStatus(kSession.getKieBase().getFactType(pkgName, "RegProb"), true, false, "LinReg", 0.709228);
        this.checkFirstDataFieldOfTypeStatus(kSession.getKieBase().getFactType(pkgName, "RegProbA"), true, false, "LinReg", 0.010635);
        this.checkGeneratedRules();
    }
}

