/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.global;

import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.pmml.pmml_4_2.DroolsAbstractPMMLTest;

@Ignore
public class DataDictionaryTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = false;
    private static final String source = "org/kie/pmml/pmml_4_2/test_data_dic.xml";
    private static final String packageName = "org.kie.pmml.pmml_4_2.test";

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testDataTypes() throws Exception {
        this.setKSession(this.getModelSession(source, false));
        this.setKbase(this.getKSession().getKieBase());
        FactType gender = this.getKbase().getFactType(packageName, "Gender");
        FactType noclaims = this.getKbase().getFactType(packageName, "NoOfClaims");
        FactType scrambled = this.getKbase().getFactType(packageName, "Scrambled");
        FactType domicile = this.getKbase().getFactType(packageName, "Domicile");
        FactType agecar = this.getKbase().getFactType(packageName, "AgeOfCar");
        FactType amklaims = this.getKbase().getFactType(packageName, "AmountOfClaims");
        Object g = gender.newInstance();
        Assert.assertEquals((Object)"org.kie.pmml.pmml_4_2.test.Gender", (Object)g.getClass().getName());
        gender.set(g, "value", (Object)"M");
        Assert.assertEquals((Object)"M", (Object)gender.get(g, "value"));
        Object n = noclaims.newInstance();
        Assert.assertEquals((Object)"org.kie.pmml.pmml_4_2.test.NoOfClaims", (Object)n.getClass().getName());
        noclaims.set(n, "value", (Object)"> 3");
        Assert.assertEquals((Object)"> 3", (Object)noclaims.get(n, "value"));
        Object s = scrambled.newInstance();
        Assert.assertEquals((Object)"org.kie.pmml.pmml_4_2.test.Scrambled", (Object)s.getClass().getName());
        scrambled.set(s, "value", (Object)1);
        Assert.assertEquals((Object)1, (Object)scrambled.get(s, "value"));
        Object d = domicile.newInstance();
        Assert.assertEquals((Object)"org.kie.pmml.pmml_4_2.test.Domicile", (Object)d.getClass().getName());
        domicile.set(d, "value", (Object)"SomeWhere");
        Assert.assertEquals((Object)"SomeWhere", (Object)domicile.get(d, "value"));
        Object a = agecar.newInstance();
        Assert.assertEquals((Object)"org.kie.pmml.pmml_4_2.test.AgeOfCar", (Object)a.getClass().getName());
        agecar.set(a, "value", (Object)24.3);
        Assert.assertEquals((Object)24.3, (Object)agecar.get(a, "value"));
        Object k = amklaims.newInstance();
        Assert.assertEquals((Object)"org.kie.pmml.pmml_4_2.test.AmountOfClaims", (Object)k.getClass().getName());
        amklaims.set(k, "value", (Object)9);
        Assert.assertEquals((Object)9, (Object)amklaims.get(k, "value"));
        try {
            agecar.set(a, "value", (Object)"Not a String field");
            Assert.fail();
        }
        catch (ClassCastException cce) {
            Assert.assertEquals((Object)24.3, (Object)agecar.get(a, "value"));
        }
        Assert.assertFalse((boolean)((Boolean)agecar.get(a, "valid")));
        agecar.set(a, "valid", (Object)true);
        Assert.assertTrue((boolean)((Boolean)agecar.get(a, "valid")));
        Assert.assertFalse((boolean)((Boolean)agecar.get(a, "missing")));
        agecar.set(a, "missing", (Object)true);
        Assert.assertTrue((boolean)((Boolean)agecar.get(a, "missing")));
        this.checkGeneratedRules();
    }

    @Test
    public void testEntryPoints() throws Exception {
        this.setKSession(this.getModelSession(source, false));
        this.setKbase(this.getKSession().getKieBase());
        FactType gender = this.getKbase().getFactType(packageName, "Gender");
        FactType noclaims = this.getKbase().getFactType(packageName, "NoOfClaims");
        FactType scrambled = this.getKbase().getFactType(packageName, "Scrambled");
        FactType domicile = this.getKbase().getFactType(packageName, "Domicile");
        FactType agecar = this.getKbase().getFactType(packageName, "AgeOfCar");
        FactType amklaims = this.getKbase().getFactType(packageName, "AmountOfClaims");
        Assert.assertEquals((long)7L, (long)this.getKSession().getEntryPoints().size());
        EntryPoint gender_ep = this.getKSession().getEntryPoint("in_Gender");
        Assert.assertNotNull((Object)gender_ep);
        EntryPoint noclaims_ep = this.getKSession().getEntryPoint("in_NoOfClaims");
        Assert.assertNotNull((Object)noclaims_ep);
        EntryPoint scrambled_ep = this.getKSession().getEntryPoint("in_Scrambled");
        Assert.assertNotNull((Object)scrambled_ep);
        EntryPoint domicile_ep = this.getKSession().getEntryPoint("in_Domicile");
        Assert.assertNotNull((Object)domicile_ep);
        EntryPoint agecar_ep = this.getKSession().getEntryPoint("in_AgeOfCar");
        Assert.assertNotNull((Object)agecar_ep);
        EntryPoint amklaims_ep = this.getKSession().getEntryPoint("in_AmountOfClaims");
        Assert.assertNotNull((Object)amklaims_ep);
        gender_ep.insert((Object)"M");
        noclaims_ep.insert((Object)"> 4");
        scrambled_ep.insert((Object)4);
        domicile_ep.insert((Object)"way out");
        agecar_ep.insert((Object)new Double("3.4"));
        amklaims_ep.insert((Object)9);
        this.getKSession().fireAllRules();
        Assert.assertEquals((long)6L, (long)this.getKSession().getObjects().size());
        Assert.assertEquals((long)1L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(gender.getFactClass())).size());
        Assert.assertEquals((long)1L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(noclaims.getFactClass())).size());
        Assert.assertEquals((long)1L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(scrambled.getFactClass())).size());
        Assert.assertEquals((long)1L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(domicile.getFactClass())).size());
        Assert.assertEquals((long)1L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(agecar.getFactClass())).size());
        Assert.assertEquals((long)1L, (long)this.getKSession().getObjects((ObjectFilter)new ClassObjectFilter(amklaims.getFactClass())).size());
        this.checkFirstDataFieldOfTypeStatus(amklaims, true, false, null, 9);
        this.checkFirstDataFieldOfTypeStatus(domicile, false, false, null, "way out");
        this.checkGeneratedRules();
    }
}

