/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.kie.pmml.pmml_4_2.model.ExternalBeanRef;

public class ExternalBeanRefTest {
    private static final String pkgName = "org.drools.scorecard.example";
    private static final String clsName = "Attribute";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testValidExternalRef() {
        try {
            ExternalBeanRef ref = new ExternalBeanRef("attribute", "org.drools.scorecard.example.Attribute", ExternalBeanRef.ModelUsage.MINING);
            Assert.assertNotNull((Object)ref);
            Assert.assertEquals((Object)pkgName, (Object)ref.getBeanPackageName());
            Assert.assertEquals((Object)clsName, (Object)ref.getBeanName());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExternalRefMissingPackage() {
        try {
            ExternalBeanRef ref = new ExternalBeanRef("attribute", clsName, ExternalBeanRef.ModelUsage.MINING);
            Assert.assertNotNull((Object)ref);
            Assert.assertEquals((Object)"org.kie.pmml.externalbean", (Object)ref.getBeanPackageName());
            Assert.assertEquals((Object)clsName, (Object)ref.getBeanName());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExternalRefEmptyName() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Unable to construct ExternalBeanRef.");
        ExternalBeanRef ref = new ExternalBeanRef("attribute", "", ExternalBeanRef.ModelUsage.MINING);
        Assert.fail((String)"Expected an Exception due to empty bean information string");
    }
}

