/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model;

import java.io.IOException;
import java.io.InputStream;
import org.dmg.pmml.pmml_4_2.descr.PMML;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.internal.io.ResourceFactory;
import org.kie.pmml.pmml_4_2.PMML4Compiler;
import org.kie.pmml.pmml_4_2.PMML4Unit;
import org.kie.pmml.pmml_4_2.model.PMML4UnitImpl;
import org.kie.pmml.pmml_4_2.model.PMMLDataField;

public class PMML4UnitImplTest {
    private static PMML4Compiler compiler = new PMML4Compiler();
    private static String TEST_PMML_DIRECTORY = "org/kie/pmml/pmml_4_2/";
    private static String RESOURCE_PATH = TEST_PMML_DIRECTORY + "single_audit_dectree.pmml";
    private static String CAPITALIZED_DICTIONARY_ENTRY = "Age";
    private static String LOWERCASE_DICTIONARY_ENTRY = "marital";
    private static String NONEXIST_DICTIONARY_ENTRY = "Marital";
    private PMML4Unit pmmlUnit;

    @Before
    public void before() {
        InputStream is = null;
        Resource res = ResourceFactory.newClassPathResource((String)RESOURCE_PATH);
        Assert.assertNotNull((Object)res);
        try {
            is = res.getInputStream();
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)is);
        PMML pmml = compiler.loadModel("org.kie.pmml.pmml_4_2.descr", is);
        Assert.assertNotNull((Object)pmml);
        this.pmmlUnit = new PMML4UnitImpl(pmml);
        Assert.assertNotNull((Object)this.pmmlUnit);
    }

    @Test
    public void testFindCapitalizedDataDictionaryEntry() {
        PMMLDataField field = this.pmmlUnit.findDataDictionaryEntry(CAPITALIZED_DICTIONARY_ENTRY);
        Assert.assertNotNull((Object)field);
    }

    @Test
    public void testFindLowercaseDataDictionaryEntry() {
        PMMLDataField field = this.pmmlUnit.findDataDictionaryEntry(LOWERCASE_DICTIONARY_ENTRY);
        Assert.assertNotNull((Object)field);
    }

    @Test
    public void testMissingDataDictionaryEntry() {
        PMMLDataField field = this.pmmlUnit.findDataDictionaryEntry(NONEXIST_DICTIONARY_ENTRY);
        Assert.assertNull((Object)field);
    }
}

