/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models;

import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Variable;
import org.kie.pmml.pmml_4_2.DroolsAbstractPMMLTest;

@Ignore
public class NaiveBayesTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = true;
    private static final String source1 = "org/kie/pmml/pmml_4_2/test_naiveBayes.xml";
    private static final String source2 = "org/kie/pmml/pmml_4_2/test_bayes_continuousDist.xml";

    @After
    public void tearDown() {
        this.getKSession().dispose();
    }

    @Test
    public void testNaiveBayes() throws Exception {
        KieSession kieSession = this.getModelSession(source1, true);
        this.setKSession(kieSession);
        kieSession.fireAllRules();
        kieSession.getEntryPoint("in_Gender").insert((Object)"male");
        kieSession.getEntryPoint("in_NoOfClaims").insert((Object)"2");
        kieSession.getEntryPoint("in_AgeOfCar").insert((Object)1.0);
        kieSession.fireAllRules();
        QueryResults q1 = kieSession.getQueryResults("ProbabilityOf500", new Object[]{"NaiveBayesInsurance", Variable.v});
        Assert.assertEquals((long)1L, (long)q1.size());
        Object a1 = ((QueryResultsRow)q1.iterator().next()).get("$result");
        Assert.assertTrue((boolean)(a1 instanceof Double));
        Assert.assertEquals((double)0.034, (double)((Double)a1), (double)4.0);
        QueryResults q2 = kieSession.getQueryResults("ChosenClass", new Object[]{"NaiveBayesInsurance", Variable.v});
        Assert.assertEquals((long)1L, (long)q2.size());
        Object a2 = ((QueryResultsRow)q2.iterator().next()).get("$result");
        Assert.assertTrue((boolean)(a2 instanceof Integer));
        Assert.assertEquals((Object)100, (Object)a2);
        this.checkGeneratedRules();
    }

    @Test
    public void testNaiveBayesWithGaussianDistr() throws Exception {
        KieSession kieSession = this.getModelSession(source2, true);
        this.setKSession(kieSession);
        kieSession.fireAllRules();
        kieSession.getEntryPoint("in_Gender").insert((Object)"male");
        kieSession.getEntryPoint("in_AgeOfIndividual").insert((Object)24.0);
        kieSession.getEntryPoint("in_NoOfClaims").insert((Object)"2");
        kieSession.getEntryPoint("in_AgeOfCar").insert((Object)1.0);
        kieSession.fireAllRules();
        System.out.println(this.reportWMObjects(kieSession));
        QueryResults q1 = kieSession.getQueryResults("ProbabilityOf1000", new Object[]{"NaiveBayesInsurance", Variable.v});
        Assert.assertEquals((long)1L, (long)q1.size());
        Object a1 = ((QueryResultsRow)q1.iterator().next()).get("$result");
        Assert.assertTrue((boolean)(a1 instanceof Double));
        Assert.assertEquals((double)0.112, (double)((Double)a1), (double)4.0);
        QueryResults q2 = kieSession.getQueryResults("ChosenClass", new Object[]{"NaiveBayesInsurance", Variable.v});
        Assert.assertEquals((long)1L, (long)q2.size());
        Object a2 = ((QueryResultsRow)q2.iterator().next()).get("$result");
        Assert.assertTrue((boolean)(a2 instanceof Integer));
        Assert.assertEquals((Object)100, (Object)a2);
        this.checkGeneratedRules();
    }
}

