/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import java.math.BigInteger;
import org.dmg.pmml.pmml_4_2.descr.Array;
import org.dmg.pmml.pmml_4_2.descr.CompoundPredicate;
import org.dmg.pmml.pmml_4_2.descr.SimplePredicate;
import org.dmg.pmml.pmml_4_2.descr.SimpleSetPredicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.pmml_4_2.model.mining.CompoundSegmentPredicate;

public class CompoundSegmentPredicateTest {
    private SimplePredicate[] simplePredicate;
    private SimpleSetPredicate[] simpleSetPredicate;

    @Before
    public void setUp() throws Exception {
        this.simplePredicate = new SimplePredicate[3];
        this.simpleSetPredicate = new SimpleSetPredicate[2];
    }

    private void setupSimplePredicate(int index, String fieldName, String operator, String value) {
        if (index < 0 || index >= this.simplePredicate.length) {
            throw new IndexOutOfBoundsException("Invalid index for setting up SimplePredicate");
        }
        this.simplePredicate[index] = new SimplePredicate();
        this.simplePredicate[index].setField(fieldName);
        this.simplePredicate[index].setOperator(operator);
        this.simplePredicate[index].setValue(value);
    }

    private void setupSimpleSetPredicate(int index, String fieldName, String operator, Array values) {
        if (index < 0 || index >= this.simpleSetPredicate.length) {
            throw new IndexOutOfBoundsException("Invalid index for setting up SimpleSetPredicate");
        }
        this.simpleSetPredicate[index] = new SimpleSetPredicate();
        this.simpleSetPredicate[index].setField(fieldName);
        this.simpleSetPredicate[index].setBooleanOperator(operator);
        this.simpleSetPredicate[index].setArray(values);
    }

    private Array getNewArray(String setType, BigInteger count, Object ... objects) {
        Array result = new Array();
        result.setType(setType);
        result.setN(count);
        StringBuilder valueBldr = new StringBuilder();
        for (Object o : objects) {
            if (setType.equalsIgnoreCase("string")) {
                valueBldr.append("'");
            }
            valueBldr.append(o.toString());
            if (setType.equalsIgnoreCase("string")) {
                valueBldr.append("'");
            }
            valueBldr.append(" ");
        }
        result.setContent(valueBldr.toString());
        return result;
    }

    @Test
    public void testSimplePredUsingAnd() {
        CompoundPredicate predicate = new CompoundPredicate();
        predicate.setBooleanOperator("and");
        this.setupSimplePredicate(0, "TF1", "equal", "ABC");
        this.setupSimplePredicate(1, "TF2", "greaterThan", "4");
        for (int x = 0; x < 2; ++x) {
            predicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simplePredicate[x]);
        }
        CompoundSegmentPredicate testPredicate = new CompoundSegmentPredicate(predicate);
        String text = testPredicate.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)text, (Object)"((( mTF1 == false ) && ( vTF1 == \"ABC\" )) && (( mTF2 == false ) && ( vTF2 > 4 )))");
    }

    @Test
    public void testMixedPredUsingAnd() {
        CompoundPredicate predicate = new CompoundPredicate();
        predicate.setBooleanOperator("and");
        this.setupSimplePredicate(0, "TF1", "equal", "ABC");
        Array valueSet = this.getNewArray("int", new BigInteger("3"), 10, 12, 1);
        this.setupSimpleSetPredicate(0, "TF2", "isIn", valueSet);
        predicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simplePredicate[0]);
        predicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simpleSetPredicate[0]);
        CompoundSegmentPredicate testPredicate = new CompoundSegmentPredicate(predicate);
        String text = testPredicate.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)text, (Object)"((( mTF1 == false ) && ( vTF1 == \"ABC\" )) && (( mTF2 == false ) && ( vTF2 in (  10,  12,  1 ) )))");
    }

    @Test
    public void testSimplePredUsingOr() {
        CompoundPredicate predicate = new CompoundPredicate();
        predicate.setBooleanOperator("or");
        this.setupSimplePredicate(0, "TF1", "lessOrEqual", "0");
        this.setupSimplePredicate(1, "TF1", "greaterThan", "4");
        for (int x = 0; x < 2; ++x) {
            predicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simplePredicate[x]);
        }
        CompoundSegmentPredicate testPredicate = new CompoundSegmentPredicate(predicate);
        String text = testPredicate.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)text, (Object)"((( mTF1 == false ) && ( vTF1 <= 0 )) || (( mTF1 == false ) && ( vTF1 > 4 )))");
    }

    @Test
    public void testMixedPredUsingOr() {
        CompoundPredicate predicate = new CompoundPredicate();
        predicate.setBooleanOperator("or");
        this.setupSimplePredicate(0, "TF1", "greaterThan", "100");
        Array valueSet = this.getNewArray("int", new BigInteger("4"), 1, 8, 16, 21);
        this.setupSimpleSetPredicate(0, "TF2", "isNotIn", valueSet);
        predicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simplePredicate[0]);
        predicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simpleSetPredicate[0]);
        CompoundSegmentPredicate testPredicate = new CompoundSegmentPredicate(predicate);
        String text = testPredicate.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)text, (Object)"((( mTF1 == false ) && ( vTF1 > 100 )) || (( mTF2 == false ) && ( vTF2 not in (  1,  8,  16,  21 ) )))");
    }

    @Test
    public void testSimplePredUsingXor() {
        CompoundPredicate predicate = new CompoundPredicate();
        predicate.setBooleanOperator("xor");
        this.setupSimplePredicate(0, "TF1", "lessOrEqual", "0");
        this.setupSimplePredicate(1, "TF1", "greaterThan", "4");
        for (int x = 0; x < 2; ++x) {
            predicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simplePredicate[x]);
        }
        CompoundSegmentPredicate testPredicate = new CompoundSegmentPredicate(predicate);
        String text = testPredicate.getPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)text, (Object)"((( mTF1 == false ) && ( vTF1 <= 0 )) ^ (( mTF1 == false ) && ( vTF1 > 4 )))");
    }

    @Test
    public void testCompoundWithCompound() {
        CompoundPredicate outerPredicate = new CompoundPredicate();
        outerPredicate.setBooleanOperator("or");
        this.setupSimplePredicate(0, "TF1", "lessOrEqual", "150");
        outerPredicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simplePredicate[0]);
        CompoundPredicate innerPredicate = new CompoundPredicate();
        innerPredicate.setBooleanOperator("and");
        this.setupSimplePredicate(1, "TF1", "greaterThan", "150");
        Array valueSet = this.getNewArray("string", new BigInteger("3"), "red", "white", "blue");
        this.setupSimpleSetPredicate(0, "TF2", "isIn", valueSet);
        innerPredicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simplePredicate[1]);
        innerPredicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simpleSetPredicate[0]);
        outerPredicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(innerPredicate);
        CompoundSegmentPredicate testPredicate = new CompoundSegmentPredicate(outerPredicate);
        String text = testPredicate.getPredicateRule();
        Assert.assertNotNull((Object)text);
        StringBuilder bldr = new StringBuilder("(");
        bldr.append("(( mTF1 == false ) && ( vTF1 <= 150 )) || ((");
        bldr.append("(( mTF1 == false ) && ( vTF1 > 150 )) && ");
        bldr.append("(( mTF2 == false ) && ( vTF2 in (  \"red\" ,  \"white\" ,  \"blue\"  ) )))");
        bldr.append("))");
        Assert.assertEquals((Object)bldr.toString(), (Object)text);
    }

    @Test
    public void testSimplePredWithSurrogate() {
        CompoundPredicate outerPredicate = new CompoundPredicate();
        outerPredicate.setBooleanOperator("surrogate");
        this.setupSimplePredicate(0, "TF1", "lessOrEqual", "150");
        outerPredicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simplePredicate[0]);
        CompoundPredicate innerPredicate = new CompoundPredicate();
        innerPredicate.setBooleanOperator("and");
        this.setupSimplePredicate(1, "TF2", "greaterThan", "150");
        Array valueSet = this.getNewArray("string", new BigInteger("3"), "red", "white", "blue");
        this.setupSimpleSetPredicate(0, "TF3", "isIn", valueSet);
        this.setupSimplePredicate(2, "TF4", "greaterOrEqual", "10");
        innerPredicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simplePredicate[1]);
        innerPredicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simpleSetPredicate[0]);
        outerPredicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(innerPredicate);
        outerPredicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates().add(this.simplePredicate[2]);
        CompoundSegmentPredicate testPredicate = new CompoundSegmentPredicate(outerPredicate);
        String text = testPredicate.getPrimaryPredicateRule();
        Assert.assertNotNull((Object)text);
        Assert.assertEquals((Object)text, (Object)"( mTF1 == false ) && ( vTF1 <= 150 )");
        Assert.assertEquals((long)2L, (long)testPredicate.getSubpredicateCount());
        text = testPredicate.getNextPredicateRule(0);
        Assert.assertEquals((Object)text, (Object)"( (mTF1 == true) && ( ((( mTF2 == false ) && ( vTF2 > 150 )) && (( mTF3 == false ) && ( vTF3 in (  \"red\" ,  \"white\" ,  \"blue\"  ) ))) ) )");
    }
}

