/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models.mining;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.io.Resource;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.internal.io.ResourceFactory;
import org.kie.pmml.pmml_4_2.PMML4ExecutionHelper;
import org.kie.pmml.pmml_4_2.PMMLRequestDataBuilder;

@RunWith(value=Parameterized.class)
public class MiningModelChainRegressionTest {
    private static final String PMML_SOURCE = "org/kie/pmml/pmml_4_2/test_mining_model_modelchain_regression.pmml";
    private static final String MINING_MODEL = "SampleMiningModel";
    private static final String INPUT1_FIELD_NAME = "input1";
    private static final String INPUT2_FIELD_NAME = "input2";
    private static final String INPUT3_FIELD_NAME = "input3";
    private static final String OUTPUT_FIELD_NAME = "Result";
    private static final double COMPARISON_DELTA = 0.001;
    private double input1;
    private double input2;
    private double input3;
    private double result;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({5, 4, 3, 1525}, {25, 10, 5, 16305});
    }

    public MiningModelChainRegressionTest(double input1, double input2, double input3, double result) {
        this.input1 = input1;
        this.input2 = input2;
        this.input3 = input3;
        this.result = result;
    }

    @Test
    public void testMiningModelSumRegression() {
        Resource res = ResourceFactory.newClassPathResource((String)PMML_SOURCE);
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)MINING_MODEL, (Resource)res, null, (boolean)true);
        PMMLRequestDataBuilder rdb = new PMMLRequestDataBuilder("1234", MINING_MODEL).addParameter(INPUT1_FIELD_NAME, (Object)this.input1, Double.class).addParameter(INPUT2_FIELD_NAME, (Object)this.input2, Double.class).addParameter(INPUT3_FIELD_NAME, (Object)this.input3, Double.class);
        PMMLRequestData request = rdb.build();
        helper.submitRequest(request);
        helper.getResultData().iterator().forEachRemaining(rd -> {
            Assert.assertEquals((Object)request.getCorrelationId(), (Object)rd.getCorrelationId());
            if (rd.getSegmentationId() == null) {
                Assert.assertEquals((Object)"OK", (Object)rd.getResultCode());
                double value = rd.getResultValue(OUTPUT_FIELD_NAME, "value", Double.class, new Object[0]).orElse(null);
                Assert.assertNotNull((Object)value);
                Assert.assertEquals((double)this.result, (double)value, (double)0.001);
            }
        });
    }
}

