/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.ruleunit.executor.InternalRuleUnitExecutor;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;
import org.kie.pmml.pmml_4_2.DroolsAbstractPMMLTest;
import org.kie.pmml.pmml_4_2.PMML4ExecutionHelper;
import org.kie.pmml.pmml_4_2.PMMLRequestDataBuilder;
import org.kie.pmml.pmml_4_2.model.ScoreCard;
import org.kie.pmml.pmml_4_2.model.mining.SegmentExecution;
import org.kie.pmml.pmml_4_2.model.mining.SegmentExecutionState;
import org.kie.pmml.pmml_4_2.model.tree.AbstractTreeToken;

public class MiningmodelTest
extends DroolsAbstractPMMLTest {
    private static final boolean VERBOSE = true;
    private static final String FILE_BASE = "org/kie/pmml/pmml_4_2/";
    private static final String source1 = "org/kie/pmml/pmml_4_2/test_mining_model_simple.pmml";
    private static final String source2 = "org/kie/pmml/pmml_4_2/test_mining_model_simple2.pmml";
    private static final String source3 = "org/kie/pmml/pmml_4_2/filebased";
    private static final String source4 = "org/kie/pmml/pmml_4_2/test_mining_model_selectall.pmml";
    private static final String source5 = "org/kie/pmml/pmml_4_2/test_mining_model_modelchain.pmml";
    private static final String WEIGHTED_AVG = "org/kie/pmml/pmml_4_2/test_mining_model_weighted_avg.pmml";
    private static final String SUMMED = "org/kie/pmml/pmml_4_2/test_mining_model_summed.pmml";
    private static final String RESOURCES_TEST_ROOT = "src/test/resources/";

    @Test
    public void testSelectFirstSegmentFirst() {
        Resource res = ResourceFactory.newClassPathResource((String)source1);
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SampleMine", (Resource)res, null, (boolean)true);
        PMMLRequestDataBuilder rdb = new PMMLRequestDataBuilder("1234", "SampleMine").addParameter("fld1", (Object)30.0, Double.class).addParameter("fld2", (Object)60.0, Double.class).addParameter("fld3", (Object)"false", String.class).addParameter("fld4", (Object)"optA", String.class);
        PMMLRequestData request = rdb.build();
        PMML4Result resultHolder = helper.submitRequest(request);
        Collection objects = ((InternalRuleUnitExecutor)helper.getExecutor()).getSessionObjects();
        objects.forEach(o -> System.out.println(o));
        helper.getMiningModelPojo().forEach(mmp -> System.out.println(mmp));
        helper.getResultData().iterator().forEachRemaining(rd -> {
            Assert.assertEquals((Object)request.getCorrelationId(), (Object)rd.getCorrelationId());
            if (rd.getSegmentationId() == null) {
                Assert.assertEquals((Object)"OK", (Object)rd.getResultCode());
                Assert.assertNotNull((Object)rd.getResultValue("Fld5", null, new Object[0]));
                String value = rd.getResultValue("Fld5", "value", String.class, new Object[0]).orElse(null);
                Assert.assertEquals((Object)"tgtY", (Object)value);
            }
        });
    }

    @Test
    public void testSelectSecondSegmentFirst() {
        Resource res = ResourceFactory.newClassPathResource((String)source1);
        KieBase kbase = new KieHelper().addResource(res, ResourceType.PMML).build(new KieBaseOption[0]);
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SampleMine", (KieBase)kbase, (boolean)true);
        PMMLRequestData request = new PMMLRequestDataBuilder("1234", "SampleMine").addParameter("fld1", (Object)45.0, Double.class).addParameter("fld2", (Object)60.0, Double.class).addParameter("fld6", (Object)"optA", String.class).build();
        PMML4Result resultHolder = helper.submitRequest(request);
        helper.getResultData().forEach(rd -> {
            Assert.assertEquals((Object)request.getCorrelationId(), (Object)rd.getCorrelationId());
            Assert.assertEquals((Object)"OK", (Object)rd.getResultCode());
            if (rd.getSegmentationId() == null) {
                Assert.assertNotNull((Object)rd.getResultValue("Fld5", null, new Object[0]));
                String value = rd.getResultValue("Fld5", "value", String.class, new Object[0]).orElse(null);
                Assert.assertEquals((Object)"tgtZ", (Object)value);
                AbstractTreeToken token = rd.getResultValue("MissingTreeToken", null, AbstractTreeToken.class, new Object[0]).orElse(null);
                Assert.assertNotNull((Object)token);
                Assert.assertEquals((double)0.6, (double)token.getConfidence(), (double)0.0);
                Assert.assertEquals((Object)"null", (Object)token.getCurrent());
            }
        });
        int segmentsExecuted = 0;
        for (SegmentExecution cms : helper.getChildModelSegments()) {
            Assert.assertEquals((Object)request.getCorrelationId(), (Object)cms.getCorrelationId());
            if (cms.getState() != SegmentExecutionState.COMPLETE) continue;
            ++segmentsExecuted;
        }
        Assert.assertEquals((long)1L, (long)segmentsExecuted);
    }

    @Test
    public void testWithScorecard() {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SampleScorecardMine", (Resource)ResourceFactory.newClassPathResource((String)source2), null, (boolean)true);
        PMMLRequestData request = new PMMLRequestDataBuilder("1234", "SampleScorecardMine").addParameter("age", (Object)33.0, Double.class).addParameter("occupation", (Object)"SKYDIVER", String.class).addParameter("residenceState", (Object)"KN", String.class).addParameter("validLicense", (Object)true, Boolean.class).build();
        PMML4Result resultHolder = helper.submitRequest(request);
        helper.getResultData().forEach(rd -> {
            Assert.assertEquals((Object)request.getCorrelationId(), (Object)rd.getCorrelationId());
            Assert.assertEquals((Object)"OK", (Object)rd.getResultCode());
            if (rd.getSegmentationId() == null) {
                ScoreCard sc = rd.getResultValue("ScoreCard", null, ScoreCard.class, new Object[0]).orElse(null);
                Assert.assertNotNull((Object)sc);
                Map map = sc.getRanking();
                Assert.assertNotNull((Object)map);
                Assert.assertTrue((boolean)(map instanceof LinkedHashMap));
                LinkedHashMap ranking = (LinkedHashMap)map;
                Assert.assertTrue((boolean)ranking.containsKey("LX00"));
                Assert.assertTrue((boolean)ranking.containsKey("RES"));
                Assert.assertTrue((boolean)ranking.containsKey("CX2"));
                Assert.assertEquals((Object)-1.0, ranking.get("LX00"));
                Assert.assertEquals((Object)-10.0, ranking.get("RES"));
                Assert.assertEquals((Object)-30.0, ranking.get("CX2"));
                Iterator iter = ranking.keySet().iterator();
                Assert.assertEquals((Object)"LX00", iter.next());
                Assert.assertEquals((Object)"RES", iter.next());
                Assert.assertEquals((Object)"CX2", iter.next());
            }
        });
        int segmentsExecuted = 0;
        for (SegmentExecution cms : helper.getChildModelSegments()) {
            Assert.assertEquals((Object)request.getCorrelationId(), (Object)cms.getCorrelationId());
            if (cms.getState() != SegmentExecutionState.COMPLETE) continue;
            ++segmentsExecuted;
        }
        Assert.assertEquals((long)1L, (long)segmentsExecuted);
    }

    @Test
    public void testWithRegression() {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SampleScorecardMine", (Resource)ResourceFactory.newClassPathResource((String)source2), null, (boolean)true);
        PMMLRequestData request = new PMMLRequestDataBuilder("123", "SampleScorecardMine").addParameter("fld1r", (Object)1.0, Double.class).addParameter("fld2r", (Object)1.0, Double.class).addParameter("fld3r", (Object)"x", String.class).build();
        PMML4Result resultHolder = helper.submitRequest(request);
        helper.getResultData().forEach(rd -> {
            Assert.assertEquals((Object)request.getCorrelationId(), (Object)rd.getCorrelationId());
            Assert.assertEquals((Object)"OK", (Object)rd.getResultCode());
            if (rd.getSegmentationId() == null) {
                System.out.println(rd);
                Assert.assertNotNull((Object)rd.getResultValue("RegOut", null, new Object[0]));
                String regOutValue = rd.getResultValue("RegOut", "value", String.class, new Object[0]).orElse(null);
                Assert.assertEquals((Object)"catC", (Object)regOutValue);
                Assert.assertNotNull((Object)rd.getResultValue("RegProb", null, new Object[0]));
                Double regProbValue = rd.getResultValue("RegProb", "value", Double.class, new Object[0]).orElse(null);
                Assert.assertEquals((double)0.709228, (double)regProbValue, (double)1.0E-6);
                Assert.assertNotNull((Object)rd.getResultValue("RegProbA", null, new Object[0]));
                Double regProbValueA = rd.getResultValue("RegProbA", "value", Double.class, new Object[0]).orElse(null);
                Assert.assertEquals((double)0.010635, (double)regProbValueA, (double)1.0E-6);
            }
        });
        int segmentsExecuted = 0;
        for (SegmentExecution cms : helper.getChildModelSegments()) {
            Assert.assertEquals((Object)request.getCorrelationId(), (Object)cms.getCorrelationId());
            if (cms.getState() != SegmentExecutionState.COMPLETE) continue;
            ++segmentsExecuted;
        }
        Assert.assertEquals((long)1L, (long)segmentsExecuted);
    }

    @Test
    public void testSelectAll() {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SampleSelectAllMine", (Resource)ResourceFactory.newClassPathResource((String)source4), null, (boolean)true);
        PMMLRequestData request = new PMMLRequestDataBuilder("1234", "SampleSelectAllMine").addParameter("age", (Object)33.0, Double.class).addParameter("occupation", (Object)"SKYDIVER", String.class).addParameter("residenceState", (Object)"KN", String.class).addParameter("validLicense", (Object)true, Boolean.class).build();
        PMML4Result resultHolder = helper.submitRequest(request);
        helper.getResultData().forEach(rd -> {
            Assert.assertEquals((Object)"OK", (Object)rd.getResultCode());
            Assert.assertEquals((Object)request.getCorrelationId(), (Object)rd.getCorrelationId());
            ScoreCard sc = rd.getResultValue("ScoreCard", null, ScoreCard.class, new Object[0]).orElse(null);
            Assert.assertNotNull((Object)sc);
            Map map = sc.getRanking();
            Assert.assertNotNull((Object)map);
            Assert.assertTrue((boolean)(map instanceof LinkedHashMap));
            LinkedHashMap ranking = (LinkedHashMap)map;
            Assert.assertTrue((ranking.containsKey("LX00") || ranking.containsKey("LC00") ? 1 : 0) != 0);
            if (ranking.containsKey("LX00")) {
                Assert.assertTrue((boolean)ranking.containsKey("RES"));
                Assert.assertTrue((boolean)ranking.containsKey("CX2"));
                Assert.assertEquals((Object)-1.0, ranking.get("LX00"));
                Assert.assertEquals((Object)-10.0, ranking.get("RES"));
                Assert.assertEquals((Object)-30.0, ranking.get("CX2"));
                Iterator iter = ranking.keySet().iterator();
                Assert.assertEquals((Object)"LX00", iter.next());
                Assert.assertEquals((Object)"RES", iter.next());
                Assert.assertEquals((Object)"CX2", iter.next());
                Assert.assertEquals((double)41.345, (double)sc.getScore(), (double)1.0E-6);
            } else {
                Assert.assertTrue((boolean)ranking.containsKey("RST"));
                Assert.assertTrue((boolean)ranking.containsKey("DX2"));
                Assert.assertEquals((Object)-1.0, ranking.get("LC00"));
                Assert.assertEquals((Object)10.0, ranking.get("RST"));
                Assert.assertEquals((Object)-30.0, ranking.get("DX2"));
                Iterator iter = ranking.keySet().iterator();
                Assert.assertEquals((Object)"RST", iter.next());
                Assert.assertEquals((Object)"LC00", iter.next());
                Assert.assertEquals((Object)"DX2", iter.next());
                Assert.assertEquals((double)21.345, (double)sc.getScore(), (double)1.0E-6);
            }
        });
        int segmentsExecuted = 0;
        for (SegmentExecution cms : helper.getChildModelSegments()) {
            Assert.assertEquals((Object)request.getCorrelationId(), (Object)cms.getCorrelationId());
            if (cms.getState() != SegmentExecutionState.COMPLETE) continue;
            ++segmentsExecuted;
        }
        Assert.assertEquals((long)2L, (long)segmentsExecuted);
    }

    @Test
    public void testSimpleModelChain() {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SampleModelChainMine", (Resource)ResourceFactory.newClassPathResource((String)source5), null, (boolean)true);
        PMMLRequestData request = new PMMLRequestDataBuilder("1234", "SampleModelChainMine").addParameter("age", (Object)33.0, Double.class).addParameter("occupation", (Object)"TEACHER", String.class).addParameter("residenceState", (Object)"TN", String.class).addParameter("validLicense", (Object)true, Boolean.class).build();
        PMML4Result resultHolder = helper.submitRequest(request);
        Assert.assertEquals((Object)"OK", (Object)resultHolder.getResultCode());
        Map resultVars = resultHolder.getResultVariables();
        Assert.assertNotNull((Object)resultVars);
        Assert.assertTrue((boolean)resultVars.containsKey("QualificationLevel"));
        Assert.assertTrue((boolean)resultVars.containsKey("OverallScore"));
        String qual = resultHolder.getResultValue("QualificationLevel", "value", String.class, new Object[0]).orElse(null);
        Double oscore = resultHolder.getResultValue("OverallScore", "value", Double.class, new Object[0]).orElse(null);
        Assert.assertNotNull((Object)qual);
        Assert.assertNotNull((Object)oscore);
        Assert.assertEquals((Object)"Well", (Object)qual);
        Assert.assertEquals((double)56.345, (double)oscore, (double)1.0E-6);
    }

    @Test
    public void testWeightedAverage() {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SampleMiningModelAvg", (Resource)ResourceFactory.newClassPathResource((String)WEIGHTED_AVG), null, (boolean)true);
        PMMLRequestData request = new PMMLRequestDataBuilder("1234", helper.getModelName()).addParameter("petal_length", (Object)6.45, Double.class).addParameter("petal_width", (Object)1.75, Double.class).addParameter("sepal_width", (Object)1.23, Double.class).build();
        PMML4Result resultHolder = helper.submitRequest(request);
        Double sepal_length = resultHolder.getResultValue("Sepal_length", "value", Double.class, new Object[0]).orElse(null);
        Assert.assertEquals((double)7.1833385, (double)sepal_length, (double)1.0E-6);
        Double weight = resultHolder.getResultValue("Sepal_length", "weight", Double.class, new Object[0]).orElse(null);
        Assert.assertEquals((double)1.0, (double)weight, (double)0.01);
    }

    @Test
    public void testSum() {
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)"SampleMiningModelSum", (Resource)ResourceFactory.newClassPathResource((String)SUMMED), null, (boolean)true);
        PMMLRequestData request = new PMMLRequestDataBuilder("1234", helper.getModelName()).addParameter("petal_length", (Object)6.45, Double.class).addParameter("petal_width", (Object)1.75, Double.class).addParameter("sepal_width", (Object)1.23, Double.class).build();
        PMML4Result resultHolder = helper.submitRequest(request);
        Double sepal_length = resultHolder.getResultValue("Sum_Sepal_length", "value", Double.class, new Object[0]).orElse(null);
        Double total_length = 0.0;
        for (PMML4Result res : helper.getResultData()) {
            Double segSepalLength;
            if (res.getSegmentationId() == null || (segSepalLength = (Double)res.getResultValue("Sepal_length", "value", Double.class, new Object[0]).orElse(null)) == null) continue;
            total_length = total_length + segSepalLength;
        }
        Assert.assertEquals((double)total_length, (double)sepal_length, (double)1.0E-6);
    }
}

