/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.predictive.models.mining;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.io.Resource;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.internal.io.ResourceFactory;
import org.kie.pmml.pmml_4_2.PMML4ExecutionHelper;
import org.kie.pmml.pmml_4_2.PMMLRequestDataBuilder;

@RunWith(value=Parameterized.class)
public class MiningModelSelectFirstTreeTest {
    private static final String PMML_SOURCE = "org/kie/pmml/pmml_4_2/test_mining_model_select_first_tree.pmml";
    private static final String MINING_MODEL = "SampleMiningModel";
    private static final String INPUT1_FIELD_NAME = "input1";
    private static final String INPUT2_FIELD_NAME = "input2";
    private static final String INPUT3_FIELD_NAME = "input3";
    private static final String OUTPUT_FIELD_NAME = "Output";
    private Optional<Double> input1;
    private Optional<Double> input2;
    private Optional<String> input3;
    private String output;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({Optional.of(10.0), Optional.of(10.0), Optional.of("value1"), "class_1"}, {Optional.of(10.0), Optional.of(30.0), Optional.of("value1"), "class_2"}, {Optional.of(10.0), Optional.of(30.0), Optional.empty(), "class_2"}, {Optional.of(40.0), Optional.of(30.0), Optional.of("value1"), "class_3"}, {Optional.of(40.0), Optional.of(45.0), Optional.of("value1"), "class_3"}, {Optional.of(40.0), Optional.of(100.0), Optional.of("value1"), "class_4"}, {Optional.of(40.0), Optional.of(45.0), Optional.of("value2"), "class_4"}, {Optional.of(25.0), Optional.of(45.0), Optional.of("value1"), "class_5"}, {Optional.of(25.0), Optional.empty(), Optional.of("value1"), "class_5"}, {Optional.of(25.0), Optional.empty(), Optional.of("value2"), "class_6"});
    }

    public MiningModelSelectFirstTreeTest(Optional<Double> input1, Optional<Double> input2, Optional<String> input3, String output) {
        this.input1 = input1;
        this.input2 = input2;
        this.input3 = input3;
        this.output = output;
    }

    @Test
    public void testMiningModelSelectFirstTree() {
        Resource res = ResourceFactory.newClassPathResource((String)PMML_SOURCE);
        PMML4ExecutionHelper helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)MINING_MODEL, (Resource)res, null, (boolean)true);
        PMMLRequestDataBuilder rdb = new PMMLRequestDataBuilder("1234", MINING_MODEL);
        this.input1.ifPresent(x -> rdb.addParameter(INPUT1_FIELD_NAME, x, Double.class));
        this.input2.ifPresent(x -> rdb.addParameter(INPUT2_FIELD_NAME, x, Double.class));
        this.input3.ifPresent(x -> rdb.addParameter(INPUT3_FIELD_NAME, x, String.class));
        PMMLRequestData request = rdb.build();
        helper.submitRequest(request);
        helper.getResultData().iterator().forEachRemaining(rd -> {
            Assert.assertEquals((Object)request.getCorrelationId(), (Object)rd.getCorrelationId());
            if (rd.getSegmentationId() == null) {
                Assert.assertEquals((Object)"OK", (Object)rd.getResultCode());
                String value = rd.getResultValue(OUTPUT_FIELD_NAME, "value", String.class, new Object[0]).orElse(null);
                Assert.assertNotNull((Object)value);
                Assert.assertEquals((Object)this.output, (Object)value);
            }
        });
    }
}

