/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.refactoring;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.refactoring.DRLProjectDetector;
import org.drools.eclipse.refactoring.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RuleIFileRenameParticipant
extends RenameParticipant {
    public static final String NAME = "Rule File Rename Refactoring";
    private DRLProjectDetector drlProjectDetector = new DRLProjectDetector();
    private Matcher matcher;
    private RefactoringProcessor processor;
    private List<IFile> drlFiles;
    private IFile file;
    private String newName;
    private String currentName;
    private String packageName;
    private String className;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.file == null || this.file.isReadOnly()) {
            status.addFatalError("File don't exists or is read only");
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange changes = null;
        changes = new CompositeChange("Reorganize DRL " + this.currentName + " Type ");
        this.drlFiles = this.drlProjectDetector.detect(this.file.getProject());
        Pattern pattern = Pattern.compile("(?<=\\.|\\s)" + this.currentName + "(?=\\(|\\r\\n|\\s)");
        Pattern packageImportPattern = Pattern.compile("import[\\s]+" + this.packageName + "\\.*");
        Pattern classImportPattern = Pattern.compile("import[\\s]+" + this.className);
        for (IFile drlFile : this.drlFiles) {
            String content = FileUtil.readFile(drlFile);
            if (content == null) {
                return null;
            }
            if (!packageImportPattern.matcher(content).find() && !classImportPattern.matcher(content).find()) {
                return null;
            }
            this.matcher = pattern.matcher(content);
            TextFileChange change = new TextFileChange(drlFile.getName(), drlFile);
            MultiTextEdit mte = new MultiTextEdit();
            change.setEdit((TextEdit)mte);
            while (this.matcher.find()) {
                ReplaceEdit replace = new ReplaceEdit(this.matcher.start(), this.currentName.length(), this.newName);
                mte.addChild((TextEdit)replace);
            }
            if (change.getEdit().getChildrenSize() <= 0) continue;
            changes.add((Change)change);
        }
        if (changes.getChildren().length == 0) {
            return null;
        }
        return changes.getChildren().length > 0 ? changes : null;
    }

    public String getName() {
        return NAME;
    }

    protected boolean initialize(Object element) {
        IFile file;
        if (element instanceof IFile && (file = (IFile)element).getType() == 1 && file.getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("java")) {
            this.processor = this.getProcessor();
            this.file = file;
            if (this.processor instanceof JavaRenameProcessor) {
                JavaRenameProcessor javaProcessor = (JavaRenameProcessor)this.processor;
                this.newName = javaProcessor.getNewElementName().replace(".java", "");
                this.currentName = javaProcessor.getCurrentElementName();
                try {
                    ICompilationUnit compilationUnit = (ICompilationUnit)javaProcessor.getElements()[0];
                    this.packageName = compilationUnit.getPackageDeclarations()[0].getElementName();
                    this.className = String.valueOf(this.packageName) + "." + this.currentName;
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

