/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.editors;

import org.drools.eclipse.rulebuilder.editors.RuleEditor;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class BrlPage
extends FormPage {
    private static final String PAGE_NAME = "Rule Builder";
    private static final String PAGE_ID = BrlPage.class.getName();
    private RuleModeller modeller;
    private RuleModel model;
    private RuleEditor editor;

    public BrlPage(RuleEditor editor) {
        super((FormEditor)editor, PAGE_ID, PAGE_NAME);
        this.editor = editor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this.modeller = new RuleModeller(form, toolkit, this.model, this.editor);
    }

    public void setModelXML(String xml) {
        this.model = BRXMLPersistence.getInstance().unmarshal(xml);
        this.modeller.setModel(this.model);
        this.modeller.reloadWidgets();
    }

    public RuleModel getRuleModel() {
        return this.model;
    }

    public RuleModeller getModeller() {
        return this.modeller;
    }

    public boolean isDirty() {
        return this.modeller.isDirty();
    }

    public void fireDirtyPropertyChanged() {
        this.editor.dirtyPropertyChanged();
    }

    public void refresh() {
        this.modeller.refresh();
    }
}

