/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.views.model;

import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.guvnor.tools.Activator;
import org.guvnor.tools.GuvnorRepository;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavException;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.views.model.TreeObject;

public class TreeParent
extends TreeObject
implements IDeferredWorkbenchAdapter {
    private ArrayList<TreeObject> children = new ArrayList();

    public TreeParent(String name, TreeObject.Type nodeType) {
        super(name, nodeType);
    }

    public void addChild(TreeObject child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(TreeObject child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public TreeObject[] getChildren() {
        return this.children.toArray(new TreeObject[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        if (!(object instanceof TreeParent)) {
            return;
        }
        TreeParent node = (TreeParent)object;
        if (node.getNodeType() == TreeObject.Type.NONE) {
            List<GuvnorRepository> reps = Activator.getLocationManager().getRepositories();
            monitor.beginTask(Messages.getString("pending"), reps.size());
            int i = 0;
            while (i < reps.size()) {
                TreeParent p = new TreeParent(reps.get(i).getLocation(), TreeObject.Type.REPOSITORY);
                p.setParent(node);
                p.setGuvnorRepository(reps.get(i));
                ResourceProperties props = new ResourceProperties();
                props.setBase("");
                p.setResourceProps(props);
                collector.add((Object)p, monitor);
                monitor.worked(1);
                ++i;
            }
            monitor.done();
        }
        if (node.getNodeType() == TreeObject.Type.REPOSITORY || node.getNodeType() == TreeObject.Type.PACKAGE) {
            this.listDirectory(node, collector, monitor);
        }
    }

    public void listDirectory(TreeParent node, IElementCollector collector, IProgressMonitor monitor) {
        monitor.beginTask(Messages.getString("pending"), 1);
        monitor.worked(1);
        GuvnorRepository rep = node.getGuvnorRepository();
        try {
            Map<String, ResourceProperties> listing;
            block14: {
                IWebDavClient webdav = WebDavServerCache.getWebDavClient(rep.getLocation());
                if (webdav == null) {
                    webdav = WebDavClientFactory.createClient(new URL(rep.getLocation()));
                    WebDavServerCache.cacheWebDavClient(rep.getLocation(), webdav);
                }
                listing = null;
                try {
                    listing = webdav.listDirectory(node.getFullPath());
                }
                catch (WebDavException wde) {
                    if (wde.getErrorCode() != 401) {
                        throw wde;
                    }
                    boolean retry = PlatformUtils.getInstance().authenticateForServer(node.getGuvnorRepository().getLocation(), webdav);
                    if (!retry) break block14;
                    listing = webdav.listDirectory(node.getFullPath());
                }
            }
            if (listing != null) {
                for (String s : listing.keySet()) {
                    ResourceProperties resProps = listing.get(s);
                    TreeObject o = null;
                    o = resProps.isDirectory() ? new TreeParent(s, TreeObject.Type.PACKAGE) : new TreeObject(s, TreeObject.Type.RESOURCE);
                    o.setGuvnorRepository(rep);
                    o.setResourceProps(resProps);
                    node.addChild(o);
                    collector.add((Object)o, monitor);
                }
            }
            monitor.worked(1);
        }
        catch (WebDavException e) {
            if (e.getErrorCode() == 401) {
                PlatformUtils.reportAuthenticationFailure();
            } else if (e.getErrorCode() == 501) {
                Activator.getDefault().displayMessage(4, Messages.getString("rep.connect.fail"));
            } else {
                Activator.getDefault().displayError(4, e.getMessage(), e, true);
            }
        }
        catch (ConnectException connectException) {
            Activator.getDefault().displayMessage(4, Messages.getString("rep.connect.fail"));
        }
        catch (Exception e) {
            Activator.getDefault().displayError(4, e.getMessage(), e, true);
        }
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public Object[] getChildren(Object o) {
        return this.children.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return o.toString();
    }

    public Object getParent(Object o) {
        if (o instanceof TreeObject) {
            return ((TreeObject)o).getParent();
        }
        return null;
    }
}

