/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.core.DefaultRuleGroup;
import org.drools.eclipse.core.DroolsElement;
import org.drools.eclipse.core.Expander;
import org.drools.eclipse.core.Function;
import org.drools.eclipse.core.Global;
import org.drools.eclipse.core.Import;
import org.drools.eclipse.core.Process;
import org.drools.eclipse.core.Query;
import org.drools.eclipse.core.Rule;
import org.drools.eclipse.core.RuleGroup;
import org.drools.eclipse.core.RuleSet;
import org.drools.eclipse.core.Template;

public class Package
extends DroolsElement {
    private String packageName;
    private List rules = new ArrayList();
    private List functions = new ArrayList();
    private List expanders = new ArrayList();
    private List imports = new ArrayList();
    private List globals = new ArrayList();
    private List queries = new ArrayList();
    private List templates = new ArrayList();
    private List processes = new ArrayList();
    private Map groups = new HashMap();
    private DefaultRuleGroup defaultGroup = null;

    Package(RuleSet parent, String packageName) {
        super(parent);
        this.packageName = packageName == null ? "(default package)" : packageName;
        this.defaultGroup = new DefaultRuleGroup(this, null, "MAIN");
    }

    public RuleSet getParentRuleSet() {
        return (RuleSet)this.getParent();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getType() {
        return 1;
    }

    public DroolsElement[] getChildren() {
        ArrayList children = new ArrayList();
        children.addAll(this.rules);
        children.addAll(this.queries);
        children.addAll(this.globals);
        children.addAll(this.functions);
        children.addAll(this.expanders);
        children.addAll(this.imports);
        children.addAll(this.templates);
        children.addAll(this.processes);
        return children.toArray(new DroolsElement[0]);
    }

    public String toString() {
        return this.packageName;
    }

    void addRule(Rule rule) {
        this.rules.add(rule);
    }

    void removeRule(Rule rule) {
        this.rules.remove(rule);
    }

    void addFunction(Function function) {
        this.functions.add(function);
    }

    void removeFunction(Function function) {
        this.functions.remove(function);
    }

    void addExpander(Expander expander) {
        this.expanders.add(expander);
    }

    void removeExpander(Expander expander) {
        this.expanders.remove(expander);
    }

    void addImport(Import imp) {
        this.imports.add(imp);
    }

    void removeImport(Import imp) {
        this.imports.remove(imp);
    }

    void addGlobal(Global global) {
        this.globals.add(global);
    }

    void removeGlobal(Global global) {
        this.globals.remove(global);
    }

    void addQuery(Query query) {
        this.queries.add(query);
    }

    void removeQuery(Query query) {
        this.queries.remove(query);
    }

    void addTemplate(Template template) {
        this.templates.add(template);
    }

    void removeTemplate(Template template) {
        this.templates.remove(template);
    }

    void addProcess(Process process) {
        this.processes.add(process);
    }

    void removeProcess(Process process) {
        this.processes.remove(process);
    }

    public RuleGroup getGroup(String name, int type) {
        Map entries = (Map)this.groups.get(type);
        if (entries != null && entries.containsKey(name)) {
            return (RuleGroup)entries.get(name);
        }
        return null;
    }

    void addGroup(RuleGroup group) {
        HashMap<String, RuleGroup> entries = (HashMap<String, RuleGroup>)this.groups.get(group.getType());
        if (entries == null) {
            entries = new HashMap<String, RuleGroup>();
            entries.put(group.toString(), group);
            this.groups.put(group.getType(), entries);
        } else if (!entries.containsKey(group.toString())) {
            entries.put(group.toString(), group);
        }
    }

    public RuleGroup getDefaultGroup() {
        return this.defaultGroup;
    }

    void removeGroup(RuleGroup group) {
        Map entries = (Map)this.groups.get(group.getType());
        if (entries.containsValue(group)) {
            entries.remove(group);
        }
    }

    public DroolsElement[] getGroups() {
        ArrayList returnedValue = new ArrayList();
        Iterator it = this.groups.keySet().iterator();
        while (it.hasNext()) {
            int key = (Integer)it.next();
            Map entries = (Map)this.groups.get(key);
            returnedValue.addAll(entries.values());
        }
        return returnedValue.toArray(new DroolsElement[0]);
    }
}

