/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.views.model.TreeObject;
import org.guvnor.tools.views.model.TreeParent;

public class RepositoryLabelProvider
extends LabelProvider {
    private Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

    public String getText(Object obj) {
        if (obj instanceof PendingUpdateAdapter) {
            return Messages.getString("pending");
        }
        if (obj instanceof TreeParent) {
            switch (((TreeParent)obj).getNodeType()) {
                case GLOBALS: {
                    return "Global Area";
                }
                case SNAPSHOTS: {
                    return "Snapshots";
                }
                case PACKAGES: {
                    return "Packages";
                }
            }
            return this.stripTrailingSlash(obj.toString());
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        Image res = null;
        if (obj instanceof TreeObject) {
            switch (((TreeObject)obj).getNodeType()) {
                case REPOSITORY: {
                    res = Activator.getDefault().getImageRegistry().get("guvnor_rep.gif");
                    break;
                }
                case GLOBALS: 
                case PACKAGES: 
                case SNAPSHOTS: {
                    res = Activator.getDefault().getImageRegistry().get("chart_organisation.gif");
                    break;
                }
                case PACKAGE: {
                    res = Activator.getDefault().getImageRegistry().get("package.gif");
                    break;
                }
                case SNAPSHOT_PACKAGE: {
                    res = Activator.getDefault().getImageRegistry().get("snapshot_small.gif");
                    break;
                }
                case SNAPSHOT: {
                    res = Activator.getDefault().getImageRegistry().get("details.gif");
                    break;
                }
                case RESOURCE: {
                    ImageDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.patchExtension(((TreeObject)obj).getName()));
                    if (descriptor == null) {
                        res = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                        break;
                    }
                    res = this.images.get(descriptor);
                    if (res == null) {
                        res = descriptor.createImage();
                        this.images.put(descriptor, res);
                    }
                    res = descriptor.createImage();
                }
            }
        }
        return res != null ? res : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }

    public void dispose() {
        for (Image image : this.images.values()) {
            try {
                image.dispose();
            }
            catch (Exception exception) {}
        }
        this.images.clear();
        super.dispose();
    }

    private String patchExtension(String name) {
        int index = name.lastIndexOf(".xmlschema");
        if (index > -1) {
            return String.valueOf(name.substring(0, index)) + ".xsd";
        }
        return name;
    }

    private String stripTrailingSlash(String name) {
        if (name.endsWith("/")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }
}

