/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.scanners;

import java.util.ArrayList;
import org.drools.eclipse.editors.ColorManager;
import org.drools.eclipse.editors.Keywords;
import org.drools.eclipse.editors.scanners.RuleWordDetector;
import org.drools.eclipse.editors.scanners.WhitespaceDetector;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;

public class DRLScanner
extends RuleBasedScanner {
    private static final Color KEYWORD_COLOR = ColorManager.getInstance().getColor(ColorManager.KEYWORD);
    private static final Color COMMENT_COLOR = ColorManager.getInstance().getColor(ColorManager.SINGLE_LINE_COMMENT);
    private static final Color STRING_COLOR = ColorManager.getInstance().getColor(ColorManager.STRING);
    private static final String[] DROOLS_KEYWORDS = Keywords.getInstance().getAllDroolsKeywords();
    private static final String[] JAVA_KEYWORDS = Keywords.getInstance().getAllJavaKeywords();
    private static final String[] MVEL_KEYWORDS = Keywords.getInstance().getAllMvelKeywords();
    private static final String[] JAVA_TYPES = new String[]{"void", "boolean", "char", "byte", "short", "strictfp", "int", "long", "float", "double"};
    private static final String[] JAVA_CONSTANTS = new String[]{"false", "true", "null"};
    private static final String[] MVEL_CONSTANTS = new String[]{"false", "true", "null", "nil", "empty", "this"};

    public DRLScanner() {
        Token keyword = new Token((Object)new TextAttribute(KEYWORD_COLOR, null, 1));
        Token comment = new Token((Object)new TextAttribute(COMMENT_COLOR));
        Token string = new Token((Object)new TextAttribute(STRING_COLOR));
        Token other = new Token(null);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new EndOfLineRule("#", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new RuleWordDetector(), (IToken)other);
        int i = 0;
        while (i < DROOLS_KEYWORDS.length) {
            wordRule.addWord(DROOLS_KEYWORDS[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < JAVA_KEYWORDS.length) {
            wordRule.addWord(JAVA_KEYWORDS[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < JAVA_TYPES.length) {
            wordRule.addWord(JAVA_TYPES[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < JAVA_CONSTANTS.length) {
            wordRule.addWord(JAVA_CONSTANTS[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < MVEL_KEYWORDS.length) {
            wordRule.addWord(MVEL_KEYWORDS[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < MVEL_CONSTANTS.length) {
            wordRule.addWord(MVEL_CONSTANTS[i], (IToken)keyword);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

